/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import org.apache.wicket.util.file.Files;

public class Connections {
    private Connections() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Instant getLastModified(URL url) throws IOException {
        File file = Files.getLocalFileFromUrl(url);
        if (file != null) {
            return Files.getLastModified(file);
        }
        URLConnection connection = url.openConnection();
        try {
            Instant instant;
            long milliseconds;
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarUrlConnection = (JarURLConnection)connection;
                URL jarFileUrl = jarUrlConnection.getJarFileURL();
                URLConnection jarFileConnection = jarFileUrl.openConnection();
                jarFileConnection.setDoInput(false);
                milliseconds = jarFileConnection.getLastModified();
            } else {
                milliseconds = connection.getLastModified();
            }
            if (milliseconds == 0L) {
                instant = null;
                return instant;
            }
            instant = Instant.ofEpochMilli(milliseconds);
            return instant;
        }
        finally {
            Connections.closeQuietly(connection);
        }
    }

    public static void closeQuietly(URLConnection connection) {
        try {
            Connections.close(connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(URLConnection connection) throws IOException {
        InputStream inputStream;
        if (connection == null) {
            return;
        }
        String protocol = connection.getURL().getProtocol();
        if ("file".equals(protocol) && (inputStream = connection.getInputStream()) != null) {
            inputStream.close();
        }
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }
}

