/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.internals.ProducerIdAndEpoch;
import org.apache.kafka.clients.producer.internals.TransactionalRequestResult;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private static final Logger log = LoggerFactory.getLogger(TransactionManager.class);
    private static final int NO_INFLIGHT_REQUEST_CORRELATION_ID = -1;
    private final String transactionalId;
    private final int transactionTimeoutMs;
    public final String logPrefix;
    private final Map<TopicPartition, Integer> sequenceNumbers;
    private final PriorityQueue<TxnRequestHandler> pendingRequests;
    private final Set<TopicPartition> newPartitionsInTransaction;
    private final Set<TopicPartition> pendingPartitionsInTransaction;
    private final Set<TopicPartition> partitionsInTransaction;
    private final Map<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> pendingTxnOffsetCommits;
    private final long retryBackoffMs;
    private static final long ADD_PARTITIONS_RETRY_BACKOFF_MS = 20L;
    private int inFlightRequestCorrelationId = -1;
    private Node transactionCoordinator;
    private Node consumerGroupCoordinator;
    private volatile State currentState = State.UNINITIALIZED;
    private volatile RuntimeException lastError = null;
    private volatile ProducerIdAndEpoch producerIdAndEpoch = new ProducerIdAndEpoch(-1L, -1);
    private volatile boolean transactionStarted = false;

    public TransactionManager(String transactionalId, int transactionTimeoutMs, long retryBackoffMs) {
        this.sequenceNumbers = new HashMap<TopicPartition, Integer>();
        this.transactionalId = transactionalId;
        this.logPrefix = transactionalId == null ? "" : "[TransactionalId " + transactionalId + "] ";
        this.transactionTimeoutMs = transactionTimeoutMs;
        this.transactionCoordinator = null;
        this.consumerGroupCoordinator = null;
        this.newPartitionsInTransaction = new HashSet<TopicPartition>();
        this.pendingPartitionsInTransaction = new HashSet<TopicPartition>();
        this.partitionsInTransaction = new HashSet<TopicPartition>();
        this.pendingTxnOffsetCommits = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
        this.pendingRequests = new PriorityQueue<TxnRequestHandler>(10, new Comparator<TxnRequestHandler>(){

            @Override
            public int compare(TxnRequestHandler o1, TxnRequestHandler o2) {
                return Integer.compare(o1.priority().priority, o2.priority().priority);
            }
        });
        this.retryBackoffMs = retryBackoffMs;
    }

    TransactionManager() {
        this(null, 0, 100L);
    }

    public synchronized TransactionalRequestResult initializeTransactions() {
        this.ensureTransactional();
        this.transitionTo(State.INITIALIZING);
        this.setProducerIdAndEpoch(ProducerIdAndEpoch.NONE);
        this.sequenceNumbers.clear();
        InitProducerIdRequest.Builder builder = new InitProducerIdRequest.Builder(this.transactionalId, this.transactionTimeoutMs);
        InitProducerIdHandler handler = new InitProducerIdHandler(builder);
        this.enqueueRequest(handler);
        return handler.result;
    }

    public synchronized void beginTransaction() {
        this.ensureTransactional();
        this.maybeFailWithError();
        this.transitionTo(State.IN_TRANSACTION);
    }

    public synchronized TransactionalRequestResult beginCommit() {
        this.ensureTransactional();
        this.maybeFailWithError();
        this.transitionTo(State.COMMITTING_TRANSACTION);
        return this.beginCompletingTransaction(TransactionResult.COMMIT);
    }

    public synchronized TransactionalRequestResult beginAbort() {
        this.ensureTransactional();
        if (this.currentState != State.ABORTABLE_ERROR) {
            this.maybeFailWithError();
        }
        this.transitionTo(State.ABORTING_TRANSACTION);
        this.newPartitionsInTransaction.clear();
        return this.beginCompletingTransaction(TransactionResult.ABORT);
    }

    private TransactionalRequestResult beginCompletingTransaction(TransactionResult transactionResult) {
        if (!this.newPartitionsInTransaction.isEmpty()) {
            this.enqueueRequest(this.addPartitionsToTransactionHandler());
        }
        EndTxnRequest.Builder builder = new EndTxnRequest.Builder(this.transactionalId, this.producerIdAndEpoch.producerId, this.producerIdAndEpoch.epoch, transactionResult);
        EndTxnHandler handler = new EndTxnHandler(builder);
        this.enqueueRequest(handler);
        return handler.result;
    }

    public synchronized TransactionalRequestResult sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        this.ensureTransactional();
        this.maybeFailWithError();
        if (this.currentState != State.IN_TRANSACTION) {
            throw new KafkaException("Cannot send offsets to transaction either because the producer is not in an active transaction");
        }
        log.debug("{}Begin adding offsets {} for consumer group {} to transaction", new Object[]{this.logPrefix, offsets, consumerGroupId});
        AddOffsetsToTxnRequest.Builder builder = new AddOffsetsToTxnRequest.Builder(this.transactionalId, this.producerIdAndEpoch.producerId, this.producerIdAndEpoch.epoch, consumerGroupId);
        AddOffsetsToTxnHandler handler = new AddOffsetsToTxnHandler(builder, offsets);
        this.enqueueRequest(handler);
        return handler.result;
    }

    public synchronized void maybeAddPartitionToTransaction(TopicPartition topicPartition) {
        this.failIfNotReadyForSend();
        if (this.isPartitionAdded(topicPartition) || this.isPartitionPendingAdd(topicPartition)) {
            return;
        }
        log.debug("{}Begin adding new partition {} to transaction", (Object)this.logPrefix, (Object)topicPartition);
        this.newPartitionsInTransaction.add(topicPartition);
    }

    RuntimeException lastError() {
        return this.lastError;
    }

    public synchronized void failIfNotReadyForSend() {
        if (this.hasError()) {
            throw new KafkaException("Cannot perform send because at least one previous transactional or idempotent request has failed with errors.", this.lastError);
        }
        if (this.isTransactional()) {
            if (!this.hasProducerId()) {
                throw new IllegalStateException("Cannot perform a 'send' before completing a call to initTransactions when transactions are enabled.");
            }
            if (this.currentState != State.IN_TRANSACTION) {
                throw new IllegalStateException("Cannot call send in state " + (Object)((Object)this.currentState));
            }
        }
    }

    synchronized boolean isSendToPartitionAllowed(TopicPartition tp) {
        if (this.hasFatalError()) {
            return false;
        }
        return !this.isTransactional() || this.partitionsInTransaction.contains(tp);
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public boolean hasProducerId() {
        return this.producerIdAndEpoch.isValid();
    }

    public boolean isTransactional() {
        return this.transactionalId != null;
    }

    synchronized boolean hasPartitionsToAdd() {
        return !this.newPartitionsInTransaction.isEmpty() || !this.pendingPartitionsInTransaction.isEmpty();
    }

    synchronized boolean isCompleting() {
        return this.currentState == State.COMMITTING_TRANSACTION || this.currentState == State.ABORTING_TRANSACTION;
    }

    synchronized boolean hasError() {
        return this.currentState == State.ABORTABLE_ERROR || this.currentState == State.FATAL_ERROR;
    }

    synchronized boolean isAborting() {
        return this.currentState == State.ABORTING_TRANSACTION;
    }

    synchronized void transitionToAbortableError(RuntimeException exception) {
        if (this.currentState == State.ABORTING_TRANSACTION) {
            log.debug("Skipping transition to abortable error state since the transaction is already being aborted. Underlying exception: ", (Throwable)exception);
            return;
        }
        this.transitionTo(State.ABORTABLE_ERROR, exception);
    }

    synchronized void transitionToFatalError(RuntimeException exception) {
        this.transitionTo(State.FATAL_ERROR, exception);
    }

    synchronized boolean isPartitionAdded(TopicPartition partition) {
        return this.partitionsInTransaction.contains(partition);
    }

    synchronized boolean isPartitionPendingAdd(TopicPartition partition) {
        return this.newPartitionsInTransaction.contains(partition) || this.pendingPartitionsInTransaction.contains(partition);
    }

    ProducerIdAndEpoch producerIdAndEpoch() {
        return this.producerIdAndEpoch;
    }

    boolean hasProducerId(long producerId) {
        return this.producerIdAndEpoch.producerId == producerId;
    }

    boolean hasProducerIdAndEpoch(long producerId, short producerEpoch) {
        ProducerIdAndEpoch idAndEpoch = this.producerIdAndEpoch;
        return idAndEpoch.producerId == producerId && idAndEpoch.epoch == producerEpoch;
    }

    void setProducerIdAndEpoch(ProducerIdAndEpoch producerIdAndEpoch) {
        log.info("{}ProducerId set to {} with epoch {}", new Object[]{this.logPrefix, producerIdAndEpoch.producerId, producerIdAndEpoch.epoch});
        this.producerIdAndEpoch = producerIdAndEpoch;
    }

    synchronized void resetProducerId() {
        if (this.isTransactional()) {
            throw new IllegalStateException("Cannot reset producer state for a transactional producer. You must either abort the ongoing transaction or reinitialize the transactional producer instead");
        }
        this.setProducerIdAndEpoch(ProducerIdAndEpoch.NONE);
        this.sequenceNumbers.clear();
    }

    synchronized Integer sequenceNumber(TopicPartition topicPartition) {
        Integer currentSequenceNumber = this.sequenceNumbers.get(topicPartition);
        if (currentSequenceNumber == null) {
            currentSequenceNumber = 0;
            this.sequenceNumbers.put(topicPartition, currentSequenceNumber);
        }
        return currentSequenceNumber;
    }

    synchronized void incrementSequenceNumber(TopicPartition topicPartition, int increment) {
        Integer currentSequenceNumber = this.sequenceNumbers.get(topicPartition);
        if (currentSequenceNumber == null) {
            throw new IllegalStateException("Attempt to increment sequence number for a partition with no current sequence.");
        }
        currentSequenceNumber = currentSequenceNumber + increment;
        this.sequenceNumbers.put(topicPartition, currentSequenceNumber);
    }

    synchronized TxnRequestHandler nextRequestHandler(boolean hasIncompleteBatches) {
        TxnRequestHandler nextRequestHandler;
        if (!this.newPartitionsInTransaction.isEmpty()) {
            this.enqueueRequest(this.addPartitionsToTransactionHandler());
        }
        if ((nextRequestHandler = this.pendingRequests.peek()) == null) {
            return null;
        }
        if (nextRequestHandler.isEndTxn() && hasIncompleteBatches) {
            return null;
        }
        this.pendingRequests.poll();
        if (this.maybeTerminateRequestWithError(nextRequestHandler)) {
            log.trace("{}Not sending transactional request {} because we are in an error state", (Object)this.logPrefix, nextRequestHandler.requestBuilder());
            return null;
        }
        if (nextRequestHandler.isEndTxn() && !this.transactionStarted) {
            nextRequestHandler.result.done();
            if (this.currentState != State.FATAL_ERROR) {
                log.debug("{}Not sending EndTxn for completed transaction since no partitions or offsets were successfully added", (Object)this.logPrefix);
                this.completeTransaction();
            }
            nextRequestHandler = this.pendingRequests.poll();
        }
        if (nextRequestHandler != null) {
            log.trace("{}Request {} dequeued for sending", (Object)this.logPrefix, nextRequestHandler.requestBuilder());
        }
        return nextRequestHandler;
    }

    synchronized void retry(TxnRequestHandler request) {
        request.setRetry();
        this.enqueueRequest(request);
    }

    Node coordinator(FindCoordinatorRequest.CoordinatorType type) {
        switch (type) {
            case GROUP: {
                return this.consumerGroupCoordinator;
            }
            case TRANSACTION: {
                return this.transactionCoordinator;
            }
        }
        throw new IllegalStateException("Received an invalid coordinator type: " + (Object)((Object)type));
    }

    void lookupCoordinator(TxnRequestHandler request) {
        this.lookupCoordinator(request.coordinatorType(), request.coordinatorKey());
    }

    void setInFlightRequestCorrelationId(int correlationId) {
        this.inFlightRequestCorrelationId = correlationId;
    }

    void clearInFlightRequestCorrelationId() {
        this.inFlightRequestCorrelationId = -1;
    }

    boolean hasInFlightRequest() {
        return this.inFlightRequestCorrelationId != -1;
    }

    boolean hasFatalError() {
        return this.currentState == State.FATAL_ERROR;
    }

    boolean hasAbortableError() {
        return this.currentState == State.ABORTABLE_ERROR;
    }

    synchronized boolean transactionContainsPartition(TopicPartition topicPartition) {
        return this.partitionsInTransaction.contains(topicPartition);
    }

    synchronized boolean hasPendingOffsetCommits() {
        return !this.pendingTxnOffsetCommits.isEmpty();
    }

    synchronized boolean hasOngoingTransaction() {
        return this.currentState == State.IN_TRANSACTION || this.isCompleting() || this.hasAbortableError();
    }

    synchronized boolean isReady() {
        return this.isTransactional() && this.currentState == State.READY;
    }

    private void transitionTo(State target) {
        this.transitionTo(target, null);
    }

    private synchronized void transitionTo(State target, RuntimeException error) {
        if (!this.currentState.isTransitionValid(this.currentState, target)) {
            String idString = this.transactionalId == null ? "" : "TransactionalId " + this.transactionalId + ": ";
            throw new KafkaException(idString + "Invalid transition attempted from state " + this.currentState.name() + " to state " + target.name());
        }
        if (target == State.FATAL_ERROR || target == State.ABORTABLE_ERROR) {
            if (error == null) {
                throw new IllegalArgumentException("Cannot transition to " + (Object)((Object)target) + " with an null exception");
            }
            this.lastError = error;
        } else {
            this.lastError = null;
        }
        if (this.lastError != null) {
            log.debug("{}Transition from state {} to error state {}", new Object[]{this.logPrefix, this.currentState, target, this.lastError});
        } else {
            log.debug("{}Transition from state {} to {}", new Object[]{this.logPrefix, this.currentState, target});
        }
        this.currentState = target;
    }

    private void ensureTransactional() {
        if (!this.isTransactional()) {
            throw new IllegalStateException("Transactional method invoked on a non-transactional producer.");
        }
    }

    private void maybeFailWithError() {
        if (this.hasError()) {
            throw new KafkaException("Cannot execute transactional method because we are in an error state", this.lastError);
        }
    }

    private boolean maybeTerminateRequestWithError(TxnRequestHandler requestHandler) {
        if (this.hasError()) {
            if (this.hasAbortableError() && requestHandler instanceof FindCoordinatorHandler) {
                return false;
            }
            requestHandler.fail(this.lastError);
            return true;
        }
        return false;
    }

    private void enqueueRequest(TxnRequestHandler requestHandler) {
        log.debug("{}Enqueuing transactional request {}", (Object)this.logPrefix, requestHandler.requestBuilder());
        this.pendingRequests.add(requestHandler);
    }

    private synchronized void lookupCoordinator(FindCoordinatorRequest.CoordinatorType type, String coordinatorKey) {
        switch (type) {
            case GROUP: {
                this.consumerGroupCoordinator = null;
                break;
            }
            case TRANSACTION: {
                this.transactionCoordinator = null;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid coordinator type: " + (Object)((Object)type));
            }
        }
        FindCoordinatorRequest.Builder builder = new FindCoordinatorRequest.Builder(type, coordinatorKey);
        this.enqueueRequest(new FindCoordinatorHandler(builder));
    }

    private synchronized void completeTransaction() {
        this.transitionTo(State.READY);
        this.lastError = null;
        this.transactionStarted = false;
        this.newPartitionsInTransaction.clear();
        this.pendingPartitionsInTransaction.clear();
        this.partitionsInTransaction.clear();
    }

    private synchronized TxnRequestHandler addPartitionsToTransactionHandler() {
        this.pendingPartitionsInTransaction.addAll(this.newPartitionsInTransaction);
        this.newPartitionsInTransaction.clear();
        AddPartitionsToTxnRequest.Builder builder = new AddPartitionsToTxnRequest.Builder(this.transactionalId, this.producerIdAndEpoch.producerId, this.producerIdAndEpoch.epoch, new ArrayList<TopicPartition>(this.pendingPartitionsInTransaction));
        return new AddPartitionsToTxnHandler(builder);
    }

    private TxnOffsetCommitHandler txnOffsetCommitHandler(TransactionalRequestResult result, Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            OffsetAndMetadata offsetAndMetadata = entry.getValue();
            TxnOffsetCommitRequest.CommittedOffset committedOffset = new TxnOffsetCommitRequest.CommittedOffset(offsetAndMetadata.offset(), offsetAndMetadata.metadata());
            this.pendingTxnOffsetCommits.put(entry.getKey(), committedOffset);
        }
        TxnOffsetCommitRequest.Builder builder = new TxnOffsetCommitRequest.Builder(this.transactionalId, consumerGroupId, this.producerIdAndEpoch.producerId, this.producerIdAndEpoch.epoch, this.pendingTxnOffsetCommits);
        return new TxnOffsetCommitHandler(result, builder);
    }

    private class TxnOffsetCommitHandler
    extends TxnRequestHandler {
        private final TxnOffsetCommitRequest.Builder builder;

        private TxnOffsetCommitHandler(TransactionalRequestResult result, TxnOffsetCommitRequest.Builder builder) {
            super(result);
            this.builder = builder;
        }

        TxnOffsetCommitRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.ADD_PARTITIONS_OR_OFFSETS;
        }

        @Override
        FindCoordinatorRequest.CoordinatorType coordinatorType() {
            return FindCoordinatorRequest.CoordinatorType.GROUP;
        }

        @Override
        String coordinatorKey() {
            return this.builder.consumerGroupId();
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            TxnOffsetCommitResponse txnOffsetCommitResponse = (TxnOffsetCommitResponse)response;
            boolean coordinatorReloaded = false;
            boolean hadFailure = false;
            Map<TopicPartition, Errors> errors = txnOffsetCommitResponse.errors();
            for (Map.Entry<TopicPartition, Errors> entry : errors.entrySet()) {
                TopicPartition topicPartition = entry.getKey();
                Errors error = entry.getValue();
                if (error == Errors.NONE) {
                    log.debug("{}Successfully added offsets {} from consumer group {} to transaction.", new Object[]{TransactionManager.this.logPrefix, this.builder.offsets(), this.builder.consumerGroupId()});
                    TransactionManager.this.pendingTxnOffsetCommits.remove(topicPartition);
                    continue;
                }
                if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR || error == Errors.REQUEST_TIMED_OUT) {
                    hadFailure = true;
                    if (coordinatorReloaded) continue;
                    coordinatorReloaded = true;
                    TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.GROUP, this.builder.consumerGroupId());
                    continue;
                }
                if (error == Errors.UNKNOWN_TOPIC_OR_PARTITION) {
                    hadFailure = true;
                    continue;
                }
                if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                    this.abortableError(new GroupAuthorizationException(this.builder.consumerGroupId()));
                    return;
                }
                if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED || error == Errors.INVALID_PRODUCER_EPOCH || error == Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT) {
                    this.fatalError(error.exception());
                    return;
                }
                this.fatalError(new KafkaException("Unexpected error in TxnOffsetCommitResponse: " + error.message()));
                return;
            }
            if (!hadFailure || !this.result.isSuccessful()) {
                this.result.done();
                return;
            }
            if (!TransactionManager.this.pendingTxnOffsetCommits.isEmpty()) {
                this.reenqueue();
            }
        }
    }

    private class AddOffsetsToTxnHandler
    extends TxnRequestHandler {
        private final AddOffsetsToTxnRequest.Builder builder;
        private final Map<TopicPartition, OffsetAndMetadata> offsets;

        private AddOffsetsToTxnHandler(AddOffsetsToTxnRequest.Builder builder, Map<TopicPartition, OffsetAndMetadata> offsets) {
            this.builder = builder;
            this.offsets = offsets;
        }

        AddOffsetsToTxnRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.ADD_PARTITIONS_OR_OFFSETS;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            AddOffsetsToTxnResponse addOffsetsToTxnResponse = (AddOffsetsToTxnResponse)response;
            Errors error = addOffsetsToTxnResponse.error();
            if (error == Errors.NONE) {
                log.debug("{}Successfully added partition for consumer group {} to transaction", (Object)TransactionManager.this.logPrefix, (Object)this.builder.consumerGroupId());
                TransactionManager.this.pendingRequests.add(TransactionManager.this.txnOffsetCommitHandler(this.result, this.offsets, this.builder.consumerGroupId()));
                TransactionManager.this.transactionStarted = true;
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                this.reenqueue();
            } else if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.CONCURRENT_TRANSACTIONS) {
                this.reenqueue();
            } else if (error == Errors.INVALID_PRODUCER_EPOCH) {
                this.fatalError(error.exception());
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                this.abortableError(new GroupAuthorizationException(this.builder.consumerGroupId()));
            } else {
                this.fatalError(new KafkaException("Unexpected error in AddOffsetsToTxnResponse: " + error.message()));
            }
        }
    }

    private class EndTxnHandler
    extends TxnRequestHandler {
        private final EndTxnRequest.Builder builder;

        private EndTxnHandler(EndTxnRequest.Builder builder) {
            this.builder = builder;
        }

        EndTxnRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.END_TXN;
        }

        @Override
        boolean isEndTxn() {
            return true;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            EndTxnResponse endTxnResponse = (EndTxnResponse)response;
            Errors error = endTxnResponse.error();
            if (error == Errors.NONE) {
                TransactionManager.this.completeTransaction();
                this.result.done();
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                this.reenqueue();
            } else if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.CONCURRENT_TRANSACTIONS) {
                this.reenqueue();
            } else if (error == Errors.INVALID_PRODUCER_EPOCH) {
                this.fatalError(error.exception());
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else if (error == Errors.INVALID_TXN_STATE) {
                this.fatalError(error.exception());
            } else {
                this.fatalError(new KafkaException("Unhandled error in EndTxnResponse: " + error.message()));
            }
        }
    }

    private class FindCoordinatorHandler
    extends TxnRequestHandler {
        private final FindCoordinatorRequest.Builder builder;

        private FindCoordinatorHandler(FindCoordinatorRequest.Builder builder) {
            this.builder = builder;
        }

        FindCoordinatorRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.FIND_COORDINATOR;
        }

        @Override
        FindCoordinatorRequest.CoordinatorType coordinatorType() {
            return null;
        }

        @Override
        String coordinatorKey() {
            return null;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            FindCoordinatorResponse findCoordinatorResponse = (FindCoordinatorResponse)response;
            Errors error = findCoordinatorResponse.error();
            if (error == Errors.NONE) {
                Node node = findCoordinatorResponse.node();
                switch (this.builder.coordinatorType()) {
                    case GROUP: {
                        TransactionManager.this.consumerGroupCoordinator = node;
                        break;
                    }
                    case TRANSACTION: {
                        TransactionManager.this.transactionCoordinator = node;
                    }
                }
                this.result.done();
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE) {
                this.reenqueue();
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else if (findCoordinatorResponse.error() == Errors.GROUP_AUTHORIZATION_FAILED) {
                this.abortableError(new GroupAuthorizationException(this.builder.coordinatorKey()));
            } else {
                this.fatalError(new KafkaException(String.format("Could not find a coordinator with type %s with key %s due tounexpected error: %s", new Object[]{this.builder.coordinatorType(), this.builder.coordinatorKey(), findCoordinatorResponse.error().message()})));
            }
        }
    }

    private class AddPartitionsToTxnHandler
    extends TxnRequestHandler {
        private final AddPartitionsToTxnRequest.Builder builder;
        private long retryBackoffMs;

        private AddPartitionsToTxnHandler(AddPartitionsToTxnRequest.Builder builder) {
            this.builder = builder;
            this.retryBackoffMs = TransactionManager.this.retryBackoffMs;
        }

        AddPartitionsToTxnRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.ADD_PARTITIONS_OR_OFFSETS;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            AddPartitionsToTxnResponse addPartitionsToTxnResponse = (AddPartitionsToTxnResponse)response;
            Map<TopicPartition, Errors> errors = addPartitionsToTxnResponse.errors();
            boolean hasPartitionErrors = false;
            HashSet<String> unauthorizedTopics = new HashSet<String>();
            this.retryBackoffMs = TransactionManager.this.retryBackoffMs;
            for (Map.Entry<TopicPartition, Errors> topicPartitionErrorEntry : errors.entrySet()) {
                TopicPartition topicPartition = topicPartitionErrorEntry.getKey();
                Errors error = topicPartitionErrorEntry.getValue();
                if (error == Errors.NONE) continue;
                if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                    TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                    this.reenqueue();
                    return;
                }
                if (error == Errors.CONCURRENT_TRANSACTIONS) {
                    this.maybeOverrideRetryBackoffMs();
                    this.reenqueue();
                    return;
                }
                if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.UNKNOWN_TOPIC_OR_PARTITION) {
                    this.reenqueue();
                    return;
                }
                if (error == Errors.INVALID_PRODUCER_EPOCH) {
                    this.fatalError(error.exception());
                    return;
                }
                if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                    this.fatalError(error.exception());
                    return;
                }
                if (error == Errors.INVALID_PRODUCER_ID_MAPPING || error == Errors.INVALID_TXN_STATE) {
                    this.fatalError(new KafkaException(error.exception()));
                    return;
                }
                if (error == Errors.TOPIC_AUTHORIZATION_FAILED) {
                    unauthorizedTopics.add(topicPartition.topic());
                    continue;
                }
                if (error == Errors.OPERATION_NOT_ATTEMPTED) {
                    log.debug("{}Did not attempt to add partition {} to transaction because other partitions in the batch had errors.", (Object)TransactionManager.this.logPrefix, (Object)topicPartition);
                    hasPartitionErrors = true;
                    continue;
                }
                log.error("{}Could not add partition {} due to unexpected error {}", new Object[]{TransactionManager.this.logPrefix, topicPartition, error});
                hasPartitionErrors = true;
            }
            Set<TopicPartition> partitions = errors.keySet();
            TransactionManager.this.pendingPartitionsInTransaction.removeAll(partitions);
            if (!unauthorizedTopics.isEmpty()) {
                this.abortableError(new TopicAuthorizationException(unauthorizedTopics));
            } else if (hasPartitionErrors) {
                this.abortableError(new KafkaException("Could not add partitions to transaction due to errors: " + errors));
            } else {
                log.debug("{}Successfully added partitions {} to transaction", (Object)TransactionManager.this.logPrefix, partitions);
                TransactionManager.this.partitionsInTransaction.addAll(partitions);
                TransactionManager.this.transactionStarted = true;
                this.result.done();
            }
        }

        @Override
        public long retryBackoffMs() {
            return Math.min(TransactionManager.this.retryBackoffMs, this.retryBackoffMs);
        }

        private void maybeOverrideRetryBackoffMs() {
            if (TransactionManager.this.partitionsInTransaction.isEmpty()) {
                this.retryBackoffMs = 20L;
            }
        }
    }

    private class InitProducerIdHandler
    extends TxnRequestHandler {
        private final InitProducerIdRequest.Builder builder;

        private InitProducerIdHandler(InitProducerIdRequest.Builder builder) {
            this.builder = builder;
        }

        InitProducerIdRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.INIT_PRODUCER_ID;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            InitProducerIdResponse initProducerIdResponse = (InitProducerIdResponse)response;
            Errors error = initProducerIdResponse.error();
            if (error == Errors.NONE) {
                ProducerIdAndEpoch producerIdAndEpoch = new ProducerIdAndEpoch(initProducerIdResponse.producerId(), initProducerIdResponse.epoch());
                TransactionManager.this.setProducerIdAndEpoch(producerIdAndEpoch);
                TransactionManager.this.transitionTo(State.READY);
                TransactionManager.this.lastError = null;
                this.result.done();
            } else if (error == Errors.NOT_COORDINATOR || error == Errors.COORDINATOR_NOT_AVAILABLE) {
                TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                this.reenqueue();
            } else if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.CONCURRENT_TRANSACTIONS) {
                this.reenqueue();
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else {
                this.fatalError(new KafkaException("Unexpected error in InitProducerIdResponse; " + error.message()));
            }
        }
    }

    abstract class TxnRequestHandler
    implements RequestCompletionHandler {
        protected final TransactionalRequestResult result;
        private boolean isRetry = false;

        TxnRequestHandler(TransactionalRequestResult result) {
            this.result = result;
        }

        TxnRequestHandler() {
            this(new TransactionalRequestResult());
        }

        void fatalError(RuntimeException e) {
            this.result.setError(e);
            TransactionManager.this.transitionToFatalError(e);
            this.result.done();
        }

        void abortableError(RuntimeException e) {
            this.result.setError(e);
            TransactionManager.this.transitionToAbortableError(e);
            this.result.done();
        }

        void fail(RuntimeException e) {
            this.result.setError(e);
            this.result.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reenqueue() {
            TransactionManager transactionManager = TransactionManager.this;
            synchronized (transactionManager) {
                this.isRetry = true;
                TransactionManager.this.enqueueRequest(this);
            }
        }

        long retryBackoffMs() {
            return TransactionManager.this.retryBackoffMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(ClientResponse response) {
            if (response.requestHeader().correlationId() != TransactionManager.this.inFlightRequestCorrelationId) {
                this.fatalError(new RuntimeException("Detected more than one in-flight transactional request."));
            } else {
                TransactionManager.this.clearInFlightRequestCorrelationId();
                if (response.wasDisconnected()) {
                    log.debug("{}Disconnected from {}. Will retry.", (Object)TransactionManager.this.logPrefix, (Object)response.destination());
                    if (this.needsCoordinator()) {
                        TransactionManager.this.lookupCoordinator(this.coordinatorType(), this.coordinatorKey());
                    }
                    this.reenqueue();
                } else if (response.versionMismatch() != null) {
                    this.fatalError(response.versionMismatch());
                } else if (response.hasResponse()) {
                    log.trace("{}Received transactional response {} for request {}", new Object[]{TransactionManager.this.logPrefix, response.responseBody(), this.requestBuilder()});
                    TransactionManager transactionManager = TransactionManager.this;
                    synchronized (transactionManager) {
                        this.handleResponse(response.responseBody());
                    }
                } else {
                    this.fatalError(new KafkaException("Could not execute transactional request for unknown reasons"));
                }
            }
        }

        boolean needsCoordinator() {
            return this.coordinatorType() != null;
        }

        FindCoordinatorRequest.CoordinatorType coordinatorType() {
            return FindCoordinatorRequest.CoordinatorType.TRANSACTION;
        }

        String coordinatorKey() {
            return TransactionManager.this.transactionalId;
        }

        void setRetry() {
            this.isRetry = true;
        }

        boolean isRetry() {
            return this.isRetry;
        }

        boolean isEndTxn() {
            return false;
        }

        abstract AbstractRequest.Builder<?> requestBuilder();

        abstract void handleResponse(AbstractResponse var1);

        abstract Priority priority();
    }

    private static enum Priority {
        FIND_COORDINATOR(0),
        INIT_PRODUCER_ID(1),
        ADD_PARTITIONS_OR_OFFSETS(2),
        END_TXN(3);

        final int priority;

        private Priority(int priority) {
            this.priority = priority;
        }
    }

    private static enum State {
        UNINITIALIZED,
        INITIALIZING,
        READY,
        IN_TRANSACTION,
        COMMITTING_TRANSACTION,
        ABORTING_TRANSACTION,
        ABORTABLE_ERROR,
        FATAL_ERROR;


        private boolean isTransitionValid(State source, State target) {
            switch (target) {
                case INITIALIZING: {
                    return source == UNINITIALIZED;
                }
                case READY: {
                    return source == INITIALIZING || source == COMMITTING_TRANSACTION || source == ABORTING_TRANSACTION;
                }
                case IN_TRANSACTION: {
                    return source == READY;
                }
                case COMMITTING_TRANSACTION: {
                    return source == IN_TRANSACTION;
                }
                case ABORTING_TRANSACTION: {
                    return source == IN_TRANSACTION || source == ABORTABLE_ERROR;
                }
                case ABORTABLE_ERROR: {
                    return source == IN_TRANSACTION || source == COMMITTING_TRANSACTION || source == ABORTABLE_ERROR;
                }
            }
            return true;
        }
    }
}

