/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class ReaderInterceptorMBR
implements ReaderInterceptor {
    private MessageBodyReader<?> reader;
    private Message m;

    public ReaderInterceptorMBR(MessageBodyReader<?> reader, Message m) {
        if (null == m) {
            throw new IllegalArgumentException("Message not allowed to be null");
        }
        this.reader = reader;
        this.m = m;
    }

    public MessageBodyReader<?> getMBR() {
        return this.reader;
    }

    public Object aroundReadFrom(ReaderInterceptorContext c) throws IOException, WebApplicationException {
        Class entityCls = c.getType();
        Type entityType = c.getGenericType();
        MediaType entityMt = c.getMediaType();
        Annotation[] entityAnns = c.getAnnotations();
        if ((this.reader == null || this.m.get((Object)"provider.selection.property.changed") == Boolean.TRUE && !this.reader.isReadable(entityCls, entityType, entityAnns, entityMt)) && this.entityStreamAvailable(c.getInputStream())) {
            this.reader = ProviderFactory.getInstance(this.m).createMessageBodyReader(entityCls, entityType, entityAnns, entityMt, this.m);
        }
        if (this.reader == null) {
            String errorMessage = JAXRSUtils.logMessageHandlerProblem("NO_MSG_READER", entityCls, entityMt);
            throw new ProcessingException(errorMessage);
        }
        return this.reader.readFrom(entityCls, entityType, entityAnns, entityMt, new HttpHeadersImpl(this.m).getRequestHeaders(), c.getInputStream());
    }

    private boolean entityStreamAvailable(InputStream entity) {
        return entity != null || this.m.getContent(XMLStreamReader.class) != null || this.m.getContent(Reader.class) != null;
    }
}

