/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FileChunk;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.combine.Combiner;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.FetchedInputAllocatorOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.InMemoryReader;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapOutput;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.RssInMemoryMerger;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezMerger;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssMergeManager
extends MergeManager {
    private static final Logger LOG = LoggerFactory.getLogger(MergeManager.class);
    private Configuration conf;
    private InputContext inputContext;
    private ExceptionReporter exceptionReporter;
    private RssInMemoryMerger inMemoryMerger;
    private Combiner combiner;
    private CompressionCodec codec;
    private boolean ifileReadAhead;
    private int ifileReadAheadLength;
    private int ifileBufferSize;
    private String appAttemptId;
    private final long initialMemoryAvailable;
    private final long memoryLimit;
    private final long maxSingleShuffleLimit;
    private long mergeThreshold;
    private long commitMemory;
    private long usedMemory;
    private String spillBasePath;
    private FileSystem remoteFS;
    private long lastInMemSegmentLogTime = -1L;
    private final SegmentStatsTracker statsInMemTotal = new SegmentStatsTracker();
    private final SegmentStatsTracker statsInMemLastLog = new SegmentStatsTracker();
    private final TezCounter spilledRecordsCounter;
    private final TezCounter mergedMapOutputsCounter;
    private final TezCounter additionalBytesRead;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final boolean cleanup;
    private final Progressable progressable = new Progressable(){

        public void progress() {
            RssMergeManager.this.inputContext.notifyProgress();
        }
    };
    private final MapOutput stallShuffle = MapOutput.createWaitMapOutput(null);
    private long lastOnDiskSegmentLogTime = -1L;

    public RssMergeManager(Configuration conf, FileSystem localFS, InputContext inputContext, Combiner combiner, TezCounter spilledRecordsCounter, TezCounter reduceCombineInputCounter, TezCounter mergedMapOutputsCounter, ExceptionReporter exceptionReporter, long initialMemoryAvailable, CompressionCodec codec, boolean ifileReadAheadEnabled, int ifileReadAheadLength, Configuration remoteConf, int replication, int retries, String appAttemptId) {
        super(conf, localFS, null, inputContext, combiner, spilledRecordsCounter, reduceCombineInputCounter, mergedMapOutputsCounter, exceptionReporter, initialMemoryAvailable, codec, ifileReadAheadEnabled, ifileReadAheadLength);
        this.conf = conf;
        this.inputContext = inputContext;
        this.exceptionReporter = exceptionReporter;
        this.codec = codec;
        this.combiner = combiner;
        this.initialMemoryAvailable = initialMemoryAvailable;
        this.ifileReadAhead = ifileReadAheadEnabled;
        this.ifileReadAheadLength = this.ifileReadAhead ? ifileReadAheadLength : 0;
        this.ifileBufferSize = conf.getInt("io.file.buffer.size", -1);
        this.appAttemptId = appAttemptId;
        this.cleanup = conf.getBoolean("tez.runtime.cleanup.files.on.interrupt", false);
        float maxInMemCopyUse = conf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.9f);
        long memLimit = conf.getLong("tez.runtime.task.memory", (long)((float)inputContext.getTotalMemoryAvailableToTask() * maxInMemCopyUse));
        this.memoryLimit = this.initialMemoryAvailable < memLimit ? this.initialMemoryAvailable : memLimit;
        this.mergeThreshold = (long)((float)this.memoryLimit * conf.getFloat("tez.runtime.shuffle.merge.percent", 0.9f));
        float singleShuffleMemoryLimitPercent = conf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.25f);
        this.maxSingleShuffleLimit = (long)Math.min((float)this.memoryLimit * singleShuffleMemoryLimitPercent, 2.1474836E9f);
        this.spilledRecordsCounter = spilledRecordsCounter;
        this.mergedMapOutputsCounter = mergedMapOutputsCounter;
        this.additionalBytesRead = inputContext.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_READ);
        Configuration remoteConfCopied = new Configuration(remoteConf);
        this.spillBasePath = conf.get("tez.rss.remote.spill.storage.path");
        try {
            remoteConfCopied.setInt("dfs.replication", replication);
            remoteConfCopied.setInt("dfs.client.block.write.retries", retries);
            this.remoteFS = HadoopFilesystemProvider.getFilesystem(new Path(this.spillBasePath), remoteConfCopied);
        }
        catch (Exception e) {
            throw new RssException("Cannot init remoteFS on path:" + this.spillBasePath);
        }
        if (StringUtils.isBlank((CharSequence)this.spillBasePath)) {
            throw new RssException("You must set remote spill path!");
        }
        this.inMemoryMerger = this.createRssInMemoryMerger();
    }

    private RssInMemoryMerger createRssInMemoryMerger() {
        return new RssInMemoryMerger(this, this.conf, this.inputContext, this.combiner, this.exceptionReporter, this.codec, this.remoteFS, this.spillBasePath, this.appAttemptId);
    }

    void configureAndStart() {
        this.inMemoryMerger.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInMemoryMerge() throws InterruptedException {
        this.inMemoryMerger.waitForMerge();
        boolean triggerAdditionalMerge = false;
        RssMergeManager rssMergeManager = this;
        synchronized (rssMergeManager) {
            if (this.commitMemory >= this.mergeThreshold) {
                this.startMemToRemoteMerge();
                triggerAdditionalMerge = true;
            }
        }
        if (triggerAdditionalMerge) {
            this.inMemoryMerger.waitForMerge();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Additional in-memory merge triggered");
            }
        }
    }

    private boolean canShuffleToMemory(long requestedSize) {
        return true;
    }

    public synchronized void waitForShuffleToMergeMemory() throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (this.usedMemory > this.memoryLimit) {
            ((Object)((Object)this)).wait();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Waited for " + (System.currentTimeMillis() - startTime) + " for memory to become available");
        }
    }

    public synchronized MapOutput reserve(InputAttemptIdentifier srcAttemptIdentifier, long requestedSize, long compressedLength, int fetcher) throws IOException {
        if (!this.canShuffleToMemory(requestedSize)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(srcAttemptIdentifier + ": Shuffling to remote fs since " + requestedSize + " is greater than maxSingleShuffleLimit (" + this.maxSingleShuffleLimit + ")");
            }
            throw new RssException("Shuffle large date is not implemented!");
        }
        if (this.usedMemory > this.memoryLimit) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(srcAttemptIdentifier + ": Stalling shuffle since usedMemory (" + this.usedMemory + ") is greater than memoryLimit (" + this.memoryLimit + "). CommitMemory is (" + this.commitMemory + ")");
            }
            return this.stallShuffle;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(srcAttemptIdentifier + ": Proceeding with shuffle since usedMemory (" + this.usedMemory + ") is lesser than memoryLimit (" + this.memoryLimit + ").CommitMemory is (" + this.commitMemory + ")");
        }
        return this.unconditionalReserve(srcAttemptIdentifier, requestedSize, true);
    }

    private synchronized MapOutput unconditionalReserve(InputAttemptIdentifier srcAttemptIdentifier, long requestedSize, boolean primaryMapOutput) throws IOException {
        this.usedMemory += requestedSize;
        return MapOutput.createMemoryMapOutput((InputAttemptIdentifier)srcAttemptIdentifier, (FetchedInputAllocatorOrderedGrouped)this, (int)((int)requestedSize), (boolean)primaryMapOutput);
    }

    public synchronized void unreserve(long size) {
        this.usedMemory -= size;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Notifying unreserve : size=" + size + ", commitMemory=" + this.commitMemory + ", usedMemory=" + this.usedMemory + ", mergeThreshold=" + this.mergeThreshold);
        }
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized void releaseCommittedMemory(long size) {
        this.commitMemory -= size;
        this.unreserve(size);
    }

    public synchronized void closeInMemoryFile(MapOutput mapOutput) {
        this.inMemoryMapOutputs.add(mapOutput);
        this.trackAndLogCloseInMemoryFile(mapOutput);
        this.commitMemory += mapOutput.getSize();
        if (this.commitMemory >= this.mergeThreshold) {
            this.startMemToRemoteMerge();
        }
    }

    private void trackAndLogCloseInMemoryFile(MapOutput mapOutput) {
        this.statsInMemTotal.updateStats(mapOutput.getSize());
        if (LOG.isDebugEnabled()) {
            LOG.debug("closeInMemoryFile -> map-output of size: " + mapOutput.getSize() + ", inMemoryMapOutputs.size() -> " + this.inMemoryMapOutputs.size() + ", commitMemory -> " + this.commitMemory + ", usedMemory ->" + this.usedMemory + ", mapOutput=" + mapOutput);
        } else {
            this.statsInMemLastLog.updateStats(mapOutput.getSize());
            long now = Time.monotonicNow();
            if (now > this.lastInMemSegmentLogTime + 30000L) {
                LOG.info("CloseInMemoryFile. Current state: inMemoryMapOutputs.size={}, commitMemory={}, usedMemory={}. Since last log: count={}, min={}, max={}, total={}, avg={}", new Object[]{this.inMemoryMapOutputs.size(), this.commitMemory, this.usedMemory, this.statsInMemLastLog.count, this.statsInMemLastLog.minSize, this.statsInMemLastLog.maxSize, this.statsInMemLastLog.size, this.statsInMemLastLog.count == 0 ? "nan" : Double.valueOf((double)this.statsInMemLastLog.size / (double)this.statsInMemLastLog.count)});
                this.statsInMemLastLog.reset();
                this.lastInMemSegmentLogTime = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMemToRemoteMerge() {
        RssInMemoryMerger rssInMemoryMerger = this.inMemoryMerger;
        synchronized (rssInMemoryMerger) {
            if (!this.inMemoryMerger.isInProgress()) {
                LOG.info(this.inputContext.getSourceVertexName() + ": Starting inMemoryMerger's merge since commitMemory=" + this.commitMemory + " > mergeThreshold=" + this.mergeThreshold + ". Current usedMemory=" + this.usedMemory);
                this.inMemoryMerger.startMerge(this.inMemoryMapOutputs);
            }
        }
    }

    public synchronized void closeOnDiskFile(FileChunk file) {
        this.onDiskMapOutputs.add(file);
        this.logCloseOnDiskFile(file);
    }

    public TezRawKeyValueIterator close(boolean tryFinalMerge) throws Throwable {
        if (!this.isShutdown.getAndSet(true)) {
            this.inMemoryMerger.startMerge(this.inMemoryMapOutputs);
            this.inMemoryMerger.close();
            if (!this.inMemoryMapOutputs.isEmpty()) {
                throw new RssException("InMemoryMapOutputs should be empty");
            }
            if (this.statsInMemTotal.count > 0) {
                LOG.info("TotalInMemFetchStats: count={}, totalSize={}, min={}, max={}, avg={}", new Object[]{this.statsInMemTotal.count, this.statsInMemTotal.size, this.statsInMemTotal.minSize, this.statsInMemTotal.maxSize, Float.valueOf((float)this.statsInMemTotal.size / (float)this.statsInMemTotal.size)});
            }
            if (tryFinalMerge) {
                try {
                    TezRawKeyValueIterator kvIter = this.finalMerge();
                    return kvIter;
                }
                catch (InterruptedException e) {
                    if (this.cleanup) {
                        RssMergeManager.cleanup((FileSystem)this.remoteFS, (Collection)this.onDiskMapOutputs);
                    }
                    Thread.currentThread().interrupt();
                    throw e;
                }
            }
        }
        return null;
    }

    long createInMemorySegments(List<MapOutput> inMemoryMapOutputs, List<TezMerger.Segment> inMemorySegments, long leaveBytes) throws IOException {
        long totalSize = 0L;
        long fullSize = 0L;
        for (MapOutput mo : inMemoryMapOutputs) {
            fullSize += mo.getSize();
        }
        int inMemoryMapOutputsOffset = 0;
        while (fullSize > leaveBytes && !Thread.currentThread().isInterrupted()) {
            MapOutput mo;
            mo = inMemoryMapOutputs.get(inMemoryMapOutputsOffset++);
            byte[] data = mo.getMemory();
            long size = data.length;
            totalSize += size;
            fullSize -= size;
            InMemoryReader reader = new InMemoryReader((MergeManager)this, mo.getAttemptIdentifier(), data, 0, (int)size);
            inMemorySegments.add(new TezMerger.Segment((IFile.Reader)reader, mo.isPrimaryMapOutput() ? this.mergedMapOutputsCounter : null));
        }
        inMemoryMapOutputs.subList(0, inMemoryMapOutputsOffset).clear();
        return totalSize;
    }

    private void logCloseOnDiskFile(FileChunk file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close onDiskFile=" + file.getPath() + ", len=" + file.getLength() + ", onDisMapOutputs=" + this.onDiskMapOutputs.size());
        } else {
            long now = Time.monotonicNow();
            if (now > this.lastOnDiskSegmentLogTime + 30000L) {
                LOG.info("close onDiskFile. State: NumOnDiskFiles={}. Current: path={}, len={}", new Object[]{this.onDiskMapOutputs.size(), file.getPath(), file.getLength()});
                this.lastOnDiskSegmentLogTime = now;
            }
        }
    }

    private TezRawKeyValueIterator finalMerge() throws IOException, InterruptedException {
        Class keyClass = ConfigUtils.getIntermediateInputKeyClass((Configuration)this.conf);
        Class valueClass = ConfigUtils.getIntermediateInputValueClass((Configuration)this.conf);
        Path[] remotePaths = (Path[])this.onDiskMapOutputs.stream().map(output -> output.getPath()).toArray(num -> new Path[this.onDiskMapOutputs.size()]);
        RawComparator comparator = ConfigUtils.getIntermediateInputKeyComparator((Configuration)this.conf);
        return TezMerger.merge((Configuration)this.conf, (FileSystem)this.remoteFS, (Class)keyClass, (Class)valueClass, (CompressionCodec)this.codec, (boolean)this.ifileReadAhead, (int)this.ifileReadAheadLength, (int)this.ifileBufferSize, (Path[])remotePaths, (boolean)true, (int)Integer.MAX_VALUE, null, (RawComparator)comparator, (Progressable)this.progressable, (TezCounter)this.spilledRecordsCounter, null, (TezCounter)this.additionalBytesRead, null);
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public Progressable getProgressable() {
        return this.progressable;
    }

    @VisibleForTesting
    public RssInMemoryMerger getInMemoryMerger() {
        return this.inMemoryMerger;
    }

    private static class SegmentStatsTracker {
        private long size;
        private int count;
        private long minSize;
        private long maxSize;

        SegmentStatsTracker() {
            this.reset();
        }

        void updateStats(long segSize) {
            this.size += segSize;
            ++this.count;
            this.minSize = segSize < this.minSize ? segSize : this.minSize;
            this.maxSize = segSize > this.maxSize ? segSize : this.maxSize;
        }

        void reset() {
            this.size = 0L;
            this.count = 0;
            this.minSize = Long.MAX_VALUE;
            this.maxSize = Long.MIN_VALUE;
        }
    }
}

