/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.slf4j.Logger;

public class MetadataQueryProtocolRequestURLBuilder
implements Function<CriteriaSet, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MetadataQueryProtocolRequestURLBuilder.class);
    @Nonnull
    @NotEmpty
    private String base;
    @Nullable
    private Function<String, String> transformer;
    @Nonnull
    private final Escaper pathEscaper = UrlEscapers.urlPathSegmentEscaper();
    @Nullable
    private List<MetadataQueryProtocolURLBuilder> urlBuilders;

    public MetadataQueryProtocolRequestURLBuilder(@ParameterName(name="baseURL") @Nonnull @NotEmpty String baseURL) {
        this(baseURL, null, null);
    }

    public MetadataQueryProtocolRequestURLBuilder(@ParameterName(name="baseURL") @Nonnull @NotEmpty String baseURL, @ParameterName(name="transform") @Nullable Function<String, String> transform) {
        this(baseURL, transform, null);
    }

    public MetadataQueryProtocolRequestURLBuilder(@ParameterName(name="baseURL") @Nonnull @NotEmpty String baseURL, @ParameterName(name="secondaryURLBuilders") @Nullable List<MetadataQueryProtocolURLBuilder> secondaryURLBuilders) {
        this(baseURL, null, secondaryURLBuilders);
    }

    public MetadataQueryProtocolRequestURLBuilder(@ParameterName(name="baseURL") @Nonnull @NotEmpty String baseURL, @ParameterName(name="transform") @Nullable Function<String, String> transform, @ParameterName(name="secondaryURLBuilders") @Nullable List<MetadataQueryProtocolURLBuilder> secondaryURLBuilders) {
        this.base = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)baseURL), (String)"Base URL was null or empty");
        if (!this.base.endsWith("/")) {
            this.log.debug("Base URL did not end in a trailing '/', one will be added");
            this.base = this.base + "/";
        }
        this.log.debug("Effective base URL value was: {}", (Object)this.base);
        this.transformer = transform;
        if (secondaryURLBuilders != null) {
            this.urlBuilders = CollectionSupport.copyToList(secondaryURLBuilders);
        }
    }

    @Nonnull
    @NotEmpty
    public String getBaseURL() {
        return this.base;
    }

    @Override
    @Nullable
    public String apply(@Nullable CriteriaSet criteria) {
        EntityIdCriterion criterion;
        EntityIdCriterion entityIdCriterion = criterion = criteria != null ? (EntityIdCriterion)criteria.get(EntityIdCriterion.class) : null;
        if (criterion != null) {
            this.log.debug("Criteria contained entity ID, building on that basis");
            return this.buildFromEntityID(criterion.getEntityId());
        }
        if (this.urlBuilders != null) {
            this.log.debug("Criteria did not contain entity ID, attempting to build using secondary URL builders");
            return this.buildFromSecondaryLookups(criteria);
        }
        this.log.debug("Criteria did not contain entity ID and no secondary URL builders were configured");
        return null;
    }

    @Nullable
    private String buildFromEntityID(@Nonnull String inputEntityID) {
        String entityID = inputEntityID;
        if (this.transformer != null) {
            entityID = this.transformer.apply(inputEntityID);
            this.log.debug("Transformed entityID is '{}'", (Object)entityID);
            if (entityID == null) {
                this.log.debug("Transformed entityID was null");
                return null;
            }
        }
        String result = this.base + "entities/" + this.pathEscaper.escape(entityID);
        this.log.debug("From entityID '{}' and base URL '{}', built request URL: {}", new Object[]{entityID, this.base, result});
        return result;
    }

    @Nullable
    private String buildFromSecondaryLookups(@Nullable CriteriaSet criteria) {
        if (this.urlBuilders != null) {
            for (MetadataQueryProtocolURLBuilder builder : this.urlBuilders) {
                String url = builder.buildURL(this.base, criteria);
                this.log.debug("Secondary URL builder '{}' produced URL: {}", (Object)builder.getClass().getName(), (Object)url);
                if (url == null) continue;
                return url;
            }
        }
        this.log.debug("No configured secondary URL builders produced a non-null request URL");
        return null;
    }

    public static interface MetadataQueryProtocolURLBuilder {
        @Nullable
        public String buildURL(@Nonnull String var1, @Nullable CriteriaSet var2);
    }
}

