/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwt.consumer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.JwtContext;

public class IssValidator
implements ErrorCodeValidator {
    private Set<String> expectedIssuers;
    private boolean requireIssuer;

    public IssValidator(String expectedIssuer, boolean requireIssuer) {
        if (expectedIssuer != null) {
            this.expectedIssuers = Collections.singleton(expectedIssuer);
        }
        this.requireIssuer = requireIssuer;
    }

    public IssValidator(boolean requireIssuer, String ... expectedIssuers) {
        this.requireIssuer = requireIssuer;
        if (expectedIssuers != null && expectedIssuers.length > 0) {
            this.expectedIssuers = new HashSet<String>();
            Collections.addAll(this.expectedIssuers, expectedIssuers);
        }
    }

    @Override
    public ErrorCodeValidator.Error validate(JwtContext jwtContext) throws MalformedClaimException {
        String issuer = jwtContext.getJwtClaims().getIssuer();
        if (issuer == null) {
            return this.requireIssuer ? new ErrorCodeValidator.Error(11, "No Issuer (iss) claim present.") : null;
        }
        if (this.expectedIssuers != null && !this.expectedIssuers.contains(issuer)) {
            return new ErrorCodeValidator.Error(12, "Issuer (iss) claim value (" + issuer + ") doesn't match expected value of " + this.expectedValue());
        }
        return null;
    }

    private String expectedValue() {
        return this.expectedIssuers.size() == 1 ? this.expectedIssuers.iterator().next() : "one of " + this.expectedIssuers;
    }
}

