/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee.jpa.unit;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.UnmarshallerHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.openejb.jee.JAXBContextFactory;
import org.apache.openejb.jee.JaxbJavaee;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JaxbPersistenceFactory {
    public static final String PERSISTENCE_SCHEMA = "http://java.sun.com/xml/ns/persistence";

    public static <T> T getPersistence(Class<T> clazz, InputStream persistenceDescriptor) throws Exception {
        JAXBContext jc = clazz.getClassLoader() == JaxbPersistenceFactory.class.getClassLoader() ? JaxbJavaee.getContext(clazz) : JAXBContextFactory.newInstance(clazz);
        Unmarshaller u = jc.createUnmarshaller();
        UnmarshallerHandler uh = u.getUnmarshallerHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        SAXParser parser = factory.newSAXParser();
        XMLReader xmlReader = parser.getXMLReader();
        PersistenceFilter xmlFilter = new PersistenceFilter(xmlReader);
        xmlFilter.setContentHandler((ContentHandler)uh);
        SAXSource source = new SAXSource(xmlFilter, new InputSource(persistenceDescriptor));
        return (T)u.unmarshal((Source)source);
    }

    public static <T> T getPersistence(Class<T> clazz, URL url) throws Exception {
        try (InputStream persistenceDescriptor = url.openStream();){
            T t = JaxbPersistenceFactory.getPersistence(clazz, persistenceDescriptor);
            return t;
        }
    }

    public static class PersistenceFilter
    extends JaxbJavaee.NoSourceFilter {
        public PersistenceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        protected String eeUri(String uri) {
            return uri != null && uri.contains("/persistence") ? JaxbPersistenceFactory.PERSISTENCE_SCHEMA : uri;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return EMPTY_INPUT_SOURCE;
        }
    }
}

