/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CommonAbstractCriteria;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.metamodel.EntityType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.openjpa.kernel.exps.Context;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.kernel.jpql.JPQLExpressionBuilder;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.CriteriaExpressionBuilder;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.FromImpl;
import org.apache.openjpa.persistence.criteria.Joins;
import org.apache.openjpa.persistence.criteria.PathImpl;
import org.apache.openjpa.persistence.criteria.RootImpl;
import org.apache.openjpa.persistence.meta.AbstractManagedType;
import org.apache.openjpa.persistence.meta.MetamodelImpl;
import org.apache.openjpa.persistence.meta.Types;

class SubqueryImpl<T>
extends ExpressionImpl<T>
implements jakarta.persistence.criteria.Subquery<T> {
    private final AbstractQuery<?> _parent;
    private final CriteriaQueryImpl<T> _delegate;
    private final MetamodelImpl _model;
    private Subquery _subq;
    private List<Join<?, ?>> _corrJoins = null;

    SubqueryImpl(Class<T> cls, AbstractQuery<?> parent) {
        super(cls);
        OrderedMap<Object, Class<?>> params;
        this._parent = parent;
        if (parent instanceof CriteriaQueryImpl) {
            this._model = ((CriteriaQueryImpl)parent).getMetamodel();
            params = ((CriteriaQueryImpl)parent).getParameterTypes();
        } else if (parent instanceof SubqueryImpl) {
            this._model = ((SubqueryImpl)parent).getMetamodel();
            params = ((SubqueryImpl)parent).getInnermostParent().getParameterTypes();
        } else {
            this._model = null;
            params = null;
        }
        this._delegate = new CriteriaQueryImpl(this._model, this, params);
    }

    public AbstractQuery<?> getParent() {
        return this._parent;
    }

    public CommonAbstractCriteria getContainingQuery() {
        return this.getParent();
    }

    CriteriaQueryImpl<T> getDelegate() {
        return this._delegate;
    }

    public MetamodelImpl getMetamodel() {
        return this._model;
    }

    Stack<Context> getContexts() {
        return this.getInnermostParent().getContexts();
    }

    public CriteriaQueryImpl<?> getInnermostParent() {
        return (CriteriaQueryImpl)(this._parent instanceof CriteriaQueryImpl ? this._parent : ((SubqueryImpl)this._parent).getInnermostParent());
    }

    public jakarta.persistence.criteria.Subquery<T> select(Expression<T> expression) {
        this._delegate.select((Selection<T>)expression);
        return this;
    }

    public Expression<T> getSelection() {
        return (Expression)this._delegate.getSelection();
    }

    public <X> Root<X> from(EntityType<X> entity) {
        return this._delegate.from(entity);
    }

    public <X> Root<X> from(Class<X> entityClass) {
        return this._delegate.from(entityClass);
    }

    public Set<Root<?>> getRoots() {
        return this._delegate.getRoots();
    }

    public Root<?> getRoot() {
        return this._delegate.getRoot(false);
    }

    public jakarta.persistence.criteria.Subquery<T> where(Expression<Boolean> restriction) {
        this._delegate.where(restriction);
        return this;
    }

    public jakarta.persistence.criteria.Subquery<T> where(Predicate ... restrictions) {
        this._delegate.where(restrictions);
        return this;
    }

    public jakarta.persistence.criteria.Subquery<T> groupBy(Expression<?> ... grouping) {
        this._delegate.groupBy(grouping);
        return this;
    }

    public jakarta.persistence.criteria.Subquery<T> groupBy(List<Expression<?>> grouping) {
        this._delegate.groupBy(grouping);
        return this;
    }

    public jakarta.persistence.criteria.Subquery<T> having(Expression<Boolean> restriction) {
        this._delegate.having(restriction);
        return this;
    }

    public jakarta.persistence.criteria.Subquery<T> having(Predicate ... restrictions) {
        this._delegate.having(restrictions);
        return this;
    }

    public jakarta.persistence.criteria.Subquery<T> distinct(boolean distinct) {
        this._delegate.distinct(distinct);
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return this._delegate.getGroupList();
    }

    public Predicate getRestriction() {
        return this._delegate.getRestriction();
    }

    public Predicate getGroupRestriction() {
        return this._delegate.getGroupRestriction();
    }

    public boolean isDistinct() {
        return this._delegate.isDistinct();
    }

    public <U> jakarta.persistence.criteria.Subquery<U> subquery(Class<U> type) {
        return new SubqueryImpl<U>(type, (AbstractQuery<?>)this);
    }

    public <Y> Root<Y> correlate(Root<Y> root) {
        Types.Entity entity = (Types.Entity)root.getModel();
        RootImpl corrRoot = new RootImpl(entity);
        corrRoot.setCorrelatedPath((RootImpl)root);
        this._delegate.addRoot(corrRoot);
        return corrRoot;
    }

    public Set<Join<?, ?>> getCorrelatedJoins() {
        return this._corrJoins == null ? Collections.emptySet() : new CopyOnWriteArraySet(this._corrJoins);
    }

    public <X, Y> Join<X, Y> correlate(Join<X, Y> parentJoin) {
        Join corrJoin = Joins.clone(parentJoin);
        ((PathImpl)corrJoin).setCorrelatedPath((PathImpl)parentJoin);
        if (this._corrJoins == null) {
            this._corrJoins = new ArrayList();
        }
        this._corrJoins.add(corrJoin);
        return corrJoin;
    }

    public boolean isCorrelated() {
        return this._corrJoins != null;
    }

    public <X, Y> CollectionJoin<X, Y> correlate(CollectionJoin<X, Y> parentJoin) {
        Join corrJoin = Joins.clone((Join)((Joins.Collection)parentJoin));
        ((PathImpl)corrJoin).setCorrelatedPath((PathImpl)parentJoin);
        if (this._corrJoins == null) {
            this._corrJoins = new ArrayList();
        }
        this._corrJoins.add(corrJoin);
        return (CollectionJoin)corrJoin;
    }

    public <X, Y> SetJoin<X, Y> correlate(SetJoin<X, Y> parentJoin) {
        Join corrJoin = Joins.clone((Join)((Joins.Set)parentJoin));
        ((PathImpl)corrJoin).setCorrelatedPath((PathImpl)parentJoin);
        if (this._corrJoins == null) {
            this._corrJoins = new ArrayList();
        }
        this._corrJoins.add(corrJoin);
        return (SetJoin)corrJoin;
    }

    public <X, Y> ListJoin<X, Y> correlate(ListJoin<X, Y> parentJoin) {
        Join corrJoin = Joins.clone((Join)((Joins.List)parentJoin));
        ((PathImpl)corrJoin).setCorrelatedPath((PathImpl)parentJoin);
        if (this._corrJoins == null) {
            this._corrJoins = new ArrayList();
        }
        this._corrJoins.add(corrJoin);
        return (ListJoin)corrJoin;
    }

    public <X, K, V> MapJoin<X, K, V> correlate(MapJoin<X, K, V> parentJoin) {
        Join corrJoin = Joins.clone((Join)((Joins.Map)parentJoin));
        ((PathImpl)corrJoin).setCorrelatedPath((PathImpl)parentJoin);
        if (this._corrJoins == null) {
            this._corrJoins = new ArrayList();
        }
        this._corrJoins.add(corrJoin);
        return (MapJoin)corrJoin;
    }

    Subquery getSubQ() {
        return this._subq;
    }

    @Override
    public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        boolean subclasses = true;
        CriteriaExpressionBuilder exprBuilder = new CriteriaExpressionBuilder();
        String alias = q.getAlias(this);
        ClassMetaData candidate = this.getCandidate();
        this._subq = factory.newSubquery(candidate, true, alias);
        this._subq.setMetaData(candidate);
        Stack<Context> contexts = this.getContexts();
        Context context = new Context(null, this._subq, contexts.peek());
        contexts.push(context);
        this._delegate.setContexts(contexts);
        QueryExpressions subexp = exprBuilder.getQueryExpressions(factory, this._delegate);
        this._subq.setQueryExpressions(subexp);
        if (subexp.projections.length > 0) {
            JPQLExpressionBuilder.checkEmbeddable(subexp.projections[0], null);
        }
        contexts.pop();
        return this._subq;
    }

    private ClassMetaData getCandidate() {
        FromImpl corrJoin;
        if (this.getRoots().isEmpty() && this._corrJoins != null && (corrJoin = (FromImpl)this._corrJoins.get(0)).getJoins() != null) {
            FromImpl join = (FromImpl)corrJoin.getJoins().iterator().next();
            return this.getInnermostCandidate(join);
        }
        RootImpl root = (RootImpl)this.getRoot();
        if (root != null && root.getCorrelatedPath() != null && !root.getJoins().isEmpty()) {
            FromImpl join = (FromImpl)root.getJoins().iterator().next();
            return this.getInnermostCandidate(join);
        }
        return ((AbstractManagedType)root.getModel()).meta;
    }

    private ClassMetaData getInnermostCandidate(FromImpl<?, ?> from) {
        if (!from.getJoins().isEmpty()) {
            from = (FromImpl)from.getJoins().iterator().next();
            return this.getInnermostCandidate(from);
        }
        return this.getCandidate(from);
    }

    private ClassMetaData getCandidate(FromImpl<?, ?> from) {
        return SubqueryImpl.getFieldType(from._member.fmd);
    }

    private static ClassMetaData getFieldType(FieldMetaData fmd) {
        if (fmd == null) {
            return null;
        }
        ClassMetaData cmd = null;
        ValueMetaData vmd = fmd.getElement();
        if (vmd != null) {
            cmd = vmd.getDeclaredTypeMetaData();
        } else {
            vmd = fmd.getKey();
            if (vmd != null) {
                cmd = vmd.getDeclaredTypeMetaData();
            } else {
                vmd = fmd.getValue();
                if (vmd != null) {
                    cmd = vmd.getDeclaredTypeMetaData();
                }
            }
        }
        if (cmd == null || cmd.getDescribedType() == Object.class) {
            cmd = fmd.getDeclaredTypeMetaData();
        }
        if (cmd == null && fmd.isElementCollection()) {
            cmd = fmd.getDefiningMetaData();
        }
        return cmd;
    }

    public Class<T> getResultType() {
        return this.getJavaType();
    }

    @Override
    public StringBuilder asValue(AliasContext q) {
        StringBuilder buffer = new StringBuilder();
        this._delegate.render(buffer, this._delegate.getRoots(), this._corrJoins);
        return buffer;
    }

    @Override
    public StringBuilder asVariable(AliasContext q) {
        return this.asValue(q);
    }
}

