/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JRPrintImageArea
implements Serializable {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_CIRCLE_COORDINATES_ERROR = "engine.print.image.area.circle.coordinates.error";
    public static final String EXCEPTION_MESSAGE_KEY_POLYGON_COORDINATES_ERROR = "engine.print.image.area.polygon.coordinates.error";
    public static final String EXCEPTION_MESSAGE_KEY_RECTANGLE_COORDINATES_ERROR = "engine.print.image.area.rectangle.coordinates.error";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_HTML_SHAPE = "engine.print.image.area.unknown.html.shape";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_SHAPE = "engine.print.image.area.unknown.shape";
    public static final byte SHAPE_DEFAULT = 0;
    public static final byte SHAPE_RECTANGLE = 1;
    public static final byte SHAPE_CIRCLE = 2;
    public static final byte SHAPE_POLYGON = 3;
    public static final String SHAPE_HTML_DEFAULT = "default";
    public static final String SHAPE_HTML_RECTANGLE = "rect";
    public static final String SHAPE_HTML_CIRCLE = "circle";
    public static final String SHAPE_HTML_POLYGON = "poly";
    private static final Map<String, Byte> htmlShapes = new HashMap<String, Byte>();
    private byte shape = 0;
    private int[] coordinates;
    private transient Shape cachedAWTShape;

    public static byte getShape(String htmlShape) {
        Byte shape = htmlShapes.get(htmlShape.toLowerCase());
        if (shape == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_HTML_SHAPE, htmlShape);
        }
        return shape;
    }

    public static String getHtmlShape(byte shape) {
        String htmlShape;
        switch (shape) {
            case 0: {
                htmlShape = SHAPE_HTML_DEFAULT;
                break;
            }
            case 1: {
                htmlShape = SHAPE_HTML_RECTANGLE;
                break;
            }
            case 2: {
                htmlShape = SHAPE_HTML_CIRCLE;
                break;
            }
            case 3: {
                htmlShape = SHAPE_HTML_POLYGON;
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_SHAPE, shape);
            }
        }
        return htmlShape;
    }

    public byte getShape() {
        return this.shape;
    }

    public void setShape(byte shape) {
        this.shape = shape;
    }

    public int[] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(int[] coordinates) {
        this.coordinates = coordinates;
    }

    public boolean containsPoint(int x, int y) {
        boolean contains;
        if (this.hasAWTShape()) {
            this.ensureAWTShape();
            contains = this.cachedAWTShape.contains(x, y);
        } else {
            contains = true;
        }
        return contains;
    }

    protected void ensureAWTShape() {
        if (this.cachedAWTShape == null) {
            this.cachedAWTShape = this.createAWTShape();
        }
    }

    protected boolean hasAWTShape() {
        return this.shape != 0;
    }

    protected Shape createAWTShape() {
        Shape awtShape;
        switch (this.shape) {
            case 1: {
                awtShape = this.createAWTRectangle();
                break;
            }
            case 2: {
                awtShape = this.createAWTCircle();
                break;
            }
            case 3: {
                awtShape = this.createAWTPolygon();
                break;
            }
            default: {
                awtShape = null;
            }
        }
        return awtShape;
    }

    protected Shape createAWTRectangle() {
        if (this.coordinates == null || this.coordinates.length != 4) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_RECTANGLE_COORDINATES_ERROR, (Object[])null);
        }
        return new Rectangle(this.coordinates[0], this.coordinates[1], this.coordinates[2] - this.coordinates[0], this.coordinates[3] - this.coordinates[1]);
    }

    private Shape createAWTCircle() {
        if (this.coordinates == null || this.coordinates.length != 3) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CIRCLE_COORDINATES_ERROR, (Object[])null);
        }
        return new Ellipse2D.Float(this.coordinates[0], this.coordinates[1], this.coordinates[2], this.coordinates[2]);
    }

    private Shape createAWTPolygon() {
        int i;
        if (this.coordinates == null || this.coordinates.length == 0 || this.coordinates.length % 2 != 0) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_POLYGON_COORDINATES_ERROR, (Object[])null);
        }
        Polygon polygon = new Polygon();
        for (i = 0; i < this.coordinates.length - 2; i += 2) {
            polygon.addPoint(this.coordinates[i], this.coordinates[i + 1]);
        }
        if (this.coordinates[i] != this.coordinates[0] || this.coordinates[i + 1] != this.coordinates[1]) {
            polygon.addPoint(this.coordinates[i], this.coordinates[i + 1]);
        }
        return polygon;
    }

    static {
        htmlShapes.put(SHAPE_HTML_DEFAULT, (byte)0);
        htmlShapes.put(SHAPE_HTML_RECTANGLE, (byte)1);
        htmlShapes.put(SHAPE_HTML_CIRCLE, (byte)2);
        htmlShapes.put(SHAPE_HTML_POLYGON, (byte)3);
    }
}

