/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;

public class JavaSVDExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("SVD Example");
        SparkContext sc = new SparkContext(conf);
        JavaSparkContext jsc = JavaSparkContext.fromSparkContext((SparkContext)sc);
        List<Vector> data = Arrays.asList(Vectors.sparse((int)5, (int[])new int[]{1, 3}, (double[])new double[]{1.0, 7.0}), Vectors.dense((double)2.0, (double[])new double[]{0.0, 3.0, 4.0, 5.0}), Vectors.dense((double)4.0, (double[])new double[]{0.0, 0.0, 6.0, 7.0}));
        JavaRDD rows = jsc.parallelize(data);
        RowMatrix mat = new RowMatrix(rows.rdd());
        SingularValueDecomposition svd = mat.computeSVD(5, true, 1.0E-9);
        RowMatrix U = (RowMatrix)svd.U();
        Vector s = svd.s();
        Matrix V = (Matrix)svd.V();
        Vector[] collectPartitions = (Vector[])U.rows().collect();
        System.out.println("U factor is:");
        for (Vector vector : collectPartitions) {
            System.out.println("\t" + String.valueOf(vector));
        }
        System.out.println("Singular values are: " + String.valueOf(s));
        System.out.println("V factor is:\n" + String.valueOf(V));
        jsc.stop();
    }
}

