/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FrameLessOffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.Lead$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression$;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset[, default]]) - Returns the value of `input` at the `offset`th row\n      after the current row in the window. The default value of `offset` is 1 and the default\n      value of `default` is null. If the value of `input` at the `offset`th row is null,\n      null is returned. If there is no such an offset row (e.g., when the offset is 1, the last\n      row of the window does not have any subsequent row), `default` is returned.\n  ", arguments="\n    Arguments:\n      * input - a string expression to evaluate `offset` rows after the current row.\n      * offset - an int expression which is rows to jump ahead in the partition.\n      * default - a string expression which is to use when the offset is larger than the window.\n          The default value is null.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t2\n       A1\t2\tNULL\n       A2\t3\tNULL\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001\u0002\u0014(\u0001RB\u0001\u0002\u0016\u0001\u0003\u0016\u0004%\t!\u0016\u0005\t-\u0002\u0011\t\u0012)A\u0005\u007f!Aq\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003@\u0011!I\u0006A!f\u0001\n\u0003)\u0006\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011B \t\u0011m\u0003!Q3A\u0005\u0002qC\u0001\u0002\u0019\u0001\u0003\u0012\u0003\u0006I!\u0018\u0005\u0006C\u0002!\tA\u0019\u0005\u0006C\u0002!\t\u0001\u001b\u0005\u0006C\u0002!\t\u0001\u001c\u0005\u0006C\u0002!\t!\u001d\u0005\u0006C\u0002!\t\u0001\u001e\u0005\u0006C\u0002!\tA\u001e\u0005\u0006o\u0002!\t%\u0016\u0005\u0006q\u0002!\t%\u0016\u0005\u0006s\u0002!\t%\u0016\u0005\u0006u\u0002!\tf\u001f\u0005\n\u0003\u000b\u0001\u0011\u0011!C\u0001\u0003\u000fA\u0011\"!\u0005\u0001#\u0003%\t!a\u0005\t\u0013\u0005%\u0002!%A\u0005\u0002\u0005M\u0001\"CA\u0016\u0001E\u0005I\u0011AA\n\u0011%\ti\u0003AI\u0001\n\u0003\ty\u0003C\u0005\u00024\u0001\t\t\u0011\"\u0011\u00026!I\u0011q\t\u0001\u0002\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003#\u0002\u0011\u0011!C\u0001\u0003'B\u0011\"a\u0018\u0001\u0003\u0003%\t%!\u0019\t\u0013\u0005=\u0004!!A\u0005\u0002\u0005E\u0004\"CA;\u0001\u0005\u0005I\u0011IA<\u0011%\tY\bAA\u0001\n\u0003\nihB\u0005\u0002(\u001e\n\t\u0011#\u0001\u0002*\u001aAaeJA\u0001\u0012\u0003\tY\u000b\u0003\u0004bA\u0011\u0005\u00111\u0019\u0005\n\u0003\u000b\u0004\u0013\u0011!C#\u0003\u000fD\u0011\"!3!\u0003\u0003%\t)a3\t\u0013\u0005U\u0007%!A\u0005\u0002\u0006]\u0007\"CAuA\u0005\u0005I\u0011BAv\u0005\u0011aU-\u00193\u000b\u0005!J\u0013aC3yaJ,7o]5p]NT!AK\u0016\u0002\u0011\r\fG/\u00197zgRT!\u0001L\u0017\u0002\u0007M\fHN\u0003\u0002/_\u0005)1\u000f]1sW*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u001b:\u0005\"\u0003\"AN\u001c\u000e\u0003\u001dJ!\u0001O\u0014\u0003;\u0019\u0013\u0018-\\3MKN\u001cxJ\u001a4tKR<\u0016N\u001c3po\u001a+hn\u0019;j_:\u00042AO\u001f@\u001b\u0005Y$B\u0001\u001f*\u0003\u0015!(/Z3t\u0013\tq4HA\u0006UKJt\u0017M]=MS.,\u0007C\u0001\u001cA\u0013\t\tuE\u0001\u0006FqB\u0014Xm]:j_:\u0004\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002J#:\u0011!j\u0014\b\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bN\na\u0001\u0010:p_Rt\u0014\"A#\n\u0005A#\u0015a\u00029bG.\fw-Z\u0005\u0003%N\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0015#\u0002\u000b%t\u0007/\u001e;\u0016\u0003}\na!\u001b8qkR\u0004\u0013AB8gMN,G/A\u0004pM\u001a\u001cX\r\u001e\u0011\u0002\u000f\u0011,g-Y;mi\u0006AA-\u001a4bk2$\b%A\u0006jO:|'/\u001a(vY2\u001cX#A/\u0011\u0005\rs\u0016BA0E\u0005\u001d\u0011un\u001c7fC:\fA\"[4o_J,g*\u001e7mg\u0002\na\u0001P5oSRtD#B2eK\u001a<\u0007C\u0001\u001c\u0001\u0011\u0015!\u0016\u00021\u0001@\u0011\u00159\u0016\u00021\u0001@\u0011\u0015I\u0016\u00021\u0001@\u0011\u0015Y\u0016\u00021\u0001^)\u0011\u0019\u0017N[6\t\u000bQS\u0001\u0019A \t\u000b]S\u0001\u0019A \t\u000beS\u0001\u0019A \u0015\u000b\rlgn\u001c9\t\u000bQ[\u0001\u0019A \t\u000b][\u0001\u0019A \t\u000be[\u0001\u0019A \t\u000bm[\u0001\u0019A \u0015\u0007\r\u00148\u000fC\u0003U\u0019\u0001\u0007q\bC\u0003X\u0019\u0001\u0007q\b\u0006\u0002dk\")A+\u0004a\u0001\u007fQ\t1-A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$Ra\u0019?\u007f\u0003\u0003AQ! \nA\u0002}\n\u0001B\\3x\r&\u00148\u000f\u001e\u0005\u0006\u007fJ\u0001\raP\u0001\n]\u0016<8+Z2p]\u0012Da!a\u0001\u0013\u0001\u0004y\u0014\u0001\u00038foRC\u0017N\u001d3\u0002\t\r|\u0007/\u001f\u000b\nG\u0006%\u00111BA\u0007\u0003\u001fAq\u0001V\n\u0011\u0002\u0003\u0007q\bC\u0004X'A\u0005\t\u0019A \t\u000fe\u001b\u0002\u0013!a\u0001\u007f!91l\u0005I\u0001\u0002\u0004i\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003+Q3aPA\fW\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0012\t\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0012Q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!\r+\u0007u\u000b9\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003o\u0001B!!\u000f\u0002D5\u0011\u00111\b\u0006\u0005\u0003{\ty$\u0001\u0003mC:<'BAA!\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00131\b\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0003cA\"\u0002N%\u0019\u0011q\n#\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00131\f\t\u0004\u0007\u0006]\u0013bAA-\t\n\u0019\u0011I\\=\t\u0013\u0005u#$!AA\u0002\u0005-\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002dA1\u0011QMA6\u0003+j!!a\u001a\u000b\u0007\u0005%D)\u0001\u0006d_2dWm\u0019;j_:LA!!\u001c\u0002h\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ri\u00161\u000f\u0005\n\u0003;b\u0012\u0011!a\u0001\u0003+\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qGA=\u0011%\ti&HA\u0001\u0002\u0004\tY%\u0001\u0004fcV\fGn\u001d\u000b\u0004;\u0006}\u0004\"CA/=\u0005\u0005\t\u0019AA+Q]\u0001\u00111QAE\u0003\u0017\u000by)!%\u0002\u0016\u0006]\u00151TAO\u0003C\u000b\u0019\u000bE\u00027\u0003\u000bK1!a\"(\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!$\u0002\u0007#S\u0001\u0005\t\u0011!?\u001a+fjQ0)S:\u0004X\u000f^.-A=4gm]3u72\u0002C-\u001a4bk2$X,X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!m\u0006dW/\u001a\u0011pM\u0002\u0002\u0017N\u001c9vi\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004\u0003m\u001c4gg\u0016$\b\r\u001e5!e><(\u0002\t\u0011!A\u0001\u0002\u0013M\u001a;fe\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!e><\b%\u001b8!i\",\u0007e^5oI><h\u0006\t+iK\u0002\"WMZ1vYR\u0004c/\u00197vK\u0002zg\r\t1pM\u001a\u001cX\r\u001e1!SN\u0004\u0013\u0007I1oI\u0002\"\b.\u001a\u0011eK\u001a\fW\u000f\u001c;\u000bA\u0001\u0002\u0003\u0005\t\u0011wC2,X\rI8gA\u0001$WMZ1vYR\u0004\u0007%[:!]VdGN\f\u0011JM\u0002\"\b.\u001a\u0011wC2,X\rI8gA\u0001Lg\u000e];uA\u0002\nG\u000f\t;iK\u0002\u0002wN\u001a4tKR\u0004G\u000f\u001b\u0011s_^\u0004\u0013n\u001d\u0011ok2dGF\u0003\u0011!A\u0001\u0002\u0003E\\;mY\u0002J7\u000f\t:fiV\u0014h.\u001a3/A%3\u0007\u0005\u001e5fe\u0016\u0004\u0013n\u001d\u0011o_\u0002\u001aXo\u00195!C:\u0004sN\u001a4tKR\u0004#o\\<!Q\u0015tsM\f\u0017!o\",g\u000e\t;iK\u0002zgMZ:fi\u0002J7\u000fI\u0019-AQDW\r\t7bgRT\u0001\u0005\t\u0011!A\u0001\u0012xn\u001e\u0011pM\u0002\"\b.\u001a\u0011xS:$wn\u001e\u0011e_\u0016\u001c\bE\\8uA!\fg/\u001a\u0011b]f\u00043/\u001e2tKF,XM\u001c;!e><\u0018\u0006\f\u0011aI\u00164\u0017-\u001e7uA\u0002J7\u000f\t:fiV\u0014h.\u001a3/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\t\u0019*\u0001B?\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u0013N\u001c9vi\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:\u0004Co\u001c\u0011fm\u0006dW/\u0019;fA\u0001|gMZ:fi\u0002\u0004#o\\<tA\u00054G/\u001a:!i\",\u0007eY;se\u0016tG\u000f\t:po:R\u0001\u0005\t\u0011!A\u0001R\u0003e\u001c4gg\u0016$\b%\f\u0011b]\u0002Jg\u000e\u001e\u0011fqB\u0014Xm]:j_:\u0004s\u000f[5dQ\u0002J7\u000f\t:poN\u0004Co\u001c\u0011kk6\u0004\b%\u00195fC\u0012\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0003/\u0019:uSRLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0011,g-Y;mi\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:\u0004s\u000f[5dQ\u0002J7\u000f\t;pAU\u001cX\rI<iK:\u0004C\u000f[3!_\u001a47/\u001a;!SN\u0004C.\u0019:hKJ\u0004C\u000f[1oAQDW\rI<j]\u0012|wO\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011eK\u001a\fW\u000f\u001c;!m\u0006dW/\u001a\u0011jg\u0002rW\u000f\u001c7/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005e\u0015!a)\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\u0005d\u0003E\u0019\u0017!?\u001a+fjQ0)E&\u0002sJV#SA!\u0002\u0016I\u0015+J)&{e\n\t\"ZA\u0005\u0004sJ\u0015#F%\u0002\u0012\u0015\f\t2*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)O\u0005\u000bt\u0005\f\u00113S1\u0002\u0003fJ!2O1\u0002\u0013'\u000b\u0017!Q\u001d\n%g\n\u0017!g%b\u0003\u0005K\u0014Bc\u001db\u0003%M\u0015!i\u0006\u0014\u0007&\u0019\u0017!E&Z$\u0002\t\u0011!A\u0001\u0002\u0003%Q\u0019\nc%\t$\u0002\t\u0011!A\u0001\u0002\u0003%Q\u0019\nc%\u0011$\u0002\t\u0011!A\u0001\u0002\u0003%Q\u0019\ne%qU\u000b\u0014'\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003JJ1'\u0003(V\u00192S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003?\u000bQA\r\u00181]A\nQa\u001a:pkB\f#!!*\u0002\u0019]Lg\u000eZ8x?\u001a,hnY:\u0002\t1+\u0017\r\u001a\t\u0003m\u0001\u001aR\u0001IAW\u0003s\u0003\u0012\"a,\u00026~zt(X2\u000e\u0005\u0005E&bAAZ\t\u00069!/\u001e8uS6,\u0017\u0002BA\\\u0003c\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85!\u0011\tY,!1\u000e\u0005\u0005u&\u0002BA`\u0003\u007f\t!![8\n\u0007I\u000bi\f\u0006\u0002\u0002*\u0006AAo\\*ue&tw\r\u0006\u0002\u00028\u0005)\u0011\r\u001d9msRI1-!4\u0002P\u0006E\u00171\u001b\u0005\u0006)\u000e\u0002\ra\u0010\u0005\u0006/\u000e\u0002\ra\u0010\u0005\u00063\u000e\u0002\ra\u0010\u0005\u00067\u000e\u0002\r!X\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI.!:\u0011\u000b\r\u000bY.a8\n\u0007\u0005uGI\u0001\u0004PaRLwN\u001c\t\b\u0007\u0006\u0005xhP ^\u0013\r\t\u0019\u000f\u0012\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\u0005\u001dH%!AA\u0002\r\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\u000f\u0005\u0003\u0002:\u0005=\u0018\u0002BAy\u0003w\u0011aa\u00142kK\u000e$\b")
public class Lead
extends FrameLessOffsetWindowFunction
implements TernaryLike<Expression>,
Serializable {
    private final Expression input;
    private final Expression offset;
    private final Expression default;
    private final boolean ignoreNulls;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(Lead x$0) {
        return Lead$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, Lead> tupled() {
        return Lead$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Lead>>>> curried() {
        return Lead$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Lead lead = this;
        synchronized (lead) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression input() {
        return this.input;
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    @Override
    public Expression default() {
        return this.default;
    }

    @Override
    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public Expression first() {
        return this.input();
    }

    @Override
    public Expression second() {
        return this.offset();
    }

    @Override
    public Expression third() {
        return this.default();
    }

    @Override
    public Lead withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public Lead copy(Expression input, Expression offset, Expression expression, boolean ignoreNulls) {
        return new Lead(input, offset, expression, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.offset();
    }

    public Expression copy$default$3() {
        return this.default();
    }

    public boolean copy$default$4() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "Lead";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
            case 1: {
                return this.offset();
            }
            case 2: {
                return this.default();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Lead;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "input";
            }
            case 1: {
                return "offset";
            }
            case 2: {
                return "default";
            }
            case 3: {
                return "ignoreNulls";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Lead)) return false;
        boolean bl = true;
        if (!bl) return false;
        Lead lead = (Lead)x$1;
        if (this.ignoreNulls() != lead.ignoreNulls()) return false;
        Expression expression = this.input();
        Expression expression2 = lead.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.offset();
        Expression expression4 = lead.offset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.default();
        Expression expression6 = lead.default();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!lead.canEqual(this)) return false;
        return true;
    }

    public Lead(Expression input, Expression offset, Expression expression, boolean ignoreNulls) {
        this.input = input;
        this.offset = offset;
        this.default = expression;
        this.ignoreNulls = ignoreNulls;
        TernaryLike.$init$(this);
    }

    public Lead(Expression input, Expression offset, Expression expression) {
        this(input, offset, expression, false);
    }

    public Lead(Expression input, Expression offset, Expression expression, Expression ignoreNulls) {
        this(input, offset, expression, WindowExpression$.MODULE$.expressionToIngnoreNulls(ignoreNulls, "lead"));
    }

    public Lead(Expression input, Expression offset) {
        this(input, offset, Literal$.MODULE$.apply(null));
    }

    public Lead(Expression input) {
        this(input, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }

    public Lead() {
        this(Literal$.MODULE$.apply(null));
    }
}

