/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NettyManagedBuffer;
import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.RequestMessage;

public final class RpcRequest
extends AbstractMessage
implements RequestMessage {
    public final long requestId;

    public RpcRequest(long requestId, ManagedBuffer message) {
        super(message, true);
        this.requestId = requestId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RpcRequest;
    }

    @Override
    public int encodedLength() {
        return 12;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        buf.writeInt((int)this.body().size());
    }

    public static RpcRequest decode(ByteBuf buf) {
        long requestId = buf.readLong();
        buf.readInt();
        return new RpcRequest(requestId, new NettyManagedBuffer(buf.retain()));
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.body());
    }

    public boolean equals(Object other) {
        if (other instanceof RpcRequest) {
            RpcRequest o = (RpcRequest)other;
            return this.requestId == o.requestId && super.equals(o);
        }
        return false;
    }

    public String toString() {
        return "RpcRequest[requestId=" + this.requestId + ",body=" + String.valueOf(this.body()) + "]";
    }
}

