/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.SparkIntervalUtils$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.ScalaRunTime$;

public final class Triggers$ {
    public static final Triggers$ MODULE$ = new Triggers$();

    public void validate(long intervalMs) {
        Predef$.MODULE$.require(intervalMs >= 0L, (Function0 & Serializable)() -> "the interval of trigger should not be negative");
    }

    public long convert(String interval) {
        CalendarInterval cal = SparkIntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)interval));
        if (cal.months != 0) {
            throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3262", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"interval"), (Object)interval)})));
        }
        long microsInDays = Math.multiplyExact((long)cal.days, 86400000000L);
        return SparkDateTimeUtils$.MODULE$.microsToMillis(Math.addExact(cal.microseconds, microsInDays));
    }

    public long convert(Duration interval) {
        return interval.toMillis();
    }

    public long convert(long interval, TimeUnit unit) {
        return unit.toMillis(interval);
    }

    private Triggers$() {
    }
}

