/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.HadoopMapReduceCommitProtocol;
import org.apache.spark.internal.io.HadoopWriteConfigUtil;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class SparkHadoopWriter$
implements Logging {
    public static final SparkHadoopWriter$ MODULE$ = new SparkHadoopWriter$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <K, V> void write(RDD<Tuple2<K, V>> rdd, HadoopWriteConfigUtil<K, V> config, ClassTag<V> evidence$1) {
        SparkContext sparkContext = rdd.context();
        int commitJobId = rdd.id();
        String jobTrackerId = SparkHadoopWriterUtils$.MODULE$.createJobTrackerID(new Date());
        JobContext jobContext = config.createJobContext(jobTrackerId, commitJobId);
        config.initOutputFormat(jobContext);
        config.assertConf(jobContext, rdd.conf());
        jobContext.getConfiguration().set("spark.sql.sources.writeJobUUID", UUID.randomUUID().toString());
        HadoopMapReduceCommitProtocol committer = config.createCommitter(commitJobId);
        committer.setupJob(jobContext);
        try {
            FileCommitProtocol.TaskCommitMessage[] ret = (FileCommitProtocol.TaskCommitMessage[])sparkContext.runJob(rdd, (Function2 & Serializable)(context, iter) -> {
                int attemptId = context.stageAttemptNumber() << 16 | context.attemptNumber();
                return MODULE$.executeTask((TaskContext)context, config, jobTrackerId, commitJobId, context.partitionId(), attemptId, committer, (Iterator)iter, evidence$1);
            }, ClassTag$.MODULE$.apply(FileCommitProtocol.TaskCommitMessage.class));
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Start to commit write Job ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.JOB_ID, jobContext.getJobID())}))));
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((JFunction0.mcV.sp & Serializable)() -> committer.commitJob(jobContext, (Seq<FileCommitProtocol.TaskCommitMessage>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)ret).toImmutableArraySeq()));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long duration = tuple2._2$mcJ$sp();
            long duration2 = duration;
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Write Job ", " committed."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.JOB_ID, jobContext.getJobID())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" Elapsed time: ", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.DURATION, BoxesRunTime.boxToLong((long)duration2))})))));
        }
        catch (Throwable cause) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting job ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.JOB_ID, jobContext.getJobID())}))), cause);
            committer.abortJob(jobContext);
            throw new SparkException("Job aborted.", cause);
        }
    }

    private <K, V> FileCommitProtocol.TaskCommitMessage executeTask(TaskContext context, HadoopWriteConfigUtil<K, V> config, String jobTrackerId, int commitJobId, int sparkPartitionId, int sparkAttemptNumber, FileCommitProtocol committer, Iterator<Tuple2<K, V>> iterator, ClassTag<V> evidence$2) {
        FileCommitProtocol.TaskCommitMessage taskCommitMessage;
        TaskAttemptContext taskContext = config.createTaskAttemptContext(jobTrackerId, commitJobId, sparkPartitionId, sparkAttemptNumber);
        committer.setupTask(taskContext);
        config.initWriter(taskContext, sparkPartitionId);
        LongRef recordsWritten = LongRef.create((long)0L);
        Tuple2<OutputMetrics, Function0<Object>> tuple2 = SparkHadoopWriterUtils$.MODULE$.initHadoopOutputMetrics(context);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        OutputMetrics outputMetrics = (OutputMetrics)tuple2._1();
        Function0 callback = (Function0)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)outputMetrics, (Object)callback);
        OutputMetrics outputMetrics2 = (OutputMetrics)tuple22._1();
        Function0 callback2 = (Function0)tuple22._2();
        try {
            Function0 & Serializable x$1 = (Function0 & Serializable)() -> {
                while (iterator.hasNext()) {
                    Tuple2 pair = (Tuple2)iterator.next();
                    config.write(pair);
                    SparkHadoopWriterUtils$.MODULE$.maybeUpdateOutputMetrics(outputMetrics2, (Function0<Object>)callback2, recordsWritten$1.elem);
                    ++recordsWritten$1.elem;
                }
                config.closeWriter(taskContext);
                return committer.commitTask(taskContext);
            };
            JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> {
                try {
                    config.closeWriter(taskContext);
                }
                finally {
                    committer.abortTask(taskContext);
                    MODULE$.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Task ", " aborted."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TASK_ATTEMPT_ID, taskContext.getTaskAttemptID())}))));
                }
            };
            JFunction0.mcV.sp & Serializable x$3 = (JFunction0.mcV.sp & Serializable)() -> Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(x$1);
            FileCommitProtocol.TaskCommitMessage ret = (FileCommitProtocol.TaskCommitMessage)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks(x$1, (Function0<BoxedUnit>)x$2, (Function0<BoxedUnit>)x$3);
            outputMetrics2.setBytesWritten(callback2.apply$mcJ$sp());
            outputMetrics2.setRecordsWritten(recordsWritten.elem);
            taskCommitMessage = ret;
        }
        catch (Throwable t) {
            throw new SparkException("Task failed while writing rows", t);
        }
        return taskCommitMessage;
    }

    private SparkHadoopWriter$() {
    }
}

