% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jvm.R
\name{sparkR.newJObject}
\alias{sparkR.newJObject}
\title{Create Java Objects}
\usage{
sparkR.newJObject(x, ...)
}
\arguments{
\item{x}{fully qualified Java class name.}

\item{...}{arguments to be passed to the constructor.}
}
\value{
the object created. Either returned as a R object
  if it can be deserialized or returned as a "jobj". See details section for more.
}
\description{
Create a new Java object in the JVM running the Spark driver. The return
value is automatically converted to an R object for simple objects. Other
values are returned as a "jobj" which is a reference to an object on JVM.
}
\details{
This is a low level function to access the JVM directly and should only be used
for advanced use cases. The arguments and return values that are primitive R
types (like integer, numeric, character, lists) are automatically translated to/from
Java types (like Integer, Double, String, Array). A full list can be found in
serialize.R and deserialize.R in the Apache Spark code base.
}
\note{
sparkR.newJObject since 2.0.1
}
\examples{
\dontrun{
sparkR.session() # Need to have a Spark JVM running before calling newJObject
# Create a Java ArrayList and populate it
jarray <- sparkR.newJObject("java.util.ArrayList")
sparkR.callJMethod(jarray, "add", 42L)
sparkR.callJMethod(jarray, "get", 0L) # Will print 42
}
}
\seealso{
\link{sparkR.callJMethod}, \link{sparkR.callJStatic}
}
