/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.variant.VariantCastArgs;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantSchema;
import org.apache.spark.unsafe.types.VariantVal;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e3aa\u0002\u0005!\u0002\u001b9\u0002\"\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u000f&\u0011%1\u0003A!A!\u0002\u00139C\u0006C\u0005.\u0001\t\u0005\t\u0015!\u0003/o!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003G\u0001\u0011\u0005sIA\u0007WCJL\u0017M\u001c;SK\u0006$WM\u001d\u0006\u0003\u0013)\tq\u0001]1scV,GO\u0003\u0002\f\u0019\u0005YA-\u0019;bg>,(oY3t\u0015\tia\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033ii\u0011\u0001C\u0005\u00037!\u0011A\u0003U1scV,GOV1sS\u0006tGOU3bI\u0016\u0014\u0018AB:dQ\u0016l\u0017\r\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u00059a/\u0019:jC:$(B\u0001\u0012\u0011\u0003\u0015!\u0018\u0010]3t\u0013\t!sDA\u0007WCJL\u0017M\u001c;TG\",W.Y\u0005\u00039i\t!\u0002^1sO\u0016$H+\u001f9f!\tA#&D\u0001*\u0015\t\u0011c\"\u0003\u0002,S\tAA)\u0019;b)f\u0004X-\u0003\u0002'5\u0005A1-Y:u\u0003J<7\u000f\u0005\u00020k5\t\u0001G\u0003\u0002!c)\u0011!gM\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00025\u001d\u0005A1-\u0019;bYf\u001cH/\u0003\u00027a\tya+\u0019:jC:$8)Y:u\u0003J<7/\u0003\u0002.5\u0005!\u0012n\u001d+pa2+g/\u001a7V]ND'/\u001a3eK\u0012\u0004\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0006\u0003\n\u001bE)\u0012\t\u00033\u0001AQ\u0001H\u0003A\u0002uAQAJ\u0003A\u0002\u001dBQ!L\u0003A\u00029BQ\u0001O\u0003A\u0002e\nAA]3bIR\u0019\u0001jS)\u0011\u0005iJ\u0015B\u0001&<\u0005\r\te.\u001f\u0005\u0006\u0019\u001a\u0001\r!T\u0001\u0004e><\bC\u0001(P\u001b\u0005\u0019\u0014B\u0001)4\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000bI3\u0001\u0019A*\u0002!Q|\u0007\u000fT3wK2lU\r^1eCR\f\u0007c\u0001\u001eU-&\u0011Qk\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003u]K!\u0001W\u001e\u0003\t\tKH/\u001a")
public final class VariantReader
extends ParquetVariantReader {
    private final boolean isTopLevelUnshredded;

    @Override
    public Object read(InternalRow row, byte[] topLevelMetadata) {
        if (this.isTopLevelUnshredded) {
            if (row.isNullAt(super.schema().variantIdx)) {
                throw QueryExecutionErrors$.MODULE$.malformedVariant();
            }
            return new VariantVal(row.getBinary(super.schema().variantIdx), topLevelMetadata);
        }
        Variant v = this.rebuildVariant(row, topLevelMetadata);
        return new VariantVal(v.getValue(), v.getMetadata());
    }

    public VariantReader(VariantSchema schema, DataType targetType, VariantCastArgs castArgs, boolean isTopLevelUnshredded) {
        this.isTopLevelUnshredded = isTopLevelUnshredded;
        super(schema, targetType, castArgs);
    }
}

