/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.internal.types.SpatialReferenceSystemMapper;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.GeometryType;
import org.apache.spark.sql.types.SpatialType;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Experimental
public final class GeometryType$
extends AbstractDataType
implements SpatialType,
Serializable {
    public static final GeometryType$ MODULE$ = new GeometryType$();
    private static final GeometryType GEOMETRY_MIXED_TYPE;
    private static int MIXED_SRID;
    private static String MIXED_CRS;

    static {
        SpatialType.$init$(MODULE$);
        GEOMETRY_MIXED_TYPE = MODULE$.apply(MODULE$.MIXED_CRS());
    }

    @Override
    public final int MIXED_SRID() {
        return MIXED_SRID;
    }

    @Override
    public final String MIXED_CRS() {
        return MIXED_CRS;
    }

    @Override
    public final void org$apache$spark$sql$types$SpatialType$_setter_$MIXED_SRID_$eq(int x$1) {
        MIXED_SRID = x$1;
    }

    @Override
    public final void org$apache$spark$sql$types$SpatialType$_setter_$MIXED_CRS_$eq(String x$1) {
        MIXED_CRS = x$1;
    }

    public final int GEOMETRY_DEFAULT_SRID() {
        return 4326;
    }

    public final String GEOMETRY_DEFAULT_CRS() {
        return "OGC:CRS84";
    }

    private final GeometryType GEOMETRY_MIXED_TYPE() {
        return GEOMETRY_MIXED_TYPE;
    }

    public GeometryType apply(int srid) {
        String crs = SpatialReferenceSystemMapper.get().getStringId(srid);
        if (crs == null) {
            throw new SparkIllegalArgumentException("ST_INVALID_SRID_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srid"), (Object)Integer.toString(srid))})));
        }
        return new GeometryType(crs);
    }

    public GeometryType apply(String crs) {
        String string = crs;
        switch (string == null ? 0 : string.hashCode()) {
            case 64972: {
                if (!"ANY".equals(string)) break;
                return new GeometryType(this.MIXED_CRS());
            }
        }
        return new GeometryType(crs);
    }

    @Override
    public DataType defaultConcreteType() {
        return this.GEOMETRY_MIXED_TYPE();
    }

    @Override
    public boolean acceptsType(DataType other) {
        return other instanceof GeometryType;
    }

    @Override
    public String simpleString() {
        return "geometry";
    }

    public int toSrid(String crs) {
        if (crs.equalsIgnoreCase(this.MIXED_CRS())) {
            return this.MIXED_SRID();
        }
        Integer srid = SpatialReferenceSystemMapper.get().getSrid(crs);
        if (srid == null) {
            throw new SparkIllegalArgumentException("ST_INVALID_CRS_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"crs"), (Object)crs)})));
        }
        return Predef$.MODULE$.Integer2int(srid);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GeometryType$.class);
    }

    private GeometryType$() {
    }
}

