/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.physical.NullScanTaskDispatcher;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataOnlyOptimizer
implements PhysicalPlanResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)MetadataOnlyOptimizer.class.getName());

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%"), new TableScanProcessor());
        opRules.put(new RuleRegExp("R2", GroupByOperator.getOperatorName() + "%.*" + FileSinkOperator.getOperatorName() + "%"), new FileSinkProcessor());
        NullScanTaskDispatcher disp = new NullScanTaskDispatcher(pctx, opRules);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static class FileSinkProcessor
    implements NodeProcessor {
        private FileSinkProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            WalkerCtx walkerCtx = (WalkerCtx)procCtx;
            if (walkerCtx.getMayBeMetadataOnlyTableScans().isEmpty()) {
                return nd;
            }
            for (Node op : stack) {
                GroupByOperator gby;
                if (!(op instanceof GroupByOperator) || ((GroupByDesc)(gby = (GroupByOperator)op).getConf()).isDistinctLike()) continue;
                walkerCtx.convertNotMetadataOnly();
                return nd;
            }
            walkerCtx.convertMetadataOnly();
            return nd;
        }
    }

    private static class TableScanProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator tsOp = (TableScanOperator)nd;
            WalkerCtx walkerCtx = (WalkerCtx)procCtx;
            List<Integer> colIDs = tsOp.getNeededColumnIDs();
            TableScanDesc desc = (TableScanDesc)tsOp.getConf();
            boolean noColNeeded = colIDs == null || colIDs.isEmpty();
            boolean noVCneeded = desc == null || desc.getVirtualCols() == null || desc.getVirtualCols().isEmpty();
            boolean isSkipHF = desc.isNeedSkipHeaderFooters();
            if (noColNeeded && noVCneeded && !isSkipHF) {
                walkerCtx.setMayBeMetadataOnly(tsOp);
            }
            return nd;
        }
    }

    static class WalkerCtx
    implements NodeProcessorCtx {
        private final HashSet<TableScanOperator> possible = new HashSet();
        private final HashSet<TableScanOperator> success = new HashSet();

        WalkerCtx() {
        }

        public void setMayBeMetadataOnly(TableScanOperator op) {
            this.possible.add(op);
        }

        public void convertMetadataOnly() {
            this.success.addAll(this.possible);
            this.possible.clear();
        }

        public void convertNotMetadataOnly() {
            this.possible.clear();
            this.success.clear();
        }

        public HashSet<TableScanOperator> getMayBeMetadataOnlyTableScans() {
            return this.possible;
        }

        public HashSet<TableScanOperator> getMetadataOnlyTableScans() {
            return this.success;
        }
    }
}

