/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedLockManager
implements HiveLockManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)"EmbeddedHiveLockManager");
    private final Node root = new Node();
    private HiveLockManagerCtx ctx;
    private long sleepTime = 1000L;
    private int numRetriesForLock = 0;
    private int numRetriesForUnLock = 0;

    @Override
    public void setContext(HiveLockManagerCtx ctx) throws LockException {
        this.ctx = ctx;
        this.refresh();
    }

    @Override
    public HiveLock lock(HiveLockObject key, HiveLockMode mode, boolean keepAlive) throws LockException {
        return this.lock(key, mode, this.numRetriesForLock, this.sleepTime);
    }

    @Override
    public List<HiveLock> lock(List<HiveLockObj> objs, boolean keepAlive, Driver.LockedDriverState lDrvState) throws LockException {
        return this.lock(objs, this.numRetriesForLock, this.sleepTime);
    }

    @Override
    public void unlock(HiveLock hiveLock) throws LockException {
        this.unlock(hiveLock, this.numRetriesForUnLock, this.sleepTime);
    }

    @Override
    public void releaseLocks(List<HiveLock> hiveLocks) {
        this.releaseLocks(hiveLocks, this.numRetriesForUnLock, this.sleepTime);
    }

    @Override
    public List<HiveLock> getLocks(boolean verifyTablePartitions, boolean fetchData) throws LockException {
        return this.getLocks(verifyTablePartitions, fetchData, this.ctx.getConf());
    }

    @Override
    public List<HiveLock> getLocks(HiveLockObject key, boolean verifyTablePartitions, boolean fetchData) throws LockException {
        return this.getLocks(key, verifyTablePartitions, fetchData, this.ctx.getConf());
    }

    @Override
    public void prepareRetry() {
    }

    @Override
    public void refresh() {
        HiveConf conf = this.ctx.getConf();
        this.sleepTime = conf.getTimeVar(HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES, TimeUnit.MILLISECONDS);
        this.numRetriesForLock = conf.getIntVar(HiveConf.ConfVars.HIVE_LOCK_NUMRETRIES);
        this.numRetriesForUnLock = conf.getIntVar(HiveConf.ConfVars.HIVE_UNLOCK_NUMRETRIES);
    }

    public HiveLock lock(HiveLockObject key, HiveLockMode mode, int numRetriesForLock, long sleepTime) throws LockException {
        for (int i = 0; i <= numRetriesForLock; ++i) {
            HiveLock lock;
            if (i > 0) {
                this.sleep(sleepTime);
            }
            if ((lock = this.lockPrimitive(key, mode)) == null) continue;
            return lock;
        }
        return null;
    }

    private void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public List<HiveLock> lock(List<HiveLockObj> objs, int numRetriesForLock, long sleepTime) throws LockException {
        this.sortLocks(objs);
        for (int i = 0; i <= numRetriesForLock; ++i) {
            List<HiveLock> locks;
            if (i > 0) {
                this.sleep(sleepTime);
            }
            if ((locks = this.lockPrimitive(objs, numRetriesForLock, sleepTime)) == null) continue;
            return locks;
        }
        return null;
    }

    private HiveLock lockPrimitive(HiveLockObject key, HiveLockMode mode) throws LockException {
        if (this.root.lock(key.getPaths(), key.getData(), mode == HiveLockMode.EXCLUSIVE)) {
            return new SimpleHiveLock(key, mode);
        }
        return null;
    }

    private List<HiveLock> lockPrimitive(List<HiveLockObj> objs, int numRetriesForLock, long sleepTime) throws LockException {
        ArrayList<HiveLock> locks = new ArrayList<HiveLock>();
        for (HiveLockObj obj : objs) {
            HiveLock lock = this.lockPrimitive(obj.getObj(), obj.getMode());
            if (lock == null) {
                this.releaseLocks(locks, numRetriesForLock, sleepTime);
                return null;
            }
            locks.add(lock);
        }
        return locks;
    }

    private void sortLocks(List<HiveLockObj> objs) {
        Collections.sort(objs, new Comparator<HiveLockObj>(){

            @Override
            public int compare(HiveLockObj o1, HiveLockObj o2) {
                int cmp = o1.getName().compareTo(o2.getName());
                if (cmp == 0) {
                    if (o1.getMode() == o2.getMode()) {
                        return cmp;
                    }
                    if (o1.getMode() == HiveLockMode.EXCLUSIVE) {
                        return -1;
                    }
                    return 1;
                }
                return cmp;
            }
        });
    }

    public void unlock(HiveLock hiveLock, int numRetriesForUnLock, long sleepTime) throws LockException {
        String[] paths = hiveLock.getHiveLockObject().getPaths();
        HiveLockObject.HiveLockObjectData data = hiveLock.getHiveLockObject().getData();
        for (int i = 0; i <= numRetriesForUnLock; ++i) {
            if (i > 0) {
                this.sleep(sleepTime);
            }
            if (!this.root.unlock(paths, data)) continue;
            return;
        }
        throw new LockException("Failed to release lock " + hiveLock);
    }

    public void releaseLocks(List<HiveLock> hiveLocks, int numRetriesForUnLock, long sleepTime) {
        for (HiveLock locked : hiveLocks) {
            try {
                this.unlock(locked, numRetriesForUnLock, sleepTime);
            }
            catch (LockException e) {
                LOG.info("Failed to unlock ", (Throwable)e);
            }
        }
    }

    public List<HiveLock> getLocks(boolean verifyTablePartitions, boolean fetchData, HiveConf conf) throws LockException {
        return this.root.getLocks(verifyTablePartitions, fetchData, conf);
    }

    public List<HiveLock> getLocks(HiveLockObject key, boolean verifyTablePartitions, boolean fetchData, HiveConf conf) throws LockException {
        return this.root.getLocks(key.getPaths(), verifyTablePartitions, fetchData, conf);
    }

    private HiveLockObject verify(boolean verify, String[] names, HiveLockObject.HiveLockObjectData data, HiveConf conf) throws LockException {
        if (!verify) {
            return new HiveLockObject(names, data);
        }
        String database = names[0];
        String table = names[1];
        try {
            Partition partn;
            Hive db = Hive.get(conf);
            Table tab = db.getTable(database, table, false);
            if (tab == null) {
                return null;
            }
            if (names.length == 2) {
                return new HiveLockObject(tab, data);
            }
            HashMap<String, String> partSpec = new HashMap<String, String>();
            for (int indx = 2; indx < names.length; ++indx) {
                String[] partVals = names[indx].split("=");
                partSpec.put(partVals[0], partVals[1]);
            }
            try {
                partn = db.getPartition(tab, partSpec, false);
            }
            catch (HiveException e) {
                partn = null;
            }
            if (partn == null) {
                return new HiveLockObject(new DummyPartition(tab, null, partSpec), data);
            }
            return new HiveLockObject(partn, data);
        }
        catch (Exception e) {
            throw new LockException(e);
        }
    }

    @Override
    public void close() {
        this.root.lock.lock();
        try {
            this.root.datas = null;
            this.root.children = null;
        }
        finally {
            this.root.lock.unlock();
        }
    }

    private static class SimpleHiveLock
    extends HiveLock {
        private final HiveLockObject lockObj;
        private final HiveLockMode lockMode;

        public SimpleHiveLock(HiveLockObject lockObj, HiveLockMode lockMode) {
            this.lockObj = lockObj;
            this.lockMode = lockMode;
        }

        @Override
        public HiveLockObject getHiveLockObject() {
            return this.lockObj;
        }

        @Override
        public HiveLockMode getHiveLockMode() {
            return this.lockMode;
        }

        public String toString() {
            return (Object)((Object)this.lockMode) + "=" + this.lockObj.getDisplayName() + "(" + this.lockObj.getData() + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleHiveLock)) {
                return false;
            }
            SimpleHiveLock simpleLock = (SimpleHiveLock)o;
            return this.lockObj.equals(simpleLock.getHiveLockObject()) && this.lockMode == simpleLock.getHiveLockMode();
        }
    }

    private class Node {
        private boolean exclusive;
        private Map<String, Node> children;
        private Map<String, HiveLockObject.HiveLockObjectData> datas;
        private final ReentrantLock lock = new ReentrantLock();

        public void set(HiveLockObject.HiveLockObjectData data, boolean exclusive) {
            this.exclusive = exclusive;
            if (this.datas == null) {
                this.datas = new HashMap<String, HiveLockObject.HiveLockObjectData>(3);
            }
            this.datas.put(data.getQueryId(), data);
        }

        public boolean lock(String[] paths, HiveLockObject.HiveLockObjectData data, boolean exclusive) {
            return this.lock(paths, 0, data, exclusive);
        }

        public boolean unlock(String[] paths, HiveLockObject.HiveLockObjectData data) {
            return this.unlock(paths, 0, data);
        }

        private List<HiveLock> getLocks(boolean verify, boolean fetchData, HiveConf conf) throws LockException {
            if (!EmbeddedLockManager.this.root.hasChild()) {
                return Collections.emptyList();
            }
            ArrayList<HiveLock> locks = new ArrayList<HiveLock>();
            this.getLocks(new Stack<String>(), verify, fetchData, locks, conf);
            return locks;
        }

        private List<HiveLock> getLocks(String[] paths, boolean verify, boolean fetchData, HiveConf conf) throws LockException {
            if (!EmbeddedLockManager.this.root.hasChild()) {
                return Collections.emptyList();
            }
            ArrayList<HiveLock> locks = new ArrayList<HiveLock>();
            this.getLocks(paths, 0, verify, fetchData, locks, conf);
            return locks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean lock(String[] paths, int index, HiveLockObject.HiveLockObjectData data, boolean exclusive) {
            if (!this.lock.tryLock()) {
                return false;
            }
            try {
                Node child;
                if (index == paths.length) {
                    if (this.exclusive || exclusive && this.hasLock()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.set(data, exclusive);
                    boolean bl = true;
                    return bl;
                }
                if (this.children == null) {
                    this.children = new HashMap<String, Node>(3);
                    child = new Node();
                    this.children.put(paths[index], child);
                } else {
                    child = this.children.get(paths[index]);
                    if (child == null) {
                        child = new Node();
                        this.children.put(paths[index], child);
                    }
                }
                boolean bl = child.lock(paths, index + 1, data, exclusive);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean unlock(String[] paths, int index, HiveLockObject.HiveLockObjectData data) {
            if (!this.lock.tryLock()) {
                return false;
            }
            try {
                Node child;
                if (index == paths.length) {
                    if (this.hasLock()) {
                        this.datas.remove(data.getQueryId());
                    }
                    boolean bl = true;
                    return bl;
                }
                Node node = child = this.children == null ? null : this.children.get(paths[index]);
                if (child == null) {
                    boolean bl = true;
                    return bl;
                }
                if (child.unlock(paths, index + 1, data)) {
                    if (!child.hasLock() && !child.hasChild()) {
                        this.children.remove(paths[index]);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getLocks(Stack<String> names, boolean verify, boolean fetchData, List<HiveLock> locks, HiveConf conf) throws LockException {
            this.lock.lock();
            try {
                if (this.hasLock()) {
                    this.getLocks(names.toArray(new String[names.size()]), verify, fetchData, locks, conf);
                }
                if (this.children != null) {
                    for (Map.Entry<String, Node> entry : this.children.entrySet()) {
                        names.push(entry.getKey());
                        entry.getValue().getLocks(names, verify, fetchData, locks, conf);
                        names.pop();
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getLocks(String[] paths, int index, boolean verify, boolean fetchData, List<HiveLock> locks, HiveConf conf) throws LockException {
            this.lock.lock();
            try {
                if (index == paths.length) {
                    this.getLocks(paths, verify, fetchData, locks, conf);
                    return;
                }
                Node child = this.children.get(paths[index]);
                if (child != null) {
                    child.getLocks(paths, index + 1, verify, fetchData, locks, conf);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void getLocks(String[] paths, boolean verify, boolean fetchData, List<HiveLock> locks, HiveConf conf) throws LockException {
            HiveLockMode lockMode = this.getLockMode();
            if (fetchData) {
                for (HiveLockObject.HiveLockObjectData data : this.datas.values()) {
                    HiveLockObject lock = EmbeddedLockManager.this.verify(verify, paths, data, conf);
                    if (lock == null) continue;
                    locks.add(new SimpleHiveLock(lock, lockMode));
                }
            } else {
                HiveLockObject lock = EmbeddedLockManager.this.verify(verify, paths, null, conf);
                if (lock != null) {
                    locks.add(new SimpleHiveLock(lock, lockMode));
                }
            }
        }

        private HiveLockMode getLockMode() {
            return this.exclusive ? HiveLockMode.EXCLUSIVE : HiveLockMode.SHARED;
        }

        private boolean hasLock() {
            return this.datas != null && !this.datas.isEmpty();
        }

        private boolean hasChild() {
            return this.children != null && !this.children.isEmpty();
        }
    }
}

