/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContext;

public class MetricsQueryLifeTimeHook
implements QueryLifeTimeHook {
    private Metrics metrics = MetricsFactory.getInstance();
    private MetricsScope compilingQryScp;
    private MetricsScope executingQryScp;

    @Override
    public void beforeCompile(QueryLifeTimeHookContext ctx) {
        if (this.metrics != null) {
            this.compilingQryScp = this.metrics.createScope("hs2_compiling_queries");
        }
    }

    @Override
    public void afterCompile(QueryLifeTimeHookContext ctx, boolean hasError) {
        if (this.metrics != null && this.compilingQryScp != null) {
            this.metrics.endScope(this.compilingQryScp);
        }
    }

    @Override
    public void beforeExecution(QueryLifeTimeHookContext ctx) {
        if (this.metrics != null) {
            this.executingQryScp = this.metrics.createScope("hs2_executing_queries");
        }
    }

    @Override
    public void afterExecution(QueryLifeTimeHookContext ctx, boolean hasError) {
        if (this.metrics != null && this.executingQryScp != null) {
            this.metrics.endScope(this.executingQryScp);
        }
    }
}

