/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class LocalDirsForExecutors
extends BlockTransferMessage {
    private final String[] execIds;
    private final int[] numLocalDirsByExec;
    private final String[] allLocalDirs;

    public LocalDirsForExecutors(Map<String, String[]> localDirsByExec) {
        this.execIds = new String[localDirsByExec.size()];
        this.numLocalDirsByExec = new int[localDirsByExec.size()];
        ArrayList localDirs = new ArrayList();
        int index = 0;
        for (Map.Entry<String, String[]> e : localDirsByExec.entrySet()) {
            this.execIds[index] = e.getKey();
            this.numLocalDirsByExec[index] = e.getValue().length;
            Collections.addAll(localDirs, (Object[])e.getValue());
            ++index;
        }
        this.allLocalDirs = localDirs.toArray(new String[0]);
    }

    private LocalDirsForExecutors(String[] execIds, int[] numLocalDirsByExec, String[] allLocalDirs) {
        this.execIds = execIds;
        this.numLocalDirsByExec = numLocalDirsByExec;
        this.allLocalDirs = allLocalDirs;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.LOCAL_DIRS_FOR_EXECUTORS;
    }

    public int hashCode() {
        return Arrays.hashCode(this.execIds);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("execIds", (Object)Arrays.toString(this.execIds)).append("numLocalDirsByExec", (Object)Arrays.toString(this.numLocalDirsByExec)).append("allLocalDirs", (Object)Arrays.toString(this.allLocalDirs)).toString();
    }

    public boolean equals(Object other) {
        if (other instanceof LocalDirsForExecutors) {
            LocalDirsForExecutors o = (LocalDirsForExecutors)other;
            return Arrays.equals(this.execIds, o.execIds) && Arrays.equals(this.numLocalDirsByExec, o.numLocalDirsByExec) && Arrays.equals(this.allLocalDirs, o.allLocalDirs);
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.StringArrays.encodedLength((String[])this.execIds) + Encoders.IntArrays.encodedLength((int[])this.numLocalDirsByExec) + Encoders.StringArrays.encodedLength((String[])this.allLocalDirs);
    }

    public void encode(ByteBuf buf) {
        Encoders.StringArrays.encode((ByteBuf)buf, (String[])this.execIds);
        Encoders.IntArrays.encode((ByteBuf)buf, (int[])this.numLocalDirsByExec);
        Encoders.StringArrays.encode((ByteBuf)buf, (String[])this.allLocalDirs);
    }

    public static LocalDirsForExecutors decode(ByteBuf buf) {
        String[] execIds = Encoders.StringArrays.decode((ByteBuf)buf);
        int[] numLocalDirsByExec = Encoders.IntArrays.decode((ByteBuf)buf);
        String[] allLocalDirs = Encoders.StringArrays.decode((ByteBuf)buf);
        return new LocalDirsForExecutors(execIds, numLocalDirsByExec, allLocalDirs);
    }

    public Map<String, String[]> getLocalDirsByExec() {
        HashMap<String, String[]> localDirsByExec = new HashMap<String, String[]>();
        int index = 0;
        int localDirsIndex = 0;
        for (int length : this.numLocalDirsByExec) {
            localDirsByExec.put(this.execIds[index], Arrays.copyOfRange(this.allLocalDirs, localDirsIndex, localDirsIndex + length));
            localDirsIndex += length;
            ++index;
        }
        return localDirsByExec;
    }
}

