/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.monitoring.MonitoringClient;
import com.google.crypto.tink.monitoring.MonitoringKeysetInfo;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class HybridDecryptWrapper
implements PrimitiveWrapper<HybridDecrypt, HybridDecrypt> {
    private static final Logger logger = Logger.getLogger(HybridDecryptWrapper.class.getName());
    private static final HybridDecryptWrapper WRAPPER = new HybridDecryptWrapper();

    HybridDecryptWrapper() {
    }

    @Override
    public HybridDecrypt wrap(PrimitiveSet<HybridDecrypt> primitives) {
        return new WrappedHybridDecrypt(primitives);
    }

    @Override
    public Class<HybridDecrypt> getPrimitiveClass() {
        return HybridDecrypt.class;
    }

    @Override
    public Class<HybridDecrypt> getInputPrimitiveClass() {
        return HybridDecrypt.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(WRAPPER);
    }

    private static class WrappedHybridDecrypt
    implements HybridDecrypt {
        private final PrimitiveSet<HybridDecrypt> primitives;
        private final MonitoringClient.Logger decLogger;

        public WrappedHybridDecrypt(PrimitiveSet<HybridDecrypt> primitives) {
            this.primitives = primitives;
            if (primitives.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(primitives);
                this.decLogger = client.createLogger(keysetInfo, "hybrid_decrypt", "decrypt");
            } else {
                this.decLogger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public byte[] decrypt(byte[] ciphertext, byte[] contextInfo) throws GeneralSecurityException {
            if (ciphertext.length > 5) {
                byte[] prefix = Arrays.copyOfRange(ciphertext, 0, 5);
                byte[] ciphertextNoPrefix = Arrays.copyOfRange(ciphertext, 5, ciphertext.length);
                List<PrimitiveSet.Entry<HybridDecrypt>> entries = this.primitives.getPrimitive(prefix);
                for (PrimitiveSet.Entry<HybridDecrypt> entry : entries) {
                    try {
                        byte[] output = entry.getPrimitive().decrypt(ciphertextNoPrefix, contextInfo);
                        this.decLogger.log(entry.getKeyId(), ciphertextNoPrefix.length);
                        return output;
                    }
                    catch (GeneralSecurityException e) {
                        logger.info("ciphertext prefix matches a key, but cannot decrypt: " + e.toString());
                    }
                }
            }
            List<PrimitiveSet.Entry<HybridDecrypt>> entries = this.primitives.getRawPrimitives();
            for (PrimitiveSet.Entry<HybridDecrypt> entry : entries) {
                try {
                    byte[] output = entry.getPrimitive().decrypt(ciphertext, contextInfo);
                    this.decLogger.log(entry.getKeyId(), ciphertext.length);
                    return output;
                }
                catch (GeneralSecurityException e) {
                }
            }
            this.decLogger.logFailure();
            throw new GeneralSecurityException("decryption failed");
        }
    }
}

