/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.clustering.LDA;
import org.apache.spark.ml.clustering.LDAModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;

public final class LDAExample$ {
    public static LDAExample$ MODULE$;

    static {
        new LDAExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName(String.valueOf(this.getClass().getSimpleName())).getOrCreate();
        Dataset dataset = spark.read().format("libsvm").load("data/mllib/sample_lda_libsvm_data.txt");
        LDA lda = new LDA().setK(10).setMaxIter(10);
        LDAModel model = lda.fit(dataset);
        double ll = model.logLikelihood(dataset);
        double lp = model.logPerplexity(dataset);
        Predef$.MODULE$.println((Object)new StringBuilder(60).append("The lower bound on the log likelihood of the entire corpus: ").append(ll).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(31).append("The upper bound on perplexity: ").append(lp).toString());
        Dataset topics = model.describeTopics(3);
        Predef$.MODULE$.println((Object)"The topics described by their top-weighted terms:");
        topics.show(false);
        Dataset transformed = model.transform(dataset);
        transformed.show(false);
        spark.stop();
    }

    private LDAExample$() {
        MODULE$ = this;
    }
}

