/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.innate.io.SafelyClosable;
import org.glassfish.jersey.internal.RuntimeDelegateDecorator;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.GuardianStringKeyMultivaluedMap;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.io.spi.FlushedCloseable;
import org.glassfish.jersey.message.internal.AcceptableLanguageTag;
import org.glassfish.jersey.message.internal.AcceptableMediaType;
import org.glassfish.jersey.message.internal.CommittingOutputStream;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.LanguageTag;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.MessageHeaderMethods;

public class OutboundMessageContext
extends MessageHeaderMethods
implements SafelyClosable {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final List<MediaType> WILDCARD_ACCEPTABLE_TYPE_SINGLETON_LIST = Collections.singletonList(MediaTypes.WILDCARD_ACCEPTABLE_TYPE);
    private final GuardianStringKeyMultivaluedMap<Object> headers;
    private final CommittingOutputStream committingOutputStream;
    private Configuration configuration;
    private LazyValue<MediaType> mediaTypeCache;
    private Object entity;
    private GenericType<?> entityType;
    private Annotation[] entityAnnotations = EMPTY_ANNOTATIONS;
    private OutputStream entityStream;

    public OutboundMessageContext(Configuration configuration) {
        super(configuration);
        this.configuration = configuration;
        this.headers = new GuardianStringKeyMultivaluedMap<Object>((MultivaluedMap<String, Object>)HeaderUtils.createOutbound());
        this.committingOutputStream = new CommittingOutputStream();
        this.entityStream = this.committingOutputStream;
        this.mediaTypeCache = this.mediaTypeCache();
        this.headers.setGuard("Content-Type");
    }

    public OutboundMessageContext(OutboundMessageContext original) {
        super(original);
        this.headers = new GuardianStringKeyMultivaluedMap<Object>((MultivaluedMap<String, Object>)HeaderUtils.createOutbound());
        this.headers.setGuard("Content-Type");
        this.headers.putAll((Map<String, List<Object>>)((Object)original.headers));
        this.committingOutputStream = new CommittingOutputStream();
        this.entityStream = this.committingOutputStream;
        this.entity = original.entity;
        this.entityType = original.entityType;
        this.entityAnnotations = original.entityAnnotations;
        this.configuration = original.configuration;
        this.mediaTypeCache = this.mediaTypeCache();
    }

    @Deprecated
    public OutboundMessageContext() {
        this((Configuration)null);
    }

    public void replaceHeaders(MultivaluedMap<String, Object> headers) {
        this.getHeaders().clear();
        if (headers != null) {
            this.getHeaders().putAll(headers);
        }
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return HeaderUtils.asStringHeaders(this.headers, this.runtimeDelegateDecorator);
    }

    @Override
    public String getHeaderString(String name) {
        return HeaderUtils.asHeaderString((List<Object>)this.headers.get(name), this.runtimeDelegateDecorator);
    }

    @Override
    public HeaderValueException.Context getHeaderValueExceptionContext() {
        return HeaderValueException.Context.OUTBOUND;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    public MediaType getMediaType() {
        if (this.headers.isObservedAndReset("Content-Type") && this.mediaTypeCache.isInitialized()) {
            this.mediaTypeCache = this.mediaTypeCache();
        }
        return (MediaType)this.mediaTypeCache.get();
    }

    private LazyValue<MediaType> mediaTypeCache() {
        return Values.lazy(() -> this.singleHeader("Content-Type", MediaType.class, arg_0 -> ((RuntimeDelegate.HeaderDelegate)RuntimeDelegateDecorator.configured(this.configuration).createHeaderDelegate(MediaType.class)).fromString(arg_0), false));
    }

    public List<MediaType> getAcceptableMediaTypes() {
        Object values = this.headers.get("Accept");
        if (values == null || values.isEmpty()) {
            return WILDCARD_ACCEPTABLE_TYPE_SINGLETON_LIST;
        }
        ArrayList<AcceptableMediaType> result = new ArrayList<AcceptableMediaType>(values.size());
        boolean conversionApplied = false;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            try {
                if (value instanceof MediaType) {
                    AcceptableMediaType _value = AcceptableMediaType.valueOf((MediaType)value);
                    conversionApplied = _value != value;
                    result.add(_value);
                    continue;
                }
                conversionApplied = true;
                result.addAll(HttpHeaderReader.readAcceptMediaType(HeaderUtils.asString(value, this.runtimeDelegateDecorator)));
            }
            catch (ParseException e) {
                throw this.exception("Accept", value, e);
            }
        }
        if (conversionApplied) {
            this.headers.put("Accept", result.stream().map(mediaType -> mediaType).collect(Collectors.toList()));
        }
        return Collections.unmodifiableList(result);
    }

    public List<Locale> getAcceptableLanguages() {
        Object values = this.headers.get("Accept-Language");
        if (values == null || values.isEmpty()) {
            return Collections.singletonList(new AcceptableLanguageTag("*", null).getAsLocale());
        }
        ArrayList<Locale> result = new ArrayList<Locale>(values.size());
        boolean conversionApplied = false;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof Locale) {
                result.add((Locale)value);
                continue;
            }
            conversionApplied = true;
            try {
                result.addAll(HttpHeaderReader.readAcceptLanguage(HeaderUtils.asString(value, this.runtimeDelegateDecorator)).stream().map(LanguageTag::getAsLocale).collect(Collectors.toList()));
            }
            catch (ParseException e) {
                throw this.exception("Accept-Language", value, e);
            }
        }
        if (conversionApplied) {
            this.headers.put("Accept-Language", result.stream().map(locale -> locale).collect(Collectors.toList()));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Set<Link> getLinks() {
        Object values = this.headers.get("Link");
        if (values == null || values.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Link> result = new HashSet<Link>(values.size());
        boolean conversionApplied = false;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof Link) {
                result.add((Link)value);
                continue;
            }
            conversionApplied = true;
            try {
                result.add(Link.valueOf((String)HeaderUtils.asString(value, this.runtimeDelegateDecorator)));
            }
            catch (IllegalArgumentException e) {
                throw this.exception("Link", value, e);
            }
        }
        if (conversionApplied) {
            this.headers.put("Link", result.stream().map(link -> link).collect(Collectors.toList()));
        }
        return Collections.unmodifiableSet(result);
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.setEntity(entity, ReflectionHelper.genericTypeFor(entity));
    }

    public void setEntity(Object entity, Annotation[] annotations) {
        this.setEntity(entity, ReflectionHelper.genericTypeFor(entity));
        this.setEntityAnnotations(annotations);
    }

    private void setEntity(Object entity, GenericType<?> type) {
        this.entity = entity instanceof GenericEntity ? ((GenericEntity)entity).getEntity() : entity;
        this.entityType = type;
    }

    public void setEntity(Object entity, Type type, Annotation[] annotations) {
        this.setEntity(entity, new GenericType(type));
        this.setEntityAnnotations(annotations);
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.setEntity(entity, annotations);
        this.setMediaType(mediaType);
    }

    public void setMediaType(MediaType mediaType) {
        this.headers.putSingle("Content-Type", (Object)mediaType);
    }

    public Class<?> getEntityClass() {
        return this.entityType == null ? null : this.entityType.getRawType();
    }

    public Type getEntityType() {
        return this.entityType == null ? null : this.entityType.getType();
    }

    public void setEntityType(Type type) {
        this.entityType = new GenericType(type);
    }

    public Annotation[] getEntityAnnotations() {
        return (Annotation[])this.entityAnnotations.clone();
    }

    public void setEntityAnnotations(Annotation[] annotations) {
        this.entityAnnotations = annotations == null ? EMPTY_ANNOTATIONS : annotations;
    }

    public OutputStream getEntityStream() {
        return this.entityStream;
    }

    public void setEntityStream(OutputStream outputStream) {
        this.entityStream = outputStream;
    }

    public void enableBuffering(Configuration configuration) {
        Integer bufferSize = CommonProperties.getValue(configuration.getProperties(), configuration.getRuntimeType(), "jersey.config.contentLength.buffer", Integer.class);
        if (bufferSize != null) {
            this.committingOutputStream.enableBuffering(bufferSize);
        } else {
            this.committingOutputStream.enableBuffering();
        }
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.committingOutputStream.setStreamProvider(streamProvider);
    }

    public void commitStream() throws IOException {
        if (!this.committingOutputStream.isCommitted()) {
            this.entityStream.flush();
            if (!this.committingOutputStream.isCommitted()) {
                this.committingOutputStream.commit();
                this.committingOutputStream.flush();
            }
        }
    }

    public boolean isCommitted() {
        return this.committingOutputStream.isCommitted();
    }

    @Override
    public void close() {
        if (this.hasEntity()) {
            try {
                OutputStream es = this.getEntityStream();
                if (!FlushedCloseable.class.isInstance(es)) {
                    es.flush();
                }
                es.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                if (!this.committingOutputStream.isClosed()) {
                    try {
                        this.committingOutputStream.close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
        }
    }

    void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.runtimeDelegateDecorator = RuntimeDelegateDecorator.configured(configuration);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static interface StreamProvider {
        public OutputStream getOutputStream(int var1) throws IOException;
    }
}

