/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.CosineSimilarity;
import org.apache.spark.examples.mllib.CosineSimilarity$;
import org.apache.spark.examples.mllib.CosineSimilarity$Params$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scopt.OptionParser;
import scopt.Read$;

public final class CosineSimilarity$ {
    public static final CosineSimilarity$ MODULE$ = new CosineSimilarity$();

    public void main(String[] args) {
        CosineSimilarity.Params defaultParams = new CosineSimilarity.Params(CosineSimilarity$Params$.MODULE$.apply$default$1(), CosineSimilarity$Params$.MODULE$.apply$default$2());
        OptionParser<CosineSimilarity.Params> parser = new OptionParser<CosineSimilarity.Params>(){

            public static final /* synthetic */ CosineSimilarity.Params $anonfun$new$1(double x, CosineSimilarity.Params c) {
                double x$1 = x;
                String x$2 = c.copy$default$1();
                return c.copy(x$2, x$1);
            }
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CosineSimilarity: an example app."}));
                this.opt("threshold", Read$.MODULE$.doubleRead()).required().text("threshold similarity: to tradeoff computation vs quality estimate").action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToDouble((Object)x), c));
                this.arg("<inputFile>", Read$.MODULE$.stringRead()).required().text("input file, one row per line, space-separated").action((Function2 & Serializable)(x, c) -> c.copy((String)x, c.copy$default$2()));
                this.note(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |For example, the following command runs this app on a dataset:\n          |\n          | ./bin/spark-submit  --class org.apache.spark.examples.mllib.CosineSimilarity \\\n          | examplesjar.jar \\\n          | --threshold 0.1 data/mllib/sample_svm_data.txt\n        ")));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.CosineSimilarity$Params ), $anonfun$new$2(java.lang.String org.apache.spark.examples.mllib.CosineSimilarity$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        CosineSimilarity.Params params = (CosineSimilarity.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(CosineSimilarity.Params params) {
        SparkConf conf = new SparkConf().setAppName("CosineSimilarity");
        SparkContext sc = new SparkContext(conf);
        RDD rows = sc.textFile(params.inputFile(), sc.textFile$default$2()).map((Function1 & Serializable)line -> {
            double[] values = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(line), ' ')), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$1))), (ClassTag)ClassTag$.MODULE$.Double());
            return Vectors$.MODULE$.dense(values);
        }, ClassTag$.MODULE$.apply(Vector.class)).cache();
        RowMatrix mat = new RowMatrix(rows);
        CoordinateMatrix exact = mat.columnSimilarities();
        CoordinateMatrix approx = mat.columnSimilarities(params.threshold());
        RDD exactEntries = exact.entries().map((Function1 & Serializable)x0$1 -> {
            MatrixEntry matrixEntry = x0$1;
            if (matrixEntry == null) {
                throw new MatchError((Object)matrixEntry);
            }
            long i = matrixEntry.i();
            long j = matrixEntry.j();
            double u = matrixEntry.value();
            Tuple2 tuple2 = new Tuple2((Object)new Tuple2.mcJJ.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)u));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD approxEntries = approx.entries().map((Function1 & Serializable)x0$2 -> {
            MatrixEntry matrixEntry = x0$2;
            if (matrixEntry == null) {
                throw new MatchError((Object)matrixEntry);
            }
            long i = matrixEntry.i();
            long j = matrixEntry.j();
            double v = matrixEntry.value();
            Tuple2 tuple2 = new Tuple2((Object)new Tuple2.mcJJ.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)v));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double MAE = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(exactEntries, ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).leftOuterJoin(approxEntries), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).values().map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToDouble((double)CosineSimilarity$.$anonfun$run$5(x0$3)), (ClassTag)ClassTag$.MODULE$.Double())).mean();
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Average absolute error in estimate is: ").append(MAE).toString());
        sc.stop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ double $anonfun$run$5(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            double u = tuple2._1$mcD$sp();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                double v = BoxesRunTime.unboxToDouble((Object)some.value());
                return package$.MODULE$.abs(u - v);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        double u = tuple2._1$mcD$sp();
        Option option = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        return package$.MODULE$.abs(u);
    }

    private CosineSimilarity$() {
    }
}

