/*
 * Decompiled with CFR 0.152.
 */
package com.google.flatbuffers;

import com.google.flatbuffers.ReadWriteBuf;
import com.google.flatbuffers.Utf8Safe;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferReadWriteBuf
implements ReadWriteBuf {
    private final ByteBuffer buffer;

    public ByteBufferReadWriteBuf(ByteBuffer bb) {
        this.buffer = bb;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public boolean getBoolean(int index) {
        return this.get(index) != 0;
    }

    @Override
    public byte get(int index) {
        return this.buffer.get(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    @Override
    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    @Override
    public String getString(int start, int size) {
        return Utf8Safe.decodeUtf8Buffer(this.buffer, start, size);
    }

    @Override
    public byte[] data() {
        return this.buffer.array();
    }

    @Override
    public void putBoolean(boolean value) {
        this.buffer.put(value ? (byte)1 : 0);
    }

    @Override
    public void put(byte[] value, int start, int length) {
        this.buffer.put(value, start, length);
    }

    @Override
    public void put(byte value) {
        this.buffer.put(value);
    }

    @Override
    public void putShort(short value) {
        this.buffer.putShort(value);
    }

    @Override
    public void putInt(int value) {
        this.buffer.putInt(value);
    }

    @Override
    public void putLong(long value) {
        this.buffer.putLong(value);
    }

    @Override
    public void putFloat(float value) {
        this.buffer.putFloat(value);
    }

    @Override
    public void putDouble(double value) {
        this.buffer.putDouble(value);
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.set(index, value ? (byte)1 : 0);
    }

    @Override
    public void set(int index, byte value) {
        this.requestCapacity(index + 1);
        this.buffer.put(index, value);
    }

    @Override
    public void set(int index, byte[] value, int start, int length) {
        this.requestCapacity(index + (length - start));
        int curPos = this.buffer.position();
        this.buffer.position(index);
        this.buffer.put(value, start, length);
        this.buffer.position(curPos);
    }

    @Override
    public void setShort(int index, short value) {
        this.requestCapacity(index + 2);
        this.buffer.putShort(index, value);
    }

    @Override
    public void setInt(int index, int value) {
        this.requestCapacity(index + 4);
        this.buffer.putInt(index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.requestCapacity(index + 8);
        this.buffer.putLong(index, value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.requestCapacity(index + 4);
        this.buffer.putFloat(index, value);
    }

    @Override
    public void setDouble(int index, double value) {
        this.requestCapacity(index + 8);
        this.buffer.putDouble(index, value);
    }

    @Override
    public int writePosition() {
        return this.buffer.position();
    }

    @Override
    public int limit() {
        return this.buffer.limit();
    }

    @Override
    public boolean requestCapacity(int capacity) {
        return capacity <= this.buffer.limit();
    }
}

