/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;

public final class RocksDBStateEncoder$ {
    public static final RocksDBStateEncoder$ MODULE$ = new RocksDBStateEncoder$();

    public RocksDBStateEncoder getEncoder(StructType keySchema, StructType valueSchema, int numColsPrefixKey) {
        return numColsPrefixKey > 0 ? new PrefixKeyScanStateEncoder(keySchema, valueSchema, numColsPrefixKey) : new NoPrefixKeyStateEncoder(keySchema, valueSchema);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encodeUnsafeRow(UnsafeRow row) {
        void var3_3;
        byte[] bytesToEncode = row.getBytes();
        byte[] encodedBytes = new byte[bytesToEncode.length + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()];
        Platform.putByte((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (byte)RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_VERSION());
        Platform.copyMemory((Object)bytesToEncode, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()), (long)bytesToEncode.length);
        return var3_3;
    }

    public UnsafeRow decodeToUnsafeRow(byte[] bytes, int numFields) {
        UnsafeRow unsafeRow;
        if (bytes != null) {
            UnsafeRow row = new UnsafeRow(numFields);
            unsafeRow = this.decodeToUnsafeRow(bytes, row);
        } else {
            unsafeRow = null;
        }
        return unsafeRow;
    }

    public UnsafeRow decodeToUnsafeRow(byte[] bytes, UnsafeRow reusedRow) {
        UnsafeRow unsafeRow;
        if (bytes != null) {
            reusedRow.pointTo((Object)bytes, (long)(Platform.BYTE_ARRAY_OFFSET + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()), bytes.length - RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES());
            unsafeRow = reusedRow;
        } else {
            unsafeRow = null;
        }
        return unsafeRow;
    }

    private RocksDBStateEncoder$() {
    }
}

