/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.pmml.export;

import java.io.Serializable;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.pmml.export.BinaryClassificationPMMLModelExport;
import org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport;
import org.apache.spark.mllib.pmml.export.KMeansPMMLModelExport;
import org.apache.spark.mllib.pmml.export.PMMLModelExport;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.sparkproject.dmg.pmml.regression.RegressionModel;
import scala.Function0;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class PMMLModelExportFactory$ {
    public static final PMMLModelExportFactory$ MODULE$ = new PMMLModelExportFactory$();

    public PMMLModelExport createPMMLModelExport(Object model) {
        PMMLModelExport pMMLModelExport;
        Object object = model;
        if (object instanceof KMeansModel) {
            KMeansModel kMeansModel = (KMeansModel)object;
            pMMLModelExport = new KMeansPMMLModelExport(kMeansModel);
        } else if (object instanceof LinearRegressionModel) {
            LinearRegressionModel linearRegressionModel = (LinearRegressionModel)object;
            pMMLModelExport = new GeneralizedLinearPMMLModelExport(linearRegressionModel, "linear regression");
        } else if (object instanceof RidgeRegressionModel) {
            RidgeRegressionModel ridgeRegressionModel = (RidgeRegressionModel)object;
            pMMLModelExport = new GeneralizedLinearPMMLModelExport(ridgeRegressionModel, "ridge regression");
        } else if (object instanceof LassoModel) {
            LassoModel lassoModel = (LassoModel)object;
            pMMLModelExport = new GeneralizedLinearPMMLModelExport(lassoModel, "lasso regression");
        } else if (object instanceof SVMModel) {
            SVMModel sVMModel = (SVMModel)object;
            pMMLModelExport = new BinaryClassificationPMMLModelExport(sVMModel, "linear SVM", RegressionModel.NormalizationMethod.NONE, BoxesRunTime.unboxToDouble((Object)sVMModel.getThreshold().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)));
        } else if (object instanceof LogisticRegressionModel) {
            LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)object;
            if (logisticRegressionModel.numClasses() != 2) {
                throw new IllegalArgumentException("PMML Export not supported for Multinomial Logistic Regression");
            }
            pMMLModelExport = new BinaryClassificationPMMLModelExport(logisticRegressionModel, "logistic regression", RegressionModel.NormalizationMethod.LOGIT, BoxesRunTime.unboxToDouble((Object)logisticRegressionModel.getThreshold().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.5)));
        } else {
            throw new IllegalArgumentException(new StringBuilder(37).append("PMML Export not supported for model: ").append(model.getClass().getName()).toString());
        }
        return pMMLModelExport;
    }

    private PMMLModelExportFactory$() {
    }
}

