/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileBase;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n      _FUNC_(col, percentage [, frequency]) - Returns the exact percentile value of numeric\n       or ANSI interval column `col` at the given percentage. The value of percentage must be\n       between 0.0 and 1.0. The value of frequency should be positive integral\n\n      _FUNC_(col, array(percentage1 [, percentage2]...) [, frequency]) - Returns the exact\n      percentile value array of numeric column `col` at the given percentage(s). Each value\n      of the percentage array must be between 0.0 and 1.0. The value of frequency should be\n      positive integral\n\n      ", examples="\n    Examples:\n      > SELECT _FUNC_(col, 0.3) FROM VALUES (0), (10) AS tab(col);\n       3.0\n      > SELECT _FUNC_(col, array(0.25, 0.75)) FROM VALUES (0), (10) AS tab(col);\n       [2.5,7.5]\n      > SELECT _FUNC_(col, 0.5) FROM VALUES (INTERVAL '0' MONTH), (INTERVAL '10' MONTH) AS tab(col);\n       0-5\n      > SELECT _FUNC_(col, array(0.2, 0.5)) FROM VALUES (INTERVAL '0' SECOND), (INTERVAL '10' SECOND) AS tab(col);\n       [0 00:00:02.000000000,0 00:00:05.000000000]\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0005\t}c\u0001B\u001b7\u0001\u0016C\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\tQ\u0002\u0011\t\u0012)A\u0005!\"A\u0011\u000e\u0001BK\u0002\u0013\u0005q\r\u0003\u0005k\u0001\tE\t\u0015!\u0003Q\u0011!Y\u0007A!f\u0001\n\u00039\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011\u0002)\t\u00115\u0004!Q3A\u0005\u00029D\u0001B\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001c\u0005\tg\u0002\u0011)\u001a!C\u0001]\"AA\u000f\u0001B\tB\u0003%q\u000e\u0003\u0005v\u0001\tU\r\u0011\"\u0001w\u0011!Q\bA!E!\u0002\u00139\b\"B>\u0001\t\u0003a\bBB>\u0001\t\u0003\tI\u0001\u0003\u0004|\u0001\u0011\u0005\u0011q\u0002\u0005\u0007w\u0002!\t!!\u0007\t\r\u0005\u0005\u0002\u0001\"\u0011h\u0011\u0019\t\u0019\u0003\u0001C!O\"1\u0011Q\u0005\u0001\u0005B\u001dDq!a\n\u0001\t\u0003\nI\u0003\u0003\u0004\u0002<\u0001!\tE\u001e\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!!\u0014\u0001\t#\ny\u0005C\u0004\u0002^\u0001!\t&a\u0018\t\u0013\u00055\u0004!!A\u0005\u0002\u0005=\u0004\"CA?\u0001E\u0005I\u0011AA@\u0011%\t)\nAI\u0001\n\u0003\ty\bC\u0005\u0002\u0018\u0002\t\n\u0011\"\u0001\u0002\u0000!I\u0011\u0011\u0014\u0001\u0012\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003?\u0003\u0011\u0013!C\u0001\u00037C\u0011\"!)\u0001#\u0003%\t!a)\t\u0013\u0005\u001d\u0006!!A\u0005B\u0005%\u0006\u0002CA]\u0001\u0005\u0005I\u0011\u00018\t\u0013\u0005m\u0006!!A\u0005\u0002\u0005u\u0006\"CAb\u0001\u0005\u0005I\u0011IAc\u0011%\t\t\u000eAA\u0001\n\u0003\t\u0019\u000eC\u0005\u0002X\u0002\t\t\u0011\"\u0011\u0002Z\"I\u0011Q\u001c\u0001\u0002\u0002\u0013\u0005\u0013q\\\u0004\n\u0005\u00071\u0014\u0011!E\u0001\u0005\u000b1\u0001\"\u000e\u001c\u0002\u0002#\u0005!q\u0001\u0005\u0007w&\"\tAa\b\t\u0013\t\u0005\u0012&!A\u0005F\t\r\u0002\"\u0003B\u0013S\u0005\u0005I\u0011\u0011B\u0014\u0011%\u0011)$KI\u0001\n\u0003\tY\nC\u0005\u00038%\n\n\u0011\"\u0001\u0002\u001c\"I!\u0011H\u0015\u0012\u0002\u0013\u0005\u00111\u0015\u0005\n\u0005wI\u0013\u0011!CA\u0005{A\u0011Ba\u0014*#\u0003%\t!a'\t\u0013\tE\u0013&%A\u0005\u0002\u0005m\u0005\"\u0003B*SE\u0005I\u0011AAR\u0011%\u0011)&KA\u0001\n\u0013\u00119F\u0001\u0006QKJ\u001cWM\u001c;jY\u0016T!a\u000e\u001d\u0002\u0013\u0005<wM]3hCR,'BA\u001d;\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005mb\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005ur\u0014aA:rY*\u0011q\bQ\u0001\u0006gB\f'o\u001b\u0006\u0003\u0003\n\u000ba!\u00199bG\",'\"A\"\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u00011%\n\u0016.\u0011\u0005\u001dCU\"\u0001\u001c\n\u0005%3$A\u0004)fe\u000e,g\u000e^5mK\n\u000b7/\u001a\t\u0004\u0017:\u0003V\"\u0001'\u000b\u00055S\u0014!\u0002;sK\u0016\u001c\u0018BA(M\u0005-!VM\u001d8befd\u0015n[3\u0011\u0005E\u0013V\"\u0001\u001d\n\u0005MC$AC#yaJ,7o]5p]B\u0011Q\u000bW\u0007\u0002-*\tq+A\u0003tG\u0006d\u0017-\u0003\u0002Z-\n9\u0001K]8ek\u000e$\bCA.d\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`\t\u00061AH]8pizJ\u0011aV\u0005\u0003EZ\u000bq\u0001]1dW\u0006<W-\u0003\u0002eK\na1+\u001a:jC2L'0\u00192mK*\u0011!MV\u0001\u0006G\"LG\u000eZ\u000b\u0002!\u000611\r[5mI\u0002\nA\u0003]3sG\u0016tG/Y4f\u000bb\u0004(/Z:tS>t\u0017!\u00069fe\u000e,g\u000e^1hK\u0016C\bO]3tg&|g\u000eI\u0001\u0014MJ,\u0017/^3oGf,\u0005\u0010\u001d:fgNLwN\\\u0001\u0015MJ,\u0017/^3oGf,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR,\u0012a\u001c\t\u0003+BL!!\u001d,\u0003\u0007%sG/A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%A\u0004sKZ,'o]3\u0016\u0003]\u0004\"!\u0016=\n\u0005e4&a\u0002\"p_2,\u0017M\\\u0001\te\u00164XM]:fA\u00051A(\u001b8jiz\"2\" @\u0000\u0003\u0003\t\u0019!!\u0002\u0002\bA\u0011q\t\u0001\u0005\u0006M6\u0001\r\u0001\u0015\u0005\u0006S6\u0001\r\u0001\u0015\u0005\u0006W6\u0001\r\u0001\u0015\u0005\b[6\u0001\n\u00111\u0001p\u0011\u001d\u0019X\u0002%AA\u0002=Dq!^\u0007\u0011\u0002\u0003\u0007q\u000fF\u0003~\u0003\u0017\ti\u0001C\u0003g\u001d\u0001\u0007\u0001\u000bC\u0003j\u001d\u0001\u0007\u0001\u000bF\u0004~\u0003#\t\u0019\"!\u0006\t\u000b\u0019|\u0001\u0019\u0001)\t\u000b%|\u0001\u0019\u0001)\t\r\u0005]q\u00021\u0001Q\u0003%1'/Z9vK:\u001c\u0017\u0010F\u0004~\u00037\ti\"a\b\t\u000b\u0019\u0004\u0002\u0019\u0001)\t\u000b%\u0004\u0002\u0019\u0001)\t\u000bU\u0004\u0002\u0019A<\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003W\u0001B!!\f\u000269!\u0011qFA\u0019!\tif+C\u0002\u00024Y\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001c\u0003s\u0011aa\u0015;sS:<'bAA\u001a-\u0006AA-[:de\u0016$X-A\u000fxSRDg*Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u)\ri\u0018\u0011\t\u0005\u0007\u0003\u00072\u0002\u0019A8\u000239,w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u001co&$\bNT3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\u0007u\fI\u0005\u0003\u0004\u0002L]\u0001\ra\\\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\f!b\u001d;sS:<\u0017I]4t+\t\t\t\u0006E\u0003\\\u0003'\n9&C\u0002\u0002V\u0015\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004+\u0006e\u0013bAA.-\n\u0019\u0011I\\=\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB?\u0002b\u0005\u0015\u0014\u0011\u000e\u0005\u0007\u0003GJ\u0002\u0019\u0001)\u0002\u00119,wOR5sgRDa!a\u001a\u001a\u0001\u0004\u0001\u0016!\u00038foN+7m\u001c8e\u0011\u0019\tY'\u0007a\u0001!\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLH#D?\u0002r\u0005M\u0014QOA<\u0003s\nY\bC\u0004g5A\u0005\t\u0019\u0001)\t\u000f%T\u0002\u0013!a\u0001!\"91N\u0007I\u0001\u0002\u0004\u0001\u0006bB7\u001b!\u0003\u0005\ra\u001c\u0005\bgj\u0001\n\u00111\u0001p\u0011\u001d)(\u0004%AA\u0002]\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0002*\u001a\u0001+a!,\u0005\u0005\u0015\u0005\u0003BAD\u0003#k!!!#\u000b\t\u0005-\u0015QR\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a$W\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\u000bIIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0014\u0016\u0004_\u0006\r\u0015AD2paf$C-\u001a4bk2$H%N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\t)KK\u0002x\u0003\u0007\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAV!\u0011\ti+a.\u000e\u0005\u0005=&\u0002BAY\u0003g\u000bA\u0001\\1oO*\u0011\u0011QW\u0001\u0005U\u00064\u0018-\u0003\u0003\u00028\u0005=\u0016\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003/\ny\f\u0003\u0005\u0002B\u000e\n\t\u00111\u0001p\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0019\t\u0007\u0003\u0013\fy-a\u0016\u000e\u0005\u0005-'bAAg-\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u00131Z\u0001\tG\u0006tW)];bYR\u0019q/!6\t\u0013\u0005\u0005W%!AA\u0002\u0005]\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a+\u0002\\\"A\u0011\u0011\u0019\u0014\u0002\u0002\u0003\u0007q.\u0001\u0004fcV\fGn\u001d\u000b\u0004o\u0006\u0005\b\"CAaO\u0005\u0005\t\u0019AA,QM\u0001\u0011Q]Av\u0003[\f\t0a=\u0002x\u0006e\u0018Q`A\u0000!\r\t\u0016q]\u0005\u0004\u0003SD$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003_\fA1\u0010\u0006!A\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2pY2\u0002\u0003/\u001a:dK:$\u0018mZ3!72\u0002cM]3rk\u0016t7-_/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0015D\u0018m\u0019;!a\u0016\u00148-\u001a8uS2,\u0007E^1mk\u0016\u0004sN\u001a\u0011ok6,'/[2\u000bA\u0001\u0002\u0003\u0005\t\u0011!_J\u0004\u0013IT*JA%tG/\u001a:wC2\u00043m\u001c7v[:\u0004\u0003mY8mA\u0002\nG\u000f\t;iK\u0002:\u0017N^3oAA,'oY3oi\u0006<WM\f\u0011UQ\u0016\u0004c/\u00197vK\u0002zg\r\t9fe\u000e,g\u000e^1hK\u0002jWo\u001d;!E\u0016T\u0001\u0005\t\u0011!A\u0001\u0002#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9\u0002C\u000b[3!m\u0006dW/\u001a\u0011pM\u00022'/Z9vK:\u001c\u0017\u0010I:i_VdG\r\t2fAA|7/\u001b;jm\u0016\u0004\u0013N\u001c;fOJ\fGN\u0003\u0006!A\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002XM]2f]R\fw-Z\u0019!72\u0002\u0003/\u001a:dK:$\u0018mZ33;:rc&\u000b\u0011\\Y\u00012'/Z9vK:\u001c\u00170X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!Kb\f7\r\u001e\u0006!A\u0001\u0002\u0003\u0005\t9fe\u000e,g\u000e^5mK\u00022\u0018\r\\;fA\u0005\u0014(/Y=!_\u001a\u0004c.^7fe&\u001c\u0007eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002XM]2f]R\fw-\u001a\u0015tS9\u0002S)Y2iAY\fG.^3\u000bA\u0001\u0002\u0003\u0005\t\u0011pM\u0002\"\b.\u001a\u0011qKJ\u001cWM\u001c;bO\u0016\u0004\u0013M\u001d:bs\u0002jWo\u001d;!E\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9\u0002C\u000b[3!m\u0006dW/\u001a\u0011pM\u00022'/Z9vK:\u001c\u0017\u0010I:i_VdG\r\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!a>\u001c\u0018\u000e^5wK\u0002Jg\u000e^3he\u0006d'B\u0003\u0011!A\u0001\u0002\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t)0ABX\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\u001c\u0017!a9\u001a\u0014\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003\u0006M\u0015-A!\n\u0004'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a/a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7-A\u0005\u0014(/Y=)a9\u0012T\u0007\f\u00111]]*\u0014&\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005\u000b\u0019*Y\u0001B\u0013\u0007M\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\e9*Df\u000e\u00186;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7-AArS'\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K%O)\u0016\u0013f+\u0011'!OA:\u0003%T(O)\"KC\u0006\t\u0015J\u001dR+%KV!MA\u001d\n\u0004g\n\u0011N\u001f:#\u0006*\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019.k)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7-A\u0005\u0014(/Y=)a9\u0012D\u0006\t\u0019/k%J\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013J\u0014+F%Z\u000bE\nI\u00141O\u0001\u001aViQ(O\t&b\u0003\u0005K%O)\u0016\u0013f+\u0011'!OE\u0002t\u0005I*F\u0007>sE)\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.1AA\u0002$\b\r\u0019;aIr\u0003\u0007\r\u00191aA\u0002\u0004\u0007\r\u00171AA\u0002$\b\r\u0019;aUr\u0003\u0007\r\u00191aA\u0002\u0004\u0007M/\u000bA\u0001\nQa\u001a:pkB\f#!a?\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\u0001\u0003\u0015\u0011d&\r\u00181\u0003)\u0001VM]2f]RLG.\u001a\t\u0003\u000f&\u001aR!\u000bB\u0005\u0005+\u00012Ba\u0003\u0003\u0012A\u0003\u0006k\\8x{6\u0011!Q\u0002\u0006\u0004\u0005\u001f1\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005'\u0011iAA\tBEN$(/Y2u\rVt7\r^5p]Z\u0002BAa\u0006\u0003\u001e5\u0011!\u0011\u0004\u0006\u0005\u00057\t\u0019,\u0001\u0002j_&\u0019AM!\u0007\u0015\u0005\t\u0015\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0016!B1qa2LH#D?\u0003*\t-\"Q\u0006B\u0018\u0005c\u0011\u0019\u0004C\u0003gY\u0001\u0007\u0001\u000bC\u0003jY\u0001\u0007\u0001\u000bC\u0003lY\u0001\u0007\u0001\u000bC\u0004nYA\u0005\t\u0019A8\t\u000fMd\u0003\u0013!a\u0001_\"9Q\u000f\fI\u0001\u0002\u00049\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU\nq\"\u00199qYf$C-\u001a4bk2$HEN\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yDa\u0013\u0011\u000bU\u0013\tE!\u0012\n\u0007\t\rcK\u0001\u0004PaRLwN\u001c\t\n+\n\u001d\u0003\u000b\u0015)p_^L1A!\u0013W\u0005\u0019!V\u000f\u001d7fm!A!Q\n\u0019\u0002\u0002\u0003\u0007Q0A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00053\u0002B!!,\u0003\\%!!QLAX\u0005\u0019y%M[3di\u0002")
public class Percentile
extends PercentileBase
implements TernaryLike<Expression>,
Serializable {
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression frequencyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final boolean reverse;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$6() {
        return Percentile$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return Percentile$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return Percentile$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple6<Expression, Expression, Expression, Object, Object, Object>> unapply(Percentile x$0) {
        return Percentile$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$6() {
        return Percentile$.MODULE$.apply$default$6();
    }

    public static int apply$default$5() {
        return Percentile$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return Percentile$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple6<Expression, Expression, Expression, Object, Object, Object>, Percentile> tupled() {
        return Percentile$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, Function1<Object, Percentile>>>>>> curried() {
        return Percentile$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    @Override
    public Expression frequencyExpression() {
        return this.frequencyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public boolean reverse() {
        return this.reverse;
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.percentageExpression();
    }

    @Override
    public Expression third() {
        return this.frequencyExpression();
    }

    @Override
    public String prettyName() {
        return "percentile";
    }

    @Override
    public boolean discrete() {
        return false;
    }

    @Override
    public Percentile withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        boolean x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6);
    }

    @Override
    public Percentile withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        boolean x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6);
    }

    @Override
    public Iterator<Object> stringArgs() {
        return this.discrete() ? super.stringArgs().$plus$plus((Function0 & Serializable)() -> new Some((Object)BoxesRunTime.boxToBoolean((boolean)this.discrete()))) : super.stringArgs();
    }

    @Override
    public Percentile withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Percentile copy(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset, boolean reverse) {
        return new Percentile(child, percentageExpression, frequencyExpression, mutableAggBufferOffset, inputAggBufferOffset, reverse);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.frequencyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    public boolean copy$default$6() {
        return this.reverse();
    }

    @Override
    public String productPrefix() {
        return "Percentile";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.frequencyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.reverse());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Percentile;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "percentageExpression";
                break;
            }
            case 2: {
                string = "frequencyExpression";
                break;
            }
            case 3: {
                string = "mutableAggBufferOffset";
                break;
            }
            case 4: {
                string = "inputAggBufferOffset";
                break;
            }
            case 5: {
                string = "reverse";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Percentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        Percentile percentile = (Percentile)x$1;
        if (this.mutableAggBufferOffset() != percentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != percentile.inputAggBufferOffset()) return false;
        if (this.reverse() != percentile.reverse()) return false;
        Expression expression = this.child();
        Expression expression2 = percentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = percentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.frequencyExpression();
        Expression expression6 = percentile.frequencyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!percentile.canEqual(this)) return false;
        return true;
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset, boolean reverse) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.frequencyExpression = frequencyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        this.reverse = reverse;
        TernaryLike.$init$(this);
    }

    public Percentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), 0, 0, Percentile$.MODULE$.$lessinit$greater$default$6());
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequency) {
        this(child, percentageExpression, frequency, 0, 0, Percentile$.MODULE$.$lessinit$greater$default$6());
    }

    public Percentile(Expression child, Expression percentageExpression, boolean reverse) {
        Expression x$1 = child;
        Expression x$2 = percentageExpression;
        Literal x$3 = Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L));
        boolean x$4 = reverse;
        int x$5 = Percentile$.MODULE$.$lessinit$greater$default$4();
        int x$6 = Percentile$.MODULE$.$lessinit$greater$default$5();
        this(x$1, x$2, x$3, x$5, x$6, x$4);
    }
}

