/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If Index is 0,\n      Spark will throw an error. If index < 0, accesses elements from the last to the first.\n      The function returns NULL if the index exceeds the length of the array and\n      `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws ArrayIndexOutOfBoundsException\n      for invalid indices.\n\n    _FUNC_(map, key) - Returns value for given key. The function returns NULL if the key is not\n       contained in the map.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5g\u0001B\u00193\u0001~B\u0001b\u001b\u0001\u0003\u0016\u0004%\t\u0001\u001c\u0005\ta\u0002\u0011\t\u0012)A\u0005[\"A\u0011\u000f\u0001BK\u0002\u0013\u0005A\u000e\u0003\u0005s\u0001\tE\t\u0015!\u0003n\u0011!\u0019\bA!f\u0001\n\u0003!\b\u0002C>\u0001\u0005#\u0005\u000b\u0011B;\t\u0011q\u0004!Q3A\u0005\u0002uD\u0011\"a\u0001\u0001\u0005#\u0005\u000b\u0011\u0002@\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011Q\u0001\u0001\u0005\u0002\u0005M\u0001BCA\r\u0001!\u0015\r\u0011\"\u0003\u0002\u001c!I\u0011\u0011\u0007\u0001\t\u0006\u0004%I! \u0005\n\u0003k\u0001\u0001R1A\u0005\nuD!\"!\u000f\u0001\u0011\u000b\u0007I\u0011BA\u001e\u0011)\tY\u0005\u0001EC\u0002\u0013\u0005\u00131\u0004\u0005\b\u0003\u001f\u0002A\u0011IA)\u0011\u001d\ty\u0006\u0001C!\u0003CBq!a\u001c\u0001\t\u0013\t\t\b\u0003\u0004\u0002\u0004\u0002!\t% \u0005\b\u0003\u000b\u0003A\u0011IAD\u0011)\ty\t\u0001EC\u0002\u0013%\u0011\u0011\u0013\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\tI\f\u0001C!\u0003wCq!!4\u0001\t#\ny\rC\u0004\u0002Z\u0002!\t%a7\t\u0013\u0005-\b!!A\u0005\u0002\u00055\b\"CA|\u0001E\u0005I\u0011AA}\u0011%\u0011y\u0001AI\u0001\n\u0003\tI\u0010C\u0005\u0003\u0012\u0001\t\n\u0011\"\u0001\u0003\u0014!I!q\u0003\u0001\u0012\u0002\u0013\u0005!\u0011\u0004\u0005\n\u0005;\u0001\u0011\u0011!C!\u0005?A\u0011Ba\f\u0001\u0003\u0003%\tA!\r\t\u0013\tM\u0002!!A\u0005\u0002\tU\u0002\"\u0003B\u001e\u0001\u0005\u0005I\u0011\tB\u001f\u0011%\u0011Y\u0005AA\u0001\n\u0003\u0011i\u0005C\u0005\u0003R\u0001\t\t\u0011\"\u0011\u0003T!I!q\u000b\u0001\u0002\u0002\u0013\u0005#\u0011L\u0004\n\u0005{\u0012\u0014\u0011!E\u0001\u0005\u007f2\u0001\"\r\u001a\u0002\u0002#\u0005!\u0011\u0011\u0005\b\u0003\u000b9C\u0011\u0001BM\u0011%\u0011YjJA\u0001\n\u000b\u0012i\nC\u0005\u0003 \u001e\n\t\u0011\"!\u0003\"\"I!1V\u0014\u0012\u0002\u0013\u0005!1\u0003\u0005\n\u0005[;\u0013\u0013!C\u0001\u00053A\u0011Ba,(\u0003\u0003%\tI!-\t\u0013\t}v%%A\u0005\u0002\tM\u0001\"\u0003BaOE\u0005I\u0011\u0001B\r\u0011%\u0011\u0019mJA\u0001\n\u0013\u0011)MA\u0005FY\u0016lWM\u001c;Bi*\u00111\u0007N\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00026m\u0005A1-\u0019;bYf\u001cHO\u0003\u00028q\u0005\u00191/\u001d7\u000b\u0005eR\u0014!B:qCJ\\'BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001e\u001c\u0001aE\u0005\u0001\u0001\u0012;%*\u0015+[AB\u0011\u0011IQ\u0007\u0002e%\u00111I\r\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!Q#\n\u0005\u0019\u0013$aD$fi6\u000b\u0007OV1mk\u0016,F/\u001b7\u0011\u0005\u0005C\u0015BA%3\u0005A9U\r^!se\u0006L\u0018\n^3n+RLG\u000e\u0005\u0002L\u001d:\u0011\u0011\tT\u0005\u0003\u001bJ\nq\u0001]1dW\u0006<W-\u0003\u0002P!\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA'3!\t\t%+\u0003\u0002Te\t\u00192+\u001e9q_J$\u0018+^3ss\u000e{g\u000e^3yiB\u0011Q\u000bW\u0007\u0002-*\u0011qKN\u0001\u0007KJ\u0014xN]:\n\u0005e3&aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005msV\"\u0001/\u000b\u0003u\u000bQa]2bY\u0006L!a\u0018/\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011\r\u001b\b\u0003E\u001et!a\u00194\u000e\u0003\u0011T!!\u001a \u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0016BA']\u0013\tI'N\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002N9\u0006!A.\u001a4u+\u0005i\u0007CA!o\u0013\ty'G\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u00063fM\u0006,H\u000e\u001e,bYV,w*\u001e;PM\n{WO\u001c3\u0016\u0003U\u00042a\u0017<y\u0013\t9HL\u0001\u0004PaRLwN\u001c\t\u0003\u0003fL!A\u001f\u001a\u0003\u000f1KG/\u001a:bY\u00069B-\u001a4bk2$h+\u00197vK>+Ho\u00144C_VtG\rI\u0001\fM\u0006LGn\u00148FeJ|'/F\u0001\u007f!\tYv0C\u0002\u0002\u0002q\u0013qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u0001CA!\u0001\u0011\u0015Y\u0017\u00021\u0001n\u0011\u0015\t\u0018\u00021\u0001n\u0011\u001d\u0019\u0018\u0002%AA\u0002UDq\u0001`\u0005\u0011\u0002\u0003\u0007a\u0010\u0006\u0004\u0002\n\u0005U\u0011q\u0003\u0005\u0006W*\u0001\r!\u001c\u0005\u0006c*\u0001\r!\\\u0001\u000b[\u0006\u00048*Z=UsB,WCAA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012m\u0005)A/\u001f9fg&!\u0011qEA\u0011\u0005!!\u0015\r^1UsB,\u0007fA\u0006\u0002,A\u00191,!\f\n\u0007\u0005=BLA\u0005ue\u0006t7/[3oi\u0006!R.\u00199WC2,XmQ8oi\u0006Lgn\u001d(vY2D3\u0001DA\u0016\u0003Q\t'O]1z\u000b2,W.\u001a8u\u001dVdG.\u00192mK\"\u001aQ\"a\u000b\u0002\u0011=\u0014H-\u001a:j]\u001e,\"!!\u0010\u0011\u000b\u0005\fy$a\u0011\n\u0007\u0005\u0005#N\u0001\u0005Pe\u0012,'/\u001b8h!\rY\u0016QI\u0005\u0004\u0003\u000fb&aA!os\"\u001aa\"a\u000b\u0002\u0011\u0011\fG/\u0019+za\u0016D3aDA\u0016\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003'\u0002R!YA+\u00033J1!a\u0016k\u0005\r\u0019V-\u001d\t\u0005\u0003?\tY&\u0003\u0003\u0002^\u0005\u0005\"\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\u0019\u0007\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tI\u0007N\u0001\tC:\fG._:jg&!\u0011QNA4\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018a\u00038vY2\f'-\u001b7jif$RA`A:\u0003sBq!!\u001e\u0013\u0001\u0004\t9(\u0001\u0005fY\u0016lWM\u001c;t!\u0011\t\u0017QK7\t\u000f\u0005m$\u00031\u0001\u0002~\u00059qN\u001d3j]\u0006d\u0007cA.\u0002\u0000%\u0019\u0011\u0011\u0011/\u0003\u0007%sG/\u0001\u0005ok2d\u0017M\u00197f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\t\u0019%!#\u0002\u000e\"9\u00111\u0012\u000bA\u0002\u0005\r\u0013!\u0002<bYV,\u0007bBA>)\u0001\u0007\u00111I\u0001\fI>,E.Z7f]R\fE/\u0006\u0002\u0002\u0014BI1,!&\u0002D\u0005\r\u00131I\u0005\u0004\u0003/c&!\u0003$v]\u000e$\u0018n\u001c83Q\r)\u00121F\u0001\nI><UM\\\"pI\u0016$b!a(\u0002,\u0006U\u0006\u0003BAQ\u0003Ok!!a)\u000b\u0007\u0005\u0015&'A\u0004d_\u0012,w-\u001a8\n\t\u0005%\u00161\u0015\u0002\t\u000bb\u0004(oQ8eK\"9\u0011Q\u0016\fA\u0002\u0005=\u0016aA2uqB!\u0011\u0011UAY\u0013\u0011\t\u0019,a)\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011q\u0017\fA\u0002\u0005}\u0015AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003{\u0003B!a0\u0002H:!\u0011\u0011YAb!\t\u0019G,C\u0002\u0002Fr\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAe\u0003\u0017\u0014aa\u0015;sS:<'bAAc9\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0007\u0003\u0013\t\t.!6\t\r\u0005M\u0007\u00041\u0001n\u0003\u001dqWm\u001e'fMRDa!a6\u0019\u0001\u0004i\u0017\u0001\u00038foJKw\r\u001b;\u0002!%t\u0017\u000e^)vKJL8i\u001c8uKb$HCAAo!\u0011Yf/a8\u0011\t\u0005\u0005\u0018q]\u0007\u0003\u0003GT1!!:5\u0003\u0015!(/Z3t\u0013\u0011\tI/a9\u0003\u001fM\u000bF*U;fef\u001cuN\u001c;fqR\fAaY8qsRQ\u0011\u0011BAx\u0003c\f\u00190!>\t\u000f-T\u0002\u0013!a\u0001[\"9\u0011O\u0007I\u0001\u0002\u0004i\u0007bB:\u001b!\u0003\u0005\r!\u001e\u0005\byj\u0001\n\u00111\u0001\u007f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a?+\u00075\fip\u000b\u0002\u0002\u0000B!!\u0011\u0001B\u0006\u001b\t\u0011\u0019A\u0003\u0003\u0003\u0006\t\u001d\u0011!C;oG\",7m[3e\u0015\r\u0011I\u0001X\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0007\u0005\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0016)\u001aQ/!@\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u0004\u0016\u0004}\u0006u\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\"A!!1\u0005B\u0017\u001b\t\u0011)C\u0003\u0003\u0003(\t%\u0012\u0001\u00027b]\u001eT!Aa\u000b\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\u0014)#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002~\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\"\u0005oA\u0011B!\u000f\"\u0003\u0003\u0005\r!! \u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\u0004\u0005\u0004\u0003B\t\u001d\u00131I\u0007\u0003\u0005\u0007R1A!\u0012]\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0013\u0012\u0019E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001@\u0003P!I!\u0011H\u0012\u0002\u0002\u0003\u0007\u00111I\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\"\tU\u0003\"\u0003B\u001dI\u0005\u0005\t\u0019AA?\u0003\u0019)\u0017/^1mgR\u0019aPa\u0017\t\u0013\teR%!AA\u0002\u0005\r\u0003f\u0005\u0001\u0003`\t\u0015$q\rB6\u0005[\u0012\tHa\u001d\u0003x\te\u0004cA!\u0003b%\u0019!1\r\u001a\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!\u0011N\u0001\u0005f)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010\f\u0011j]\u0012,\u00070\u000b\u0011.AI+G/\u001e:og\u0002*G.Z7f]R\u0004sN\u001a\u0011beJ\f\u0017\u0010I1uA\u001dLg/\u001a8!QEj#-Y:fI&\u0002\u0013N\u001c3fq:\u0002\u0013J\u001a\u0011J]\u0012,\u0007\u0010I5tAAb#\u0002\t\u0011!A\u0001\u00023\u000b]1sW\u0002:\u0018\u000e\u001c7!i\"\u0014xn\u001e\u0011b]\u0002*'O]8s]\u0001Je\rI5oI\u0016D\b\u0005\u0010\u00111Y\u0001\n7mY3tg\u0016\u001c\b%\u001a7f[\u0016tGo\u001d\u0011ge>l\u0007\u0005\u001e5fA1\f7\u000f\u001e\u0011u_\u0002\"\b.\u001a\u0011gSJ\u001cHO\f\u0006!A\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t(V\u00192\u0003\u0013N\u001a\u0011uQ\u0016\u0004\u0013N\u001c3fq\u0002*\u0007pY3fIN\u0004C\u000f[3!Y\u0016tw\r\u001e5!_\u001a\u0004C\u000f[3!CJ\u0014\u0018-\u001f\u0011b]\u0012T\u0001\u0005\t\u0011!A\u0001\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\r\u0019\u0011jg\u0002\u001aX\r\u001e\u0011u_\u00022\u0017\r\\:f])\u0001\u0003\u0005\t\u0011!A%3\u0007\u0005Y:qCJ\\gf]9m]\u0005t7/\u001b\u0018f]\u0006\u0014G.\u001a3aA%\u001c\be]3uAQ|\u0007\u0005\u001e:vK2\u0002\u0013\u000e\u001e\u0011uQJ|wo\u001d\u0011BeJ\f\u00170\u00138eKb|U\u000f^(g\u0005>,h\u000eZ:Fq\u000e,\u0007\u000f^5p]*\u0001\u0003\u0005\t\u0011!A\u0019|'\u000fI5om\u0006d\u0017\u000e\u001a\u0011j]\u0012L7-Z:/\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015nCBd\u0003e[3zS\u0001j\u0003EU3ukJt7\u000f\t<bYV,\u0007EZ8sA\u001dLg/\u001a8!W\u0016Lh\u0006\t+iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t(V\u00192\u0003\u0013N\u001a\u0011uQ\u0016\u00043.Z=!SN\u0004cn\u001c;\u000bA\u0001\u0002\u0003\u0005\t\u0011!G>tG/Y5oK\u0012\u0004\u0013N\u001c\u0011uQ\u0016\u0004S.\u00199/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t=\u0014\u0001 \u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a*Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0017\r\u001d\u00152Y\u0001:\u0013m\n\u0017!e1\u0002sEY\u0014*Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011c\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B;\u0003\u0015\u0011d\u0006\u000e\u00181\u0003\u00159'o\\;qC\t\u0011Y(A\u0005nCB|f-\u001e8dg\u0006IQ\t\\3nK:$\u0018\t\u001e\t\u0003\u0003\u001e\u001aRa\nBB\u0005\u001f\u0003\"B!\"\u0003\f6lWO`A\u0005\u001b\t\u00119IC\u0002\u0003\nr\u000bqA];oi&lW-\u0003\u0003\u0003\u000e\n\u001d%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!!\u0011\u0013BL\u001b\t\u0011\u0019J\u0003\u0003\u0003\u0016\n%\u0012AA5p\u0013\rI'1\u0013\u000b\u0003\u0005\u007f\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005C\tQ!\u00199qYf$\"\"!\u0003\u0003$\n\u0015&q\u0015BU\u0011\u0015Y'\u00061\u0001n\u0011\u0015\t(\u00061\u0001n\u0011\u001d\u0019(\u0006%AA\u0002UDq\u0001 \u0016\u0011\u0002\u0003\u0007a0A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005g\u0013Y\f\u0005\u0003\\m\nU\u0006cB.\u000386lWO`\u0005\u0004\u0005sc&A\u0002+va2,G\u0007C\u0005\u0003>6\n\t\u00111\u0001\u0002\n\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u0019\t\u0005\u0005G\u0011I-\u0003\u0003\u0003L\n\u0015\"AB(cU\u0016\u001cG\u000f")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
package.NullIntolerant,
SupportQueryContext,
QueryErrorsBase {
    private transient DataType mapKeyType;
    private transient boolean mapValueContainsNull;
    private transient boolean arrayElementNullable;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private final Option<Literal> defaultValueOutOfBound;
    private final boolean failOnError;
    private Option<SQLQueryContext> queryContext;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$4() {
        return ElementAt$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Literal> $lessinit$greater$default$3() {
        return ElementAt$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<Literal>, Object>> unapply(ElementAt x$0) {
        return ElementAt$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return ElementAt$.MODULE$.apply$default$4();
    }

    public static Option<Literal> apply$default$3() {
        return ElementAt$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<Literal>, Object>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Literal>, Function1<Object, ElementAt>>>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal, boolean failOnError, Function2<Seq<Expression>, Object, Object> nullability) {
        return GetArrayItemUtil.computeNullabilityFromArray$(this, child, ordinal, failOnError, nullability);
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public Option<Literal> defaultValueOutOfBound() {
        return this.defaultValueOutOfBound;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.mapKeyType$lzycompute() : this.mapKeyType;
    }

    private boolean mapValueContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.mapValueContainsNull = ((MapType)this.left().dataType()).valueContainsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.mapValueContainsNull;
    }

    private boolean mapValueContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.mapValueContainsNull$lzycompute() : this.mapValueContainsNull;
    }

    private boolean arrayElementNullable$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.arrayElementNullable = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.arrayElementNullable;
    }

    private boolean arrayElementNullable() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.arrayElementNullable$lzycompute() : this.arrayElementNullable;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{arrayType, IntegerType$.MODULE$}));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                Seq seq;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{new MapType(dt, valueType, hasNull), dt}));
                    return seq;
                } else {
                    seq = (Seq)package$.MODULE$.Seq().empty();
                }
                return seq;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return (Seq)package$.MODULE$.Seq().empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var1_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.right())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
                    return var1_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !DataTypeUtils$.MODULE$.sameType(e2, e12 = (mapType = (MapType)dataType).keyType())) {
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = new TypeCheckResult.DataTypeMismatch("MAP_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)MapType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
                return var1_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.DataTypeMismatch dataTypeMismatch = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.left())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType()))}))));
            return var1_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var1_8;
    }

    private boolean nullability(Seq<Expression> elements, int ordinal) {
        return ordinal == 0 ? false : (elements.length() < scala.math.package$.MODULE$.abs(ordinal) ? !this.failOnError() : (ordinal < 0 ? ((Expression)elements.apply(elements.length() + ordinal)).nullable() : ((Expression)elements.apply(ordinal - 1)).nullable()));
    }

    @Override
    public boolean nullable() {
        boolean bl;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            bl = this.computeNullabilityFromArray(this.left(), this.right(), this.failOnError(), (Function2<Seq<Expression>, Object, Object>)(Function2 & Serializable)(elements, ordinal) -> BoxesRunTime.boxToBoolean((boolean)this.nullability((Seq<Expression>)elements, BoxesRunTime.unboxToInt((Object)ordinal))));
        } else if (dataType instanceof MapType) {
            bl = true;
        } else {
            throw new MatchError((Object)dataType);
        }
        return bl;
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                Function2 & Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable)(value, ordinal) -> {
                        Object object;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < scala.math.package$.MODULE$.abs(index)) {
                            Object object2;
                            if (this.failOnError()) {
                                throw QueryExecutionErrors$.MODULE$.invalidElementAtIndexError(index, array.numElements(), this.getContextOrNull());
                            }
                            Option<Literal> option = this.defaultValueOutOfBound();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Literal value2 = (Literal)some.value();
                                object2 = value2.eval(value2.eval$default$1());
                            } else if (None$.MODULE$.equals(option)) {
                                object2 = null;
                            } else {
                                throw new MatchError(option);
                            }
                            object = object2;
                        } else {
                            if (index == 0) {
                                throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
                            }
                            int idx = index > 0 ? index - 1 : array.numElements() + index;
                            object = this.arrayElementNullable() && array.isNullAt(idx) ? null : array.get(idx, this.dataType());
                        }
                        return object;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> {
                String string;
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayElementNullable() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())) : "";
                String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
                if (this.failOnError()) {
                    string = new StringBuilder(74).append("throw QueryExecutionErrors.invalidElementAtIndexError(").append(index).append(", ").append((String)eval1).append(".numElements(), ").append(errorContext).append(");").toString();
                } else {
                    String string2;
                    Option<Literal> option = this.defaultValueOutOfBound();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Literal value = (Literal)some.value();
                        ExprCode defaultValueEval = value.genCode(ctx);
                        string2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(82).append("\n                  ").append(defaultValueEval.code()).append("\n                  ").append(ev.isNull()).append(" = ").append(defaultValueEval.isNull()).append(";\n                  ").append(ev.value()).append(" = ").append(defaultValueEval.value()).append(";\n                ").toString()));
                    } else if (None$.MODULE$.equals(option)) {
                        string2 = new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
                    } else {
                        throw new MatchError(option);
                    }
                    string = string2;
                }
                String indexOutOfBoundBranch = string;
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(461).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(indexOutOfBoundBranch).append("\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw QueryExecutionErrors.invalidIndexOfZeroError(").append(errorContext).append(");\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString()));
            });
        } else if (dataType instanceof MapType) {
            exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    @Override
    public ElementAt withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        return this.failOnError() && this.left().resolved() && this.left().dataType() instanceof ArrayType ? new Some((Object)this.origin().context()) : None$.MODULE$;
    }

    public ElementAt copy(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        return new ElementAt(left, right, defaultValueOutOfBound, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<Literal> copy$default$3() {
        return this.defaultValueOutOfBound();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = this.defaultValueOutOfBound();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            case 2: {
                string = "defaultValueOutOfBound";
                break;
            }
            case 3: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        if (this.failOnError() != elementAt.failOnError()) return false;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Literal> option = this.defaultValueOutOfBound();
        Option<Literal> option2 = elementAt.defaultValueOutOfBound();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.defaultValueOutOfBound = defaultValueOutOfBound;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
        SupportQueryContext.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public ElementAt(Expression left, Expression right) {
        this(left, right, (Option<Literal>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

