/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hive.common.util.DateParser;

public class VectorUDFDateAddScalarCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private long longValue = 0L;
    private Timestamp timestampValue = null;
    private byte[] stringValue = null;
    protected boolean isPositive = true;
    private final transient DateParser dateParser = new DateParser();
    private final transient Date baseDate = new Date(0L);

    public VectorUDFDateAddScalarCol() {
    }

    public VectorUDFDateAddScalarCol(Object object, int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        if (object instanceof Long) {
            this.longValue = (Long)object;
        } else if (object instanceof Timestamp) {
            this.timestampValue = (Timestamp)object;
        } else if (object instanceof byte[]) {
            this.stringValue = (byte[])object;
        } else {
            throw new RuntimeException("Unexpected scalar object " + object.getClass().getName() + " " + object.toString());
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputCol = (LongColumnVector)batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean selectedInUse = !inputCol.isRepeating && batch.selectedInUse;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        switch (this.inputTypes[0]) {
            case DATE: {
                this.baseDate.setTime(DateWritable.daysToMillis((int)((int)this.longValue)));
                break;
            }
            case TIMESTAMP: {
                this.baseDate.setTime(this.timestampValue.getTime());
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                boolean parsed = this.dateParser.parseDate(new String(this.stringValue, StandardCharsets.UTF_8), this.baseDate);
                if (parsed) break;
                outV.noNulls = false;
                if (selectedInUse) {
                    for (int j = 0; j < n; ++j) {
                        int i = sel[j];
                        outV.isNull[i] = true;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        outV.isNull[i] = true;
                    }
                }
                return;
            }
            default: {
                throw new Error("Unsupported input type " + this.inputTypes[0].name());
            }
        }
        if (batch.size == 0) {
            return;
        }
        outV.isRepeating = inputCol.isRepeating;
        long baseDateDays = DateWritable.millisToDays((long)this.baseDate.getTime());
        if (inputCol.noNulls) {
            outV.noNulls = true;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    this.evaluate(baseDateDays, inputCol.vector[i], outV, i);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.evaluate(baseDateDays, inputCol.vector[i], outV, i);
                }
            }
        } else {
            outV.noNulls = false;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = inputCol.isNull[i];
                    if (inputCol.isNull[i]) continue;
                    this.evaluate(baseDateDays, inputCol.vector[i], outV, i);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outV.isNull[i] = inputCol.isNull[i];
                    if (inputCol.isNull[i]) continue;
                    this.evaluate(baseDateDays, inputCol.vector[i], outV, i);
                }
            }
        }
    }

    private void evaluate(long baseDateDays, long numDays, LongColumnVector output, int i) {
        long result = baseDateDays;
        result = this.isPositive ? (result += numDays) : (result -= numDays);
        output.vector[i] = result;
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "date";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public byte[] getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(byte[] stringValue) {
        this.stringValue = stringValue;
    }

    public boolean isPositive() {
        return this.isPositive;
    }

    public void setPositive(boolean isPositive) {
        this.isPositive = isPositive;
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + this.stringValue + ", col " + this.colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

