/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context.annotation;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;

public class DubboClassPathBeanDefinitionScanner
extends ClassPathBeanDefinitionScanner {
    private final ConcurrentMap<String, Set<BeanDefinition>> beanDefinitionMap = new ConcurrentHashMap<String, Set<BeanDefinition>>();

    public DubboClassPathBeanDefinitionScanner(BeanDefinitionRegistry registry, boolean useDefaultFilters, Environment environment, ResourceLoader resourceLoader) {
        super(registry, useDefaultFilters);
        this.setEnvironment(environment);
        this.setResourceLoader(resourceLoader);
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)registry);
    }

    public DubboClassPathBeanDefinitionScanner(BeanDefinitionRegistry registry, Environment environment, ResourceLoader resourceLoader) {
        this(registry, false, environment, resourceLoader);
    }

    public Set<BeanDefinition> findCandidateComponents(String basePackage) {
        Set beanDefinitions = (Set)this.beanDefinitionMap.get(basePackage);
        if (Objects.isNull(beanDefinitions)) {
            beanDefinitions = super.findCandidateComponents(basePackage);
            this.beanDefinitionMap.put(basePackage, beanDefinitions);
        }
        return beanDefinitions;
    }
}

