/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TransportHistogram
implements JsonpSerializable {
    @Nullable
    private final Long count;
    @Nullable
    private final Long ltMillis;
    @Nullable
    private final Long geMillis;
    public static final JsonpDeserializer<TransportHistogram> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransportHistogram::setupTransportHistogramDeserializer);

    private TransportHistogram(Builder builder) {
        this.count = builder.count;
        this.ltMillis = builder.ltMillis;
        this.geMillis = builder.geMillis;
    }

    public static TransportHistogram of(Function<Builder, ObjectBuilder<TransportHistogram>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Nullable
    public final Long ltMillis() {
        return this.ltMillis;
    }

    @Nullable
    public final Long geMillis() {
        return this.geMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count.longValue());
        }
        if (this.ltMillis != null) {
            generator.writeKey("lt_millis");
            generator.write(this.ltMillis.longValue());
        }
        if (this.geMillis != null) {
            generator.writeKey("ge_millis");
            generator.write(this.geMillis.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTransportHistogramDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::ltMillis, JsonpDeserializer.longDeserializer(), "lt_millis");
        op.add(Builder::geMillis, JsonpDeserializer.longDeserializer(), "ge_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TransportHistogram> {
        @Nullable
        private Long count;
        @Nullable
        private Long ltMillis;
        @Nullable
        private Long geMillis;

        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        public final Builder ltMillis(@Nullable Long value) {
            this.ltMillis = value;
            return this;
        }

        public final Builder geMillis(@Nullable Long value) {
            this.geMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransportHistogram build() {
            this._checkSingleUse();
            return new TransportHistogram(this);
        }
    }
}

