/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.RangePropertyBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DateRangeProperty
extends RangePropertyBase
implements PropertyVariant {
    @Nullable
    private final String format;
    public static final JsonpDeserializer<DateRangeProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateRangeProperty::setupDateRangePropertyDeserializer);

    private DateRangeProperty(Builder builder) {
        super(builder);
        this.format = builder.format;
    }

    public static DateRangeProperty of(Function<Builder, ObjectBuilder<DateRangeProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.DateRange;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "date_range");
        super.serializeInternal(generator, mapper);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
    }

    protected static void setupDateRangePropertyDeserializer(ObjectDeserializer<Builder> op) {
        RangePropertyBase.setupRangePropertyBaseDeserializer(op);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.ignore("type");
    }

    public static class Builder
    extends RangePropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateRangeProperty> {
        @Nullable
        private String format;

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateRangeProperty build() {
            this._checkSingleUse();
            return new DateRangeProperty(this);
        }
    }
}

