/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.util.ManagedValue;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteUrl {
    static Logger LOGGER = LoggerFactory.getLogger(RemoteUrl.class);
    private static final String TRUST_ALL = String.format("%s.trustAll", RemoteUrl.class.getName());
    private static final ConnectionConfigurator CONNECTION_CONFIGURATOR = RemoteUrl.createConnectionConfigurator();
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String ACCEPT_HEADER_VALUE = "application/json, application/yaml, */*";
    private static final String USER_AGENT_HEADER_VALUE = "Apache-HttpClient/Swagger";

    private static ConnectionConfigurator createConnectionConfigurator() {
        if (Boolean.parseBoolean(System.getProperty(TRUST_ALL))) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                final SSLSocketFactory sf = sc.getSocketFactory();
                final HostnameVerifier trustAllNames = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                return new ConnectionConfigurator(){

                    @Override
                    public void process(URLConnection connection) {
                        if (connection instanceof HttpsURLConnection) {
                            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                            httpsConnection.setSSLSocketFactory(sf);
                            httpsConnection.setHostnameVerifier(trustAllNames);
                        }
                    }
                };
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error("Not Supported", (Throwable)e);
            }
            catch (KeyManagementException e) {
                LOGGER.error("Not Supported", (Throwable)e);
            }
        }
        return new ConnectionConfigurator(){

            @Override
            public void process(URLConnection connection) {
            }
        };
    }

    public static String cleanUrl(String url) {
        return url.replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll(" ", "%20");
    }

    public static String urlToString(String url, List<AuthorizationValue> auths) throws Exception {
        InputStream is = null;
        BufferedReader br = null;
        try {
            URLConnection conn;
            do {
                URL inUrl = new URL(RemoteUrl.cleanUrl(url));
                ArrayList<AuthorizationValue> query = new ArrayList<AuthorizationValue>();
                ArrayList<AuthorizationValue> header = new ArrayList<AuthorizationValue>();
                if (auths != null) {
                    for (AuthorizationValue auth : auths) {
                        if (auth.getUrlMatcher() != null && !auth.getUrlMatcher().test(inUrl)) continue;
                        if ("query".equals(auth.getType())) {
                            RemoteUrl.appendValue(inUrl, auth, query);
                            continue;
                        }
                        if (!"header".equals(auth.getType())) continue;
                        RemoteUrl.appendValue(inUrl, auth, header);
                    }
                }
                if (!query.isEmpty()) {
                    URI inUri = inUrl.toURI();
                    StringBuilder newQuery = new StringBuilder(inUri.getQuery() == null ? "" : inUri.getQuery());
                    for (AuthorizationValue item : query) {
                        if (newQuery.length() > 0) {
                            newQuery.append("&");
                        }
                        newQuery.append(URLEncoder.encode(item.getKeyName(), UTF_8.name())).append("=").append(URLEncoder.encode(item.getValue(), UTF_8.name()));
                    }
                    conn = new URI(inUri.getScheme(), inUri.getAuthority(), inUri.getPath(), newQuery.toString(), inUri.getFragment()).toURL().openConnection();
                } else {
                    conn = inUrl.openConnection();
                }
                CONNECTION_CONFIGURATOR.process(conn);
                for (AuthorizationValue item : header) {
                    conn.setRequestProperty(item.getKeyName(), item.getValue());
                }
                conn.setRequestProperty("Accept", ACCEPT_HEADER_VALUE);
                conn.setRequestProperty("User-Agent", USER_AGENT_HEADER_VALUE);
                conn.connect();
                url = ((HttpURLConnection)conn).getHeaderField("Location");
            } while (301 == ((HttpURLConnection)conn).getResponseCode() || 302 == ((HttpURLConnection)conn).getResponseCode() || 307 == ((HttpURLConnection)conn).getResponseCode() || 308 == ((HttpURLConnection)conn).getResponseCode());
            InputStream in = conn.getInputStream();
            StringBuilder contents = new StringBuilder();
            BufferedReader input = new BufferedReader(new InputStreamReader(in, UTF_8));
            int i = 0;
            while (i != -1) {
                char c = (char)i;
                if (!Character.isISOControl(c)) {
                    contents.append((char)i);
                }
                if (c == '\n') {
                    contents.append('\n');
                }
                i = input.read();
            }
            in.close();
            String string = contents.toString();
            return string;
        }
        catch (SSLProtocolException e) {
            LOGGER.warn("there is a problem with the target SSL certificate");
            LOGGER.warn("**** you may want to run with -Djsse.enableSNIExtension=false\n\n");
            LOGGER.error("unable to read", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("unable to read", (Throwable)e);
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    private static void appendValue(URL url, AuthorizationValue value, Collection<AuthorizationValue> to) {
        if (value instanceof ManagedValue && !((ManagedValue)value).process(url)) {
            return;
        }
        to.add(value);
    }

    private static interface ConnectionConfigurator {
        public void process(URLConnection var1);
    }
}

