/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.faultinjection;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.faultinjection.Fault;
import org.apache.servicecomb.faultinjection.FaultExecutor;
import org.apache.servicecomb.faultinjection.FaultInjectionUtil;
import org.apache.servicecomb.faultinjection.FaultParam;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;

public class FaultInjectionHandler
implements Handler {
    private List<Fault> faultInjectionFeatureList = SPIServiceUtils.getSortedService(Fault.class);

    public void setFaultFeature(List<Fault> faultFeature) {
        this.faultInjectionFeatureList = faultFeature;
    }

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        String key = invocation.getTransport().getName() + invocation.getMicroserviceQualifiedName();
        AtomicLong reqCount = FaultInjectionUtil.getOperMetTotalReq(key);
        long reqCountCurrent = reqCount.getAndIncrement();
        FaultParam param = new FaultParam(reqCountCurrent);
        Context currentContext = Vertx.currentContext();
        if (currentContext != null && currentContext.isEventLoopContext()) {
            param.setVertx(currentContext.owner());
        }
        FaultExecutor executor = new FaultExecutor(this.faultInjectionFeatureList, invocation, param);
        executor.execute(response -> {
            try {
                if (response.isFailed()) {
                    asyncResp.complete(response);
                } else {
                    invocation.next(asyncResp);
                }
            }
            catch (Exception e) {
                asyncResp.consumerFail((Throwable)e);
            }
        });
    }
}

