/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.registry.cache;

import java.util.Objects;
import org.apache.servicecomb.registry.definition.MicroserviceNameParser;

public class MicroserviceCacheKey {
    private String env;
    private String appId;
    private String serviceName;
    private String versionRule = "0.0.0.0+";

    public static MicroserviceCacheKeyBuilder builder() {
        return new MicroserviceCacheKeyBuilder();
    }

    MicroserviceCacheKey() {
    }

    public void validate() {
        Objects.requireNonNull(this.env, "microserviceCacheKey.env is null");
        Objects.requireNonNull(this.appId, "microserviceCacheKey.appId is null");
        Objects.requireNonNull(this.serviceName, "microserviceCacheKey.serviceName is null");
        Objects.requireNonNull(this.versionRule, "microserviceCacheKey.versionRule is null");
    }

    public String getEnv() {
        return this.env;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getVersionRule() {
        return this.versionRule;
    }

    public String plainKey() {
        return this.serviceName + "@" + this.appId + "@" + this.env + "@" + this.versionRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MicroserviceCacheKey that = (MicroserviceCacheKey)o;
        return Objects.equals(this.env, that.env) && Objects.equals(this.appId, that.appId) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.versionRule, that.versionRule);
    }

    public int hashCode() {
        return Objects.hash(this.env, this.appId, this.serviceName, this.versionRule);
    }

    public String toString() {
        return this.plainKey();
    }

    public static class MicroserviceCacheKeyBuilder {
        private final MicroserviceCacheKey microserviceCacheKey = new MicroserviceCacheKey();

        public MicroserviceCacheKey build() {
            this.microserviceCacheKey.validate();
            MicroserviceNameParser microserviceNameParser = new MicroserviceNameParser(this.microserviceCacheKey.appId, this.microserviceCacheKey.serviceName);
            this.microserviceCacheKey.appId = microserviceNameParser.getAppId();
            this.microserviceCacheKey.serviceName = microserviceNameParser.getShortName();
            return this.microserviceCacheKey;
        }

        public MicroserviceCacheKeyBuilder env(String env) {
            this.microserviceCacheKey.env = env;
            return this;
        }

        public MicroserviceCacheKeyBuilder appId(String appId) {
            this.microserviceCacheKey.appId = appId;
            return this;
        }

        public MicroserviceCacheKeyBuilder serviceName(String serviceName) {
            this.microserviceCacheKey.serviceName = serviceName;
            return this;
        }

        public MicroserviceCacheKeyBuilder versionRule(String versionRule) {
            this.microserviceCacheKey.versionRule = versionRule;
            return this;
        }

        MicroserviceCacheKeyBuilder() {
        }
    }
}

