/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.EdgeCollision;
import org.twak.camp.EdgeSpatialIndex;
import org.twak.camp.HeightCollision;
import org.twak.camp.HeightEvent;
import org.twak.camp.Skeleton;
import org.twak.camp.debug.DebugDevice;
import org.twak.utils.geom.LinearForm3D;

public class CollisionQ {
    private PriorityQueue<EdgeCollision> faceEvents;
    private PriorityQueue<HeightEvent> miscEvents;
    Skeleton skel;
    private Set<EdgeCollision> seen = new HashSet<EdgeCollision>();
    private EdgeSpatialIndex edgeIndex;
    final int edgeNeighbors;
    HeightCollision currentCoHeighted = null;
    boolean holdRemoves = false;
    List<Corner> removes = new ArrayList<Corner>();

    public CollisionQ(Skeleton skel) {
        this(skel, Integer.MAX_VALUE);
    }

    public CollisionQ(Skeleton skel, int edgeNeighbors) {
        this.skel = skel;
        this.edgeNeighbors = edgeNeighbors;
        int initSize = Math.max(3, skel.liveCorners.size());
        this.faceEvents = new PriorityQueue<HeightEvent>(initSize, HeightEvent.heightComparator);
        this.miscEvents = new PriorityQueue<HeightEvent>(initSize, HeightEvent.heightComparator);
        if (edgeNeighbors != Integer.MAX_VALUE) {
            this.edgeIndex = new EdgeSpatialIndex(skel.liveEdges);
        }
    }

    private HeightEvent nextEvent() {
        EdgeCollision ec;
        while ((ec = this.faceEvents.poll()) != null && (this.skel.seen.contains(ec) || !(ec.loc.z >= this.skel.height - 0.001))) {
        }
        HeightEvent he = this.miscEvents.peek();
        if (ec == null) {
            return this.miscEvents.poll();
        }
        if (he == null) {
            this.skel.seen.add(ec);
            return ec;
        }
        if (he.getHeight() <= ec.getHeight()) {
            this.faceEvents.add(ec);
            return this.miscEvents.poll();
        }
        this.skel.seen.add(ec);
        return ec;
    }

    public HeightEvent poll() {
        this.currentCoHeighted = null;
        HeightEvent next = this.nextEvent();
        if (next instanceof EdgeCollision) {
            EdgeCollision higher;
            ArrayList<EdgeCollision> coHeighted = new ArrayList<EdgeCollision>();
            EdgeCollision ec = (EdgeCollision)next;
            coHeighted.add(ec);
            double height = ec.getHeight();
            while ((higher = this.faceEvents.peek()) != null && Math.abs(higher.getHeight() - height) < 1.0E-5) {
                this.faceEvents.poll();
                if (this.skel.seen.contains(higher)) continue;
                height = higher.getHeight();
                this.skel.seen.add(higher);
                coHeighted.add(higher);
            }
            this.currentCoHeighted = new HeightCollision(coHeighted);
            return this.currentCoHeighted;
        }
        return next;
    }

    public void add(HeightEvent he) {
        if (he instanceof EdgeCollision) {
            this.faceEvents.add((EdgeCollision)he);
        } else {
            this.miscEvents.add(he);
        }
    }

    public void addCorner(Corner toAdd, HeightCollision postProcess) {
        this.addCorner(toAdd, postProcess, false);
    }

    public void addCorner(Corner toAdd, HeightCollision postProcess, boolean useCache) {
        if (!this.skel.preserveParallel && toAdd.prevL.sameDirectedLine(toAdd.nextL)) {
            this.removeCorner(toAdd);
            return;
        }
        if (toAdd.prevL == toAdd.nextC.nextL) {
            this.skel.output.addOutputSideTo(toAdd, (Tuple3d)toAdd.nextC, toAdd.prevL, toAdd.nextL);
            toAdd.nextL.currentCorners.remove(toAdd);
            toAdd.nextL.currentCorners.remove(toAdd.nextC);
            toAdd.prevL.currentCorners.remove(toAdd);
            toAdd.prevL.currentCorners.remove(toAdd.nextC);
            if (toAdd.nextL.currentCorners.isEmpty()) {
                this.skel.liveEdges.remove(toAdd.nextL);
            }
            if (toAdd.prevL.currentCorners.isEmpty()) {
                this.skel.liveEdges.remove(toAdd.prevL);
            }
            this.skel.liveCorners.remove(toAdd);
            this.skel.liveCorners.remove(toAdd.nextC);
            return;
        }
        if (!this.skel.preserveParallel && toAdd.prevL.isCollisionNearHoriz(toAdd.nextL)) {
            if (toAdd.nextL.isParallel(toAdd.prevL)) {
                postProcess.newHoriz(toAdd);
            }
            return;
        }
        Collection<Edge> candidateEdges = this.edgeIndex == null ? this.skel.liveEdges : this.edgeIndex.search(toAdd.x, toAdd.y, this.edgeNeighbors);
        for (Edge e : candidateEdges) {
            EdgeCollision ex = new EdgeCollision(null, toAdd.prevL, toAdd.nextL, e);
            if (useCache && this.seen.contains(ex)) continue;
            this.seen.add(ex);
            this.cornerEdgeCollision(toAdd, e);
        }
    }

    private void cornerEdgeCollision(Corner corner, Edge edge) {
        if (this.skel.preserveParallel) {
            if (edge.isParallel(corner.prevL) && edge.isParallel(corner.nextL)) {
                return;
            }
            if (corner.nextL == edge || corner.prevL == edge) {
                return;
            }
        } else if (edge.isParallel(corner.prevL) || edge.isParallel(corner.nextL)) {
            return;
        }
        Tuple3d res = null;
        try {
            if (corner.prevL.linearForm.hasNaN() || corner.nextL.linearForm.hasNaN() || edge.linearForm.hasNaN()) {
                throw new Error();
            }
            if (this.skel.preserveParallel && corner.nextL.isParallel(corner.prevL)) {
                LinearForm3D fake = new LinearForm3D(corner.nextL.direction(), corner);
                res = edge.linearForm.collide(fake, corner.prevL.linearForm);
            } else {
                res = edge.linearForm.collide(corner.prevL.linearForm, corner.nextL.linearForm);
            }
        }
        catch (Throwable fake) {
            // empty catch block
        }
        if (res != null) {
            if (res.z < corner.z || res.z < edge.start.z) {
                return;
            }
            EdgeCollision ec = new EdgeCollision(new Point3d(res), corner.prevL, corner.nextL, edge);
            if (!this.skel.seen.contains(ec)) {
                this.faceEvents.offer(ec);
            }
        }
    }

    public void holdRemoves() {
        this.removes.clear();
        this.holdRemoves = true;
    }

    public void resumeRemoves() {
        this.holdRemoves = false;
        for (Corner c : this.removes) {
            if (!this.skel.liveCorners.contains(c)) continue;
            this.removeCorner(c);
        }
        this.removes.clear();
    }

    private void removeCorner(Corner toAdd) {
        if (this.holdRemoves) {
            this.removes.add(toAdd);
            return;
        }
        DebugDevice.dump("about to delete " + String.valueOf(toAdd), this.skel);
        toAdd.prevC.nextC = toAdd.nextC;
        toAdd.nextC.prevC = toAdd.prevC;
        toAdd.nextC.prevL = toAdd.prevL;
        this.skel.liveCorners.remove(toAdd);
        for (Corner lc : this.skel.liveCorners) {
            if (lc.nextL == toAdd.nextL) {
                lc.nextL = toAdd.prevL;
            }
            if (lc.prevL != toAdd.nextL) continue;
            lc.prevL = toAdd.prevL;
        }
        if (toAdd.prevL != toAdd.nextL) {
            this.skel.liveEdges.remove(toAdd.nextL);
            for (Corner c : toAdd.nextL.currentCorners) {
                toAdd.prevL.currentCorners.add(c);
            }
            this.skel.output.merge(toAdd.prevC, toAdd);
            this.skel.refindAllFaceEventsLater();
        }
        toAdd.prevL.currentCorners.remove(toAdd);
    }

    public void dump() {
        int i = 0;
        for (EdgeCollision ec : this.faceEvents) {
            System.out.println(String.format("%d : %s ", i++, ec));
        }
    }

    public void clearFaceEvents() {
        this.faceEvents.clear();
    }

    public void clearOtherEvents() {
        this.miscEvents.clear();
    }
}

