/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Consumer;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsEnum;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.guava.annotations.VisibleForTesting;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.guava.collect.Lists;
import org.apache.sedona.shaded.s2.R1Interval;
import org.apache.sedona.shaded.s2.R2Rect;
import org.apache.sedona.shaded.s2.R2Vector;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2CellUnion;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2Iterator;
import org.apache.sedona.shaded.s2.S2PaddedCell;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Projections;
import org.apache.sedona.shaded.s2.S2Shape;
import org.jspecify.annotations.Nullable;

@JsType
public class S2ShapeIndex
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final double CELL_PADDING = 2.0 * (S2EdgeUtil.FACE_CLIP_ERROR_UV_COORD + 4.996003610813204E-16);
    public static final int DEFAULT_MAX_EDGES_PER_CELL = 10;
    public static final double DEFAULT_CELL_SIZE_TO_LONG_EDGE_RATIO = 1.0;
    static final double DEFAULT_MIN_SHORT_EDGE_FRACTION = 0.2;
    public static final int CURRENT_ENCODING_VERSION = 0;
    protected final Options options;
    protected List<S2Shape> shapes;
    private List<Cell> cells = ImmutableList.of();
    private int pendingInsertionsBegin = 0;
    private final List<S2Shape> pendingRemovals = Lists.newArrayList();
    private volatile boolean isIndexFresh = true;

    @JsIgnore
    public S2ShapeIndex() {
        this(new Options());
    }

    @JsConstructor
    public S2ShapeIndex(Options options) {
        this.options = options;
        this.shapes = new ArrayList<S2Shape>();
    }

    public static S2ShapeIndex fromShapes(S2Shape ... shapes) {
        S2ShapeIndex index = new S2ShapeIndex();
        for (S2Shape shape : shapes) {
            index.add(shape);
        }
        return index;
    }

    public Options options() {
        return this.options;
    }

    public List<S2Shape> getShapes() {
        return Collections.unmodifiableList(this.shapes);
    }

    public void add(S2Shape shape) {
        this.shapes.add(shape);
        this.isIndexFresh = false;
    }

    public void remove(S2Shape shape) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void reset() {
        this.cells = ImmutableList.of();
        this.pendingRemovals.clear();
        this.shapes.clear();
        this.isIndexFresh = false;
        this.pendingInsertionsBegin = 0;
    }

    public S2Iterator.ListIterator<Cell> iterator() {
        this.applyUpdates();
        return S2Iterator.fromList(this.cells);
    }

    public boolean isFresh() {
        return this.isIndexFresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyUpdates() {
        if (this.isIndexFresh) {
            return;
        }
        S2ShapeIndex s2ShapeIndex = this;
        synchronized (s2ShapeIndex) {
            if (!this.isIndexFresh) {
                int face;
                Preconditions.checkState(this.cells.isEmpty(), "Incremental updates not supported yet");
                int numEdges = 0;
                for (int i = this.pendingInsertionsBegin; i < this.shapes.size(); ++i) {
                    numEdges += this.shapes.get(i).numEdges();
                }
                this.cells = S2ShapeIndex.createList(3 * numEdges / this.options.maxEdgesPerCell / 4);
                List<List<FaceEdge>> allEdges = S2ShapeIndex.createList(6);
                for (int face2 = 0; face2 < 6; ++face2) {
                    List edges = S2ShapeIndex.createList(numEdges);
                    allEdges.add(edges);
                }
                IndexState state = new IndexState();
                state.ensureSize(this.shapes.size() - this.pendingInsertionsBegin);
                for (int i = this.pendingInsertionsBegin; i < this.shapes.size(); ++i) {
                    this.addShapeEdges(i, allEdges, state.tracker);
                }
                int maxFaceSize = 0;
                for (face = 0; face < 6; ++face) {
                    maxFaceSize = Math.max(maxFaceSize, allEdges.get(face).size());
                }
                state.options = this.options;
                state.shapes = this.shapes;
                state.cells = this.cells::add;
                state.alloc = new EdgeAllocator(maxFaceSize);
                for (face = 0; face < 6; ++face) {
                    this.updateFaceEdges(face, allEdges.get(face), state);
                    allEdges.set(face, null);
                }
                this.pendingInsertionsBegin = this.shapes.size();
                this.isIndexFresh = true;
            }
        }
    }

    private void reserveSpace(int numEdges, List<List<FaceEdge>> allEdges) {
        int maxCheapMemoryBytes = 0xA00000;
        int faceEdgeSize = 140;
        int maxCheapNumEdges = 12483;
        if (numEdges <= 12483) {
            for (int face = 0; face < 6; ++face) {
                SimpleList edges = new SimpleList(numEdges);
                allEdges.add(edges);
            }
            return;
        }
        int desiredSampleSize = 10000;
        int sampleInterval = Math.max(1, numEdges / 10000);
        int edgeId = sampleInterval / 2;
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        int actualSampleSize = (numEdges + edgeId) / sampleInterval;
        int[] faceCount = new int[]{0, 0, 0, 0, 0, 0};
        for (int i = this.pendingInsertionsBegin; i < this.shapes.size(); ++i) {
            S2Shape shape = this.shapes.get(i);
            edgeId += shape.numEdges();
            while (edgeId >= sampleInterval) {
                shape.getEdge(edgeId -= sampleInterval, edge);
                int n = S2Projections.xyzToFace(edge.a);
                faceCount[n] = faceCount[n] + 1;
            }
        }
        double maxSemiWidth = 0.02;
        double sampleRatio = 1.0 / (double)actualSampleSize;
        for (int face = 0; face < 6; ++face) {
            SimpleList edges;
            if (faceCount[face] > 0) {
                int fraction = (int)(sampleRatio * (double)faceCount[face] + 0.02);
                edges = new SimpleList(1 + fraction * numEdges);
            } else {
                edges = new SimpleList(1);
            }
            allEdges.add(edges);
        }
    }

    private void addShapeEdges(int shapeId, List<List<FaceEdge>> allEdges, InteriorTracker tracker) {
        S2Shape shape = this.shapes.get(shapeId);
        boolean hasInterior = shape.hasInterior();
        if (hasInterior) {
            tracker.addShape(shapeId, shape);
        }
        int numEdges = shape.numEdges();
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        R2Vector a = new R2Vector();
        R2Vector b = new R2Vector();
        double ratio = this.options.getCellSizeToLongEdgeRatio();
        for (int e = 0; e < numEdges; ++e) {
            int aFace;
            shape.getEdge(e, edge);
            if (hasInterior) {
                tracker.testEdge(shapeId, edge.a, edge.b);
            }
            if ((aFace = S2Projections.xyzToFace(edge.a)) == S2Projections.xyzToFace(edge.b)) {
                S2Projections.validFaceXyzToUv(aFace, edge.a, a);
                S2Projections.validFaceXyzToUv(aFace, edge.b, b);
                double kMaxUV = 1.0 - CELL_PADDING;
                if (Math.abs(a.x) <= kMaxUV && Math.abs(a.y) <= kMaxUV && Math.abs(b.x) <= kMaxUV && Math.abs(b.y) <= kMaxUV) {
                    allEdges.get(aFace).add(new FaceEdge(shapeId, e, edge.a, edge.b, a, b, ratio));
                    continue;
                }
            }
            for (int face = 0; face < 6; ++face) {
                if (!S2EdgeUtil.clipToPaddedFace(edge.a, edge.b, face, CELL_PADDING, a, b)) continue;
                allEdges.get(face).add(new FaceEdge(shapeId, e, edge.a, edge.b, a, b, ratio));
            }
        }
    }

    private void updateFaceEdges(int face, List<FaceEdge> faceEdges, IndexState state) {
        S2CellId shrunkId;
        int numEdges = faceEdges.size();
        if (numEdges == 0 && state.tracker.focusCount == 0) {
            return;
        }
        List<ClippedEdge> clippedEdges = S2ShapeIndex.createList(numEdges);
        R2Rect bound = R2Rect.empty();
        for (int i = 0; i < numEdges; ++i) {
            FaceEdge edge = faceEdges.get(i);
            ClippedEdge clipped = new ClippedEdge();
            clipped.set(edge);
            clippedEdges.add(clipped);
            bound.addRect(clipped.bound);
        }
        S2CellId faceId = S2CellId.fromFace(face);
        S2PaddedCell pcell = new S2PaddedCell(faceId, CELL_PADDING);
        if (numEdges > 0 && (shrunkId = pcell.shrinkToFit(bound)).id() != pcell.id().id()) {
            S2ShapeIndex.skipCellRange(faceId.rangeMin(), shrunkId.rangeMin(), state);
            pcell = new S2PaddedCell(shrunkId, CELL_PADDING);
            S2ShapeIndex.updateEdges(pcell, clippedEdges, state);
            S2ShapeIndex.skipCellRange(shrunkId.rangeMax().next(), faceId.rangeMax().next(), state);
            return;
        }
        S2ShapeIndex.updateEdges(pcell, clippedEdges, state);
    }

    private static void skipCellRange(S2CellId begin, S2CellId end, IndexState state) {
        if (state.tracker.focusCount > 0) {
            S2CellUnion skipped = new S2CellUnion();
            skipped.initFromBeginEnd(begin, end);
            ImmutableList<ClippedEdge> clippedEdges = ImmutableList.of();
            for (int i = 0; i < skipped.size(); ++i) {
                S2PaddedCell pcell = new S2PaddedCell(skipped.cellId(i), CELL_PADDING);
                S2ShapeIndex.updateEdges(pcell, clippedEdges, state);
            }
        }
    }

    static boolean makeIndexCell(S2PaddedCell pcell, List<ClippedEdge> edges, IndexState state) {
        if (edges.isEmpty() && state.tracker.focusCount == 0) {
            return true;
        }
        if (edges.size() > state.options.maxEdgesPerCell) {
            int maxShortEdges = Math.max(state.options.maxEdgesPerCell, (int)(state.options.minShortEdgeFraction * (double)(edges.size() + state.tracker.focusCount)));
            int count = 0;
            for (ClippedEdge edge : edges) {
                if ((count += pcell.level() < edge.orig.maxLevel ? 1 : 0) <= maxShortEdges) continue;
                return false;
            }
        }
        if (state.tracker.isActive() && !edges.isEmpty()) {
            if (!state.tracker.atCellId(pcell.id())) {
                state.tracker.moveTo(pcell.getEntryVertex());
            }
            state.tracker.drawTo(pcell.getCenter());
            S2ShapeIndex.testClippedEdges(edges, state);
        }
        S2CellId cellId = pcell.id();
        int numShapes = 0;
        int numEdges = edges.size();
        int edgesIndex = 0;
        int trackerIndex = 0;
        int nextShapeId = state.shapes.size();
        while (edgesIndex < numEdges || trackerIndex < state.tracker.focusCount) {
            S2ClippedShape clipped;
            int edgeId;
            int trackerId = trackerIndex < state.tracker.focusCount ? state.tracker.focusedShapes[trackerIndex] : nextShapeId;
            if (trackerId < (edgeId = edgesIndex < numEdges ? edges.get((int)edgesIndex).orig.shapeId : nextShapeId)) {
                clipped = S2ClippedShape.Contained.create(cellId, trackerId);
                cellId = null;
                ++trackerIndex;
            } else {
                int firstEdge = edgesIndex;
                while (edgesIndex < numEdges && edges.get((int)edgesIndex).orig.shapeId == edgeId) {
                    ++edgesIndex;
                }
                boolean containsCenter = trackerId == edgeId;
                clipped = S2ClippedShape.create(cellId, edgeId, containsCenter, edges, firstEdge, edgesIndex);
                cellId = null;
                if (containsCenter) {
                    ++trackerIndex;
                }
            }
            state.tempClippedShapes[numShapes++] = clipped;
        }
        state.cells.accept(Cell.create(numShapes, state.tempClippedShapes));
        if (state.tracker.isActive() && !edges.isEmpty()) {
            state.tracker.drawTo(pcell.getExitVertex());
            S2ShapeIndex.testClippedEdges(edges, state);
            state.tracker.doneCellId(pcell.id());
        }
        return true;
    }

    private static void testClippedEdges(List<ClippedEdge> edges, IndexState state) {
        for (ClippedEdge edge : edges) {
            FaceEdge orig = edge.orig;
            if (!state.shapes.get(orig.shapeId).hasInterior()) continue;
            state.tracker.testEdge(orig.shapeId, orig.va, orig.vb);
        }
    }

    static void updateEdges(S2PaddedCell pcell, List<ClippedEdge> edges, IndexState state) {
        assert (!edges.isEmpty() || state.tracker.focusCount > 0);
        if (S2ShapeIndex.makeIndexCell(pcell, edges, state)) {
            return;
        }
        int numEdges = edges.size();
        List<ClippedEdge> edges00 = S2ShapeIndex.createList(numEdges);
        List<ClippedEdge> edges01 = S2ShapeIndex.createList(numEdges);
        List<ClippedEdge> edges10 = S2ShapeIndex.createList(numEdges);
        List<ClippedEdge> edges11 = S2ShapeIndex.createList(numEdges);
        ImmutableList ijEdges = ImmutableList.of(edges00, edges01, edges10, edges11);
        int allocSize = state.alloc.size();
        R2Rect middle = pcell.middle();
        for (int i = 0; i < numEdges; ++i) {
            ClippedEdge edge = edges.get(i);
            if (edge.bound.x().hi() <= middle.x().lo()) {
                S2ShapeIndex.clipVAxis(edge, middle.y(), edges00, edges01, state.alloc);
                continue;
            }
            if (edge.bound.x().lo() >= middle.x().hi()) {
                S2ShapeIndex.clipVAxis(edge, middle.y(), edges10, edges11, state.alloc);
                continue;
            }
            if (edge.bound.y().hi() <= middle.y().lo()) {
                edges00.add(S2ShapeIndex.clipUBound(edge, true, middle.x().hi(), state.alloc));
                edges10.add(S2ShapeIndex.clipUBound(edge, false, middle.x().lo(), state.alloc));
                continue;
            }
            if (edge.bound.y().lo() >= middle.y().hi()) {
                edges01.add(S2ShapeIndex.clipUBound(edge, true, middle.x().hi(), state.alloc));
                edges11.add(S2ShapeIndex.clipUBound(edge, false, middle.x().lo(), state.alloc));
                continue;
            }
            ClippedEdge left = S2ShapeIndex.clipUBound(edge, true, middle.x().hi(), state.alloc);
            S2ShapeIndex.clipVAxis(left, middle.y(), edges00, edges01, state.alloc);
            ClippedEdge right = S2ShapeIndex.clipUBound(edge, false, middle.x().lo(), state.alloc);
            S2ShapeIndex.clipVAxis(right, middle.y(), edges10, edges11, state.alloc);
        }
        for (int pos = 0; pos < 4; ++pos) {
            List childEdges = (List)ijEdges.get(S2.posToIJ(pcell.orientation(), pos));
            if (childEdges.isEmpty() && state.tracker.focusCount <= 0) continue;
            S2PaddedCell childCell = pcell.childAtPos(pos);
            S2ShapeIndex.updateEdges(childCell, childEdges, state);
        }
        state.alloc.reset(allocSize);
    }

    private static ClippedEdge updateBound(ClippedEdge edge, boolean uEnd, double u, boolean vEnd, double v, EdgeAllocator alloc) {
        ClippedEdge clipped = alloc.create();
        clipped.orig = edge.orig;
        if (uEnd) {
            clipped.bound.x().set(edge.bound.x().lo(), u);
        } else {
            clipped.bound.x().set(u, edge.bound.x().hi());
        }
        if (vEnd) {
            clipped.bound.y().set(edge.bound.y().lo(), v);
        } else {
            clipped.bound.y().set(v, edge.bound.y().hi());
        }
        assert (!clipped.bound.isEmpty());
        assert (edge.bound.contains(clipped.bound));
        return clipped;
    }

    private static ClippedEdge clipUBound(ClippedEdge edge, boolean uEnd, double u, EdgeAllocator alloc) {
        if (!uEnd ? edge.bound.x().lo() >= u : edge.bound.x().hi() <= u) {
            return edge;
        }
        FaceEdge e = edge.orig;
        double v = edge.bound.y().clampPoint(S2EdgeUtil.interpolateDouble(u, e.ax, e.bx, e.ay, e.by));
        boolean vEnd = e.ax > e.bx != e.ay > e.by ^ uEnd;
        return S2ShapeIndex.updateBound(edge, uEnd, u, vEnd, v, alloc);
    }

    private static ClippedEdge clipVBound(ClippedEdge edge, boolean vEnd, double v, EdgeAllocator alloc) {
        if (!vEnd ? edge.bound.y().lo() >= v : edge.bound.y().hi() <= v) {
            return edge;
        }
        FaceEdge e = edge.orig;
        double u = edge.bound.x().clampPoint(S2EdgeUtil.interpolateDouble(v, e.ay, e.by, e.ax, e.bx));
        boolean uEnd = e.ax > e.bx != e.ay > e.by ^ vEnd;
        return S2ShapeIndex.updateBound(edge, uEnd, u, vEnd, v, alloc);
    }

    private static void clipVAxis(ClippedEdge edge, R1Interval middle, List<ClippedEdge> edges0, List<ClippedEdge> edges1, EdgeAllocator alloc) {
        if (edge.bound.y().hi() <= middle.lo()) {
            edges0.add(edge);
        } else if (edge.bound.y().lo() >= middle.hi()) {
            edges1.add(edge);
        } else {
            edges0.add(S2ShapeIndex.clipVBound(edge, true, middle.hi(), alloc));
            edges1.add(S2ShapeIndex.clipVBound(edge, false, middle.lo(), alloc));
        }
    }

    @VisibleForTesting
    static final int getEdgeMaxLevel(S2Point va, S2Point vb, double cellSizeToLongEdgeRatio) {
        double maxCellEdge = va.getDistance(vb) * cellSizeToLongEdgeRatio;
        return S2Projections.AVG_EDGE.getMinLevel(maxCellEdge);
    }

    static final <T> List<T> createList(int maxSize) {
        if (maxSize < 256) {
            return new SimpleList(maxSize);
        }
        return new ShardedList(maxSize);
    }

    private static final class ShardedList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Object[][] elements;
        private int size;

        public ShardedList(int maxItems) {
            this.elements = new Object[1 + (maxItems >> 8)][];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(T item) {
            int shard = this.size >> 8;
            if (shard == this.elements.length) {
                this.elements = (Object[][])Arrays.copyOf(this.elements, shard * 2);
                this.elements[shard] = new Object[256];
            } else if (this.elements[shard] == null) {
                this.elements[shard] = new Object[256];
            }
            this.elements[shard][this.size & 0xFF] = item;
            ++this.size;
            return true;
        }

        @Override
        public T get(int index) {
            Object result = this.elements[index >> 8][index & 0xFF];
            return (T)result;
        }

        @Override
        public T set(int index, T value) {
            Object[] result = this.elements[index];
            this.elements[index >> 8][index & 0xFF] = value;
            return (T)result;
        }
    }

    private static final class SimpleList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Object[] elements;
        private int size;

        public SimpleList(int maxSize) {
            this.elements = new Object[Math.max(1, maxSize)];
        }

        @Override
        public T get(int index) {
            Object result = this.elements[index];
            return (T)result;
        }

        @Override
        public T set(int index, T value) {
            Object old = this.elements[index];
            this.elements[index] = value;
            return (T)old;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(T item) {
            if (this.size == this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, this.size * 2);
            }
            this.elements[this.size++] = item;
            return true;
        }
    }

    static final class InteriorTracker {
        private boolean isActive = false;
        private S2Point focus = S2.origin();
        private S2CellId nextCellId = S2CellId.begin(30);
        private final S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser();
        private int[] focusedShapes = new int[8];
        private int focusCount;

        public InteriorTracker() {
            this.drawTo(S2Point.normalize(S2Projections.faceUvToXyz(0, -1.0, -1.0)));
        }

        public void ensureSize(int numShapes) {
            if (numShapes > this.focusedShapes.length) {
                this.focusedShapes = Arrays.copyOf(this.focusedShapes, numShapes);
            }
            this.isActive = false;
            this.focusCount = 0;
        }

        public int numFocused() {
            return this.focusCount;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void addShape(int shapeId, S2Shape shape) {
            this.isActive = true;
            if (shape.containsOrigin()) {
                this.toggleShape(shapeId);
            }
        }

        public void moveTo(S2Point b) {
            this.focus = b;
        }

        public void drawTo(S2Point focus) {
            this.crosser.init(this.focus, focus);
            this.focus = focus;
        }

        public void testEdge(int shapeId, S2Point start, S2Point end) {
            if (this.crosser.edgeOrVertexCrossing(start, end)) {
                this.toggleShape(shapeId);
            }
        }

        public void doneCellId(S2CellId cellid) {
            this.nextCellId = cellid.rangeMax().next();
        }

        public boolean atCellId(S2CellId cellid) {
            return cellid.rangeMin().id() == this.nextCellId.id();
        }

        public void toggleShape(int shapeId) {
            if (this.focusCount == 0) {
                this.focusedShapes[0] = shapeId;
                ++this.focusCount;
            } else if (this.focusedShapes[0] == shapeId) {
                if (this.focusCount-- > 1) {
                    System.arraycopy(this.focusedShapes, 1, this.focusedShapes, 0, this.focusCount);
                }
            } else {
                int pos = 0;
                while (this.focusedShapes[pos] < shapeId) {
                    if (++pos != this.focusCount) continue;
                    this.focusedShapes[this.focusCount++] = shapeId;
                    return;
                }
                if (this.focusedShapes[pos] == shapeId) {
                    --this.focusCount;
                    System.arraycopy(this.focusedShapes, pos + 1, this.focusedShapes, pos, this.focusCount - pos);
                } else {
                    System.arraycopy(this.focusedShapes, pos, this.focusedShapes, pos + 1, this.focusCount - pos);
                    this.focusedShapes[pos] = shapeId;
                    ++this.focusCount;
                }
            }
        }
    }

    static final class EdgeAllocator {
        private int size;
        private final List<ClippedEdge> edges;

        public EdgeAllocator(int maxEdges) {
            this.edges = S2ShapeIndex.createList(maxEdges);
        }

        public ClippedEdge create() {
            if (this.size == this.edges.size()) {
                this.edges.add(new ClippedEdge());
            }
            return this.edges.get(this.size++);
        }

        public int size() {
            return this.size;
        }

        public void reset(int size) {
            this.size = size;
        }
    }

    @JsType
    static class ClippedEdge {
        private FaceEdge orig;
        private final R2Rect bound = new R2Rect();

        ClippedEdge() {
        }

        public void set(FaceEdge faceEdge) {
            this.orig = faceEdge;
            this.bound.x().initFromPointPair(faceEdge.ax, faceEdge.bx);
            this.bound.y().initFromPointPair(faceEdge.ay, faceEdge.by);
        }
    }

    static final class FaceEdge {
        private final int shapeId;
        private final int edgeId;
        private final int maxLevel;
        private final double ax;
        private final double ay;
        private final double bx;
        private final double by;
        private final S2Point va;
        private final S2Point vb;

        FaceEdge(int shapeId, int edgeId, S2Point va, S2Point vb, R2Vector a, R2Vector b, double cellSizeToLongEdgeRatio) {
            this.shapeId = shapeId;
            this.edgeId = edgeId;
            this.ax = a.x;
            this.ay = a.y;
            this.bx = b.x;
            this.by = b.y;
            this.va = va;
            this.vb = vb;
            this.maxLevel = S2ShapeIndex.getEdgeMaxLevel(va, vb, cellSizeToLongEdgeRatio);
        }

        public String toString() {
            return "shape " + this.shapeId + " edge " + this.edgeId;
        }
    }

    public static abstract class S2ClippedShape
    extends Cell
    implements EdgeIds {
        static S2ClippedShape create(S2CellId cellId, int shapeId, boolean containsCenter, List<ClippedEdge> edges, int start, int end) {
            int numEdges = end - start;
            if (numEdges == 1) {
                return OneEdge.create(cellId, shapeId, containsCenter, edges.get((int)start).orig.edgeId);
            }
            int edge = edges.get((int)start).orig.edgeId;
            for (int i = 1; i < numEdges; ++i) {
                if (edge + i == edges.get((int)(start + i)).orig.edgeId) continue;
                return ManyEdges.create(cellId, shapeId, containsCenter, edges, start, end);
            }
            return EdgeRange.create(cellId, shapeId, containsCenter, edge, numEdges);
        }

        static S2ClippedShape create(@Nullable S2CellId cellId, int shapeId, boolean containsCenter, int offset, int count) {
            return EdgeRange.create(cellId, shapeId, containsCenter, offset, count);
        }

        public abstract int shapeId();

        @JsConstructor
        S2ClippedShape() {
        }

        public abstract boolean containsCenter();

        @Override
        public abstract int numEdges();

        @Override
        public abstract int edge(int var1);

        public final boolean containsEdge(int edgeId) {
            for (int e = 0; e < this.numEdges(); ++e) {
                if (this.edge(e) != edgeId) continue;
                return true;
            }
            return false;
        }

        @Override
        public final int numShapes() {
            return 1;
        }

        @Override
        public final S2ClippedShape clipped(int i) {
            assert (i == 0);
            return this;
        }

        static abstract class EdgeRange
        extends S2ClippedShape {
            private final int shapeId;
            private final int offset;
            private final int count;

            static EdgeRange create(@Nullable S2CellId cellId, int shapeId, boolean containsCenter, int offset, int count) {
                if (cellId != null) {
                    final long id = cellId.id();
                    if (containsCenter) {
                        return new EdgeRange(shapeId, offset, count){

                            @Override
                            public long id() {
                                return id;
                            }

                            @Override
                            public boolean containsCenter() {
                                return true;
                            }
                        };
                    }
                    return new EdgeRange(shapeId, offset, count){

                        @Override
                        public long id() {
                            return id;
                        }

                        @Override
                        public boolean containsCenter() {
                            return false;
                        }
                    };
                }
                if (containsCenter) {
                    return new EdgeRange(shapeId, offset, count){

                        @Override
                        public long id() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean containsCenter() {
                            return true;
                        }
                    };
                }
                return new EdgeRange(shapeId, offset, count){

                    @Override
                    public long id() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean containsCenter() {
                        return false;
                    }
                };
            }

            @JsConstructor
            private EdgeRange(int shapeId, int offset, int count) {
                this.shapeId = shapeId;
                this.offset = offset;
                this.count = count;
            }

            @Override
            public int shapeId() {
                return this.shapeId;
            }

            @Override
            public final int numEdges() {
                return this.count;
            }

            @Override
            public final int edge(int i) {
                return this.offset + i;
            }
        }

        static abstract class ManyEdges
        extends S2ClippedShape {
            private final int shapeId;
            private final int[] edges;

            static ManyEdges create(@Nullable S2CellId cellId, int shapeId, boolean containsCenter, List<ClippedEdge> edges, int start, int end) {
                int[] edgeArray = new int[end - start];
                for (int i = 0; i < edgeArray.length; ++i) {
                    edgeArray[i] = edges.get((int)(i + start)).orig.edgeId;
                }
                return ManyEdges.create(cellId, shapeId, containsCenter, edgeArray);
            }

            static ManyEdges create(@Nullable S2CellId cellId, int shapeId, boolean containsCenter, int[] edges) {
                if (cellId != null) {
                    final long id = cellId.id();
                    if (containsCenter) {
                        return new ManyEdges(shapeId, edges){

                            @Override
                            public long id() {
                                return id;
                            }

                            @Override
                            public boolean containsCenter() {
                                return true;
                            }
                        };
                    }
                    return new ManyEdges(shapeId, edges){

                        @Override
                        public long id() {
                            return id;
                        }

                        @Override
                        public boolean containsCenter() {
                            return false;
                        }
                    };
                }
                if (containsCenter) {
                    return new ManyEdges(shapeId, edges){

                        @Override
                        public long id() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean containsCenter() {
                            return true;
                        }
                    };
                }
                return new ManyEdges(shapeId, edges){

                    @Override
                    public long id() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean containsCenter() {
                        return false;
                    }
                };
            }

            @JsConstructor
            private ManyEdges(int shapeId, int[] edges) {
                this.shapeId = shapeId;
                this.edges = edges;
            }

            @Override
            public int shapeId() {
                return this.shapeId;
            }

            @Override
            public final int numEdges() {
                return this.edges.length;
            }

            @Override
            public final int edge(int i) {
                return this.edges[i];
            }
        }

        static abstract class OneEdge
        extends S2ClippedShape {
            private final int shapeId;
            private final int edgeId;

            static final OneEdge create(@Nullable S2CellId cellId, int shapeId, boolean containsCenter, int edgeId) {
                if (cellId != null) {
                    final long id = cellId.id();
                    if (containsCenter) {
                        return new OneEdge(shapeId, edgeId){

                            @Override
                            public long id() {
                                return id;
                            }

                            @Override
                            public boolean containsCenter() {
                                return true;
                            }
                        };
                    }
                    return new OneEdge(shapeId, edgeId){

                        @Override
                        public long id() {
                            return id;
                        }

                        @Override
                        public boolean containsCenter() {
                            return false;
                        }
                    };
                }
                if (containsCenter) {
                    return new OneEdge(shapeId, edgeId){

                        @Override
                        public long id() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean containsCenter() {
                            return true;
                        }
                    };
                }
                return new OneEdge(shapeId, edgeId){

                    @Override
                    public long id() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean containsCenter() {
                        return false;
                    }
                };
            }

            @JsConstructor
            private OneEdge(int shapeId, int edgeId) {
                this.shapeId = shapeId;
                this.edgeId = edgeId;
            }

            @Override
            public int shapeId() {
                return this.shapeId;
            }

            @Override
            public final int numEdges() {
                return 1;
            }

            @Override
            public final int edge(int i) {
                return this.edgeId;
            }
        }

        private static abstract class Contained
        extends S2ClippedShape {
            private final int shapeId;

            static Contained create(@Nullable S2CellId cellId, int shapeId) {
                if (cellId != null) {
                    final long id = cellId.id();
                    return new Contained(shapeId){

                        @Override
                        public long id() {
                            return id;
                        }
                    };
                }
                return new Contained(shapeId){

                    @Override
                    public long id() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @JsConstructor
            private Contained(int shapeId) {
                this.shapeId = shapeId;
            }

            @Override
            public int shapeId() {
                return this.shapeId;
            }

            @Override
            public final boolean containsCenter() {
                return true;
            }

            @Override
            public final int numEdges() {
                return 0;
            }

            @Override
            public final int edge(int i) {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    static interface EdgeIds {
        public int numEdges();

        public int edge(int var1);
    }

    @JsEnum
    public static enum CellRelation {
        INDEXED,
        SUBDIVIDED,
        DISJOINT;

    }

    @JsType
    public static abstract class Cell
    implements S2Iterator.Entry,
    Serializable {
        private static final long serialVersionUID = 1L;

        static Cell create(int size, S2ClippedShape[] tempClippedShapes) {
            switch (size) {
                case 1: {
                    return tempClippedShapes[0];
                }
                case 2: {
                    return new BinaryCell(tempClippedShapes[0], tempClippedShapes[1]);
                }
            }
            return new MultiCell(Arrays.copyOf(tempClippedShapes, size));
        }

        public List<S2ClippedShape> clippedShapes() {
            return new AbstractList<S2ClippedShape>(){

                @Override
                public int size() {
                    return this.numShapes();
                }

                @Override
                public S2ClippedShape get(int index) {
                    return this.clipped(index);
                }
            };
        }

        @Override
        public long id() {
            return this.clipped(0).id();
        }

        public abstract int numShapes();

        public int numEdges() {
            int numEdges = 0;
            for (int i = 0; i < this.numShapes(); ++i) {
                numEdges += this.clipped(i).numEdges();
            }
            return numEdges;
        }

        public abstract S2ClippedShape clipped(int var1);

        @Nullable S2ClippedShape findClipped(int shapeId) {
            for (int i = 0; i < this.numShapes(); ++i) {
                S2ClippedShape clipped = this.clipped(i);
                if (clipped.shapeId() != shapeId) continue;
                return clipped;
            }
            return null;
        }

        static final class MultiCell
        extends Cell {
            private final S2ClippedShape[] clippedShapes;

            @JsConstructor
            MultiCell(S2ClippedShape[] shapes) {
                this.clippedShapes = shapes;
            }

            @Override
            public int numShapes() {
                return this.clippedShapes.length;
            }

            @Override
            public S2ClippedShape clipped(int i) {
                return this.clippedShapes[i];
            }
        }

        static final class BinaryCell
        extends Cell {
            private static final long serialVersionUID = 1L;
            private final S2ClippedShape shape1;
            private final S2ClippedShape shape2;

            @JsConstructor
            BinaryCell(S2ClippedShape shape1, S2ClippedShape shape2) {
                this.shape1 = shape1;
                this.shape2 = shape2;
            }

            @Override
            public int numShapes() {
                return 2;
            }

            @Override
            public S2ClippedShape clipped(int i) {
                switch (i) {
                    case 0: {
                        return this.shape1;
                    }
                    case 1: {
                        return this.shape2;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @JsType
    public static class Options
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int maxEdgesPerCell = 10;
        private double cellSizeToLongEdgeRatio = 1.0;
        private double minShortEdgeFraction = 0.2;

        public int getMaxEdgesPerCell() {
            return this.maxEdgesPerCell;
        }

        public void setMaxEdgesPerCell(int maxEdgesPerCell) {
            this.maxEdgesPerCell = maxEdgesPerCell;
        }

        public double getCellSizeToLongEdgeRatio() {
            return this.cellSizeToLongEdgeRatio;
        }

        public void setCellSizeToLongEdgeRatio(double cellSizeToLongEdgeRatio) {
            this.cellSizeToLongEdgeRatio = cellSizeToLongEdgeRatio;
        }

        public double getMinShortEdgeFraction() {
            return this.minShortEdgeFraction;
        }

        public void setMinShortEdgeFraction(double minShortEdgeFraction) {
            this.minShortEdgeFraction = minShortEdgeFraction;
        }
    }

    static final class IndexState {
        Options options;
        final InteriorTracker tracker = new InteriorTracker();
        S2ClippedShape[] tempClippedShapes = new S2ClippedShape[4];
        EdgeAllocator alloc;
        List<S2Shape> shapes;
        Consumer<Cell> cells;

        IndexState() {
        }

        void ensureSize(int numShapes) {
            this.tracker.ensureSize(numShapes);
            if (numShapes > this.tempClippedShapes.length) {
                this.tempClippedShapes = new S2ClippedShape[numShapes];
            }
        }
    }
}

