/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.primitives.Ints;
import org.apache.sedona.shaded.s2.S2Builder;
import org.apache.sedona.shaded.s2.S2Error;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Predicates;
import org.apache.sedona.shaded.s2.primitives.IdSetLexicon;
import org.apache.sedona.shaded.s2.primitives.IntPairVector;
import org.apache.sedona.shaded.s2.primitives.IntSorter;
import org.apache.sedona.shaded.s2.primitives.IntVector;
import org.apache.sedona.shaded.s2.primitives.Ints;
import org.apache.sedona.shaded.s2.primitives.Sorter;

public class S2BuilderGraph {
    private static final int SENTINEL_ID = Integer.MAX_VALUE;
    public static final int MAX_INPUT_EDGE_ID = Integer.MAX_VALUE;
    public static final int NO_INPUT_EDGE_ID = 0x7FFFFFFE;
    private final S2Builder.GraphOptions options;
    private final List<S2Point> vertices;
    private final EdgeList edges;
    private final IntVector inputEdgeIdSetIds;
    private final IdSetLexicon inputEdgeIdSetLexicon;
    private final Ints.IntList labelSetIds;
    private final IdSetLexicon labelSetLexicon;
    private final S2Builder.IsFullPolygonPredicate isFullPolygonPredicate;

    public S2BuilderGraph(S2Builder.GraphOptions options, List<S2Point> vertices, EdgeList edges, IntVector inputEdgeIdSetIds, IdSetLexicon inputEdgeIdSetLexicon, Ints.IntList labelSetIds, IdSetLexicon labelSetLexicon, S2Builder.IsFullPolygonPredicate isFullPolygonPredicate) {
        this.options = options;
        this.vertices = vertices;
        this.edges = edges;
        this.inputEdgeIdSetIds = inputEdgeIdSetIds;
        this.inputEdgeIdSetLexicon = inputEdgeIdSetLexicon;
        this.labelSetIds = labelSetIds;
        this.labelSetLexicon = labelSetLexicon;
        this.isFullPolygonPredicate = isFullPolygonPredicate;
    }

    public S2Builder.GraphOptions options() {
        return new S2Builder.GraphOptions(this.options);
    }

    public int numVertices() {
        return this.vertices.size();
    }

    public S2Point vertex(int vertexId) {
        return this.vertices.get(vertexId);
    }

    public List<S2Point> vertices() {
        return this.vertices;
    }

    public int numEdges() {
        return this.edges.size();
    }

    public int edgeSrcId(int edgeId) {
        return this.edges.getSrcId(edgeId);
    }

    public int edgeDstId(int edgeId) {
        return this.edges.getDstId(edgeId);
    }

    public EdgeList edges() {
        return this.edges;
    }

    IntVector getInEdgeIds() {
        IntVector inEdgeIds = IntVector.ofSize(this.numEdges());
        inEdgeIds.fillConsecutive();
        IntSorter.sort(S2BuilderGraph.dstVertexEdgeComparator(this.edges), inEdgeIds);
        return inEdgeIds;
    }

    IntVector getSiblingMap() {
        IntVector inEdgeIds = this.getInEdgeIds();
        this.makeSiblingMap(inEdgeIds);
        return inEdgeIds;
    }

    private static boolean validateSiblingMap(IntVector siblingMap, int numEdges) {
        for (int edgeId = 0; edgeId < numEdges; ++edgeId) {
            if (siblingMap.get(siblingMap.get(edgeId)) == edgeId) continue;
            return false;
        }
        return true;
    }

    private boolean validateInEdgeIds(IntVector inEdgeIds) {
        for (int edgeId = 0; edgeId < this.numEdges(); ++edgeId) {
            if (this.edges.getSrcId(edgeId) == this.edges.getDstId(inEdgeIds.get(edgeId)) && this.edges.getDstId(edgeId) == this.edges.getSrcId(inEdgeIds.get(edgeId))) continue;
            return false;
        }
        return true;
    }

    void makeSiblingMap(IntVector inEdgeIds) {
        Preconditions.checkState(this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.REQUIRE || this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.CREATE || this.options.edgeType() == S2Builder.EdgeType.UNDIRECTED);
        assert (this.validateInEdgeIds(inEdgeIds));
        if (this.options.edgeType() == S2Builder.EdgeType.DIRECTED || this.options.degenerateEdges() == S2Builder.GraphOptions.DegenerateEdges.DISCARD) {
            assert (S2BuilderGraph.validateSiblingMap(inEdgeIds, this.numEdges()));
            return;
        }
        for (int edgeId = 0; edgeId < this.numEdges(); ++edgeId) {
            int vertexId = this.edges.getSrcId(edgeId);
            if (this.edges.getDstId(edgeId) != vertexId) continue;
            assert (edgeId + 1 < this.numEdges());
            assert (this.edges.getSrcId(edgeId + 1) == vertexId);
            assert (this.edges.getDstId(edgeId + 1) == vertexId);
            assert (inEdgeIds.get(edgeId) == edgeId);
            assert (inEdgeIds.get(edgeId + 1) == edgeId + 1);
            inEdgeIds.set(edgeId, edgeId + 1);
            inEdgeIds.set(edgeId + 1, edgeId);
            ++edgeId;
        }
        assert (S2BuilderGraph.validateSiblingMap(inEdgeIds, this.numEdges()));
    }

    IdSetLexicon.IdSet inputEdgeIds(int edgeId) {
        return this.inputEdgeIdSetLexicon().idSet(this.inputEdgeIdSetIds.get(edgeId));
    }

    int inputEdgeIdSetId(int edgeId) {
        return this.inputEdgeIdSetIds.get(edgeId);
    }

    IntVector inputEdgeIdSetIds() {
        return this.inputEdgeIdSetIds;
    }

    IdSetLexicon inputEdgeIdSetLexicon() {
        return this.inputEdgeIdSetLexicon;
    }

    public int minInputEdgeId(int edgeId) {
        IdSetLexicon.IdSet idSet = this.inputEdgeIds(edgeId);
        return idSet.isEmpty() ? 0x7FFFFFFE : idSet.first();
    }

    IntVector getMinInputEdgeIds() {
        IntVector minInputEdgeIds = IntVector.ofSize(this.numEdges());
        this.fillMinInputEdgeIds(minInputEdgeIds);
        return minInputEdgeIds;
    }

    void fillMinInputEdgeIds(IntVector minInputEdgeIds) {
        minInputEdgeIds.clear();
        minInputEdgeIds.resize(this.numEdges());
        for (int edgeId = 0; edgeId < this.numEdges(); ++edgeId) {
            minInputEdgeIds.set(edgeId, this.minInputEdgeId(edgeId));
        }
    }

    IntVector getInputEdgeOrder(Ints.IntList minInputEdgeIds) {
        IntVector orderedEdgeIds = IntVector.ofSize(this.numEdges());
        orderedEdgeIds.fillConsecutive();
        IntSorter.sort(S2BuilderGraph.edgeIdComparatorByMinInputEdgeId(minInputEdgeIds), orderedEdgeIds);
        return orderedEdgeIds;
    }

    public IdSetLexicon.IdSet labels(int inputEdgeId) {
        return this.labelSetLexicon().idSet(this.labelSetId(inputEdgeId));
    }

    public int labelSetId(int inputEdgeId) {
        return this.labelSetIds().isEmpty() ? Integer.MIN_VALUE : this.labelSetIds().get(inputEdgeId);
    }

    public Ints.IntList labelSetIds() {
        return this.labelSetIds;
    }

    public IdSetLexicon labelSetLexicon() {
        return this.labelSetLexicon;
    }

    S2Builder.IsFullPolygonPredicate isFullPolygonPredicate() {
        return this.isFullPolygonPredicate;
    }

    boolean isFullPolygon() {
        return this.isFullPolygonPredicate().test(this);
    }

    boolean fillLeftTurnMap(Ints.IntList inEdgeIds, int[] leftTurnMap, S2Error error) {
        Preconditions.checkArgument(leftTurnMap.length == this.numEdges());
        Arrays.fill(leftTurnMap, -1);
        if (this.numEdges() == 0) {
            return true;
        }
        VertexEdgeList v0Edges = new VertexEdgeList(this.vertices);
        IntVector unmatchedIncomingEdges = new IntVector();
        IntVector unmatchedOutgoingEdges = new IntVector();
        int out = 0;
        int in = 0;
        Edge outEdge = new Edge();
        this.edges.get(out, outEdge);
        Edge reverseInEdge = new Edge();
        this.edges.getReverse(inEdgeIds.get(in), reverseInEdge);
        Edge minEdge = new Edge();
        if (EdgeList.compareEdges(outEdge, reverseInEdge) < 0) {
            minEdge.set(outEdge);
        } else {
            minEdge.set(reverseInEdge);
        }
        while (!minEdge.isSentinel()) {
            int v0 = minEdge.srcId;
            while (minEdge.srcId == v0) {
                int v1 = minEdge.dstId;
                int outBegin = out;
                int inBegin = in;
                while (outEdge.isEqualTo(minEdge)) {
                    if (++out == this.numEdges()) {
                        outEdge.setSentinel();
                        continue;
                    }
                    this.edges.get(out, outEdge);
                }
                while (reverseInEdge.isEqualTo(minEdge)) {
                    if (++in == this.numEdges()) {
                        reverseInEdge.setSentinel();
                        continue;
                    }
                    this.edges.getReverse(inEdgeIds.get(in), reverseInEdge);
                }
                if (v0 != v1) {
                    S2BuilderGraph.addVertexEdges(outBegin, out, inBegin, in, v1, v0Edges);
                } else {
                    while (inBegin < in) {
                        leftTurnMap[inBegin] = inBegin;
                        ++inBegin;
                    }
                }
                if (EdgeList.compareEdges(outEdge, reverseInEdge) < 0) {
                    minEdge.set(outEdge);
                    continue;
                }
                minEdge.set(reverseInEdge);
            }
            if (v0Edges.isEmpty()) continue;
            v0Edges.sortClockwiseAround(v0);
            for (int veIndex = 0; veIndex < v0Edges.size(); ++veIndex) {
                if (v0Edges.incoming(veIndex)) {
                    unmatchedIncomingEdges.push(inEdgeIds.get(v0Edges.indexEdgeId(veIndex)));
                    continue;
                }
                if (!unmatchedIncomingEdges.isEmpty()) {
                    leftTurnMap[unmatchedIncomingEdges.pop()] = v0Edges.indexEdgeId(veIndex);
                    continue;
                }
                unmatchedOutgoingEdges.push(v0Edges.indexEdgeId(veIndex));
            }
            unmatchedOutgoingEdges.reverse();
            while (!unmatchedOutgoingEdges.isEmpty() && !unmatchedIncomingEdges.isEmpty()) {
                leftTurnMap[unmatchedIncomingEdges.pop()] = unmatchedOutgoingEdges.pop();
            }
            if (!unmatchedIncomingEdges.isEmpty() && error.ok()) {
                error.init(S2Error.Code.BUILDER_EDGES_DO_NOT_FORM_LOOPS, "Given edges do not form loops (indegree != outdegree)", new Object[0]);
            }
            unmatchedIncomingEdges.clear();
            unmatchedOutgoingEdges.clear();
            v0Edges.clear();
        }
        return error.ok();
    }

    static void canonicalizeLoopOrder(Ints.IntList minInputIds, int[] loop) {
        if (loop.length < 2) {
            return;
        }
        int pos = 0;
        boolean sawGap = false;
        for (int i = 1; i < loop.length; ++i) {
            int cmp = minInputIds.get(loop[i]) - minInputIds.get(loop[pos]);
            if (cmp < 0) {
                sawGap = true;
                continue;
            }
            if (cmp <= 0 && sawGap) continue;
            pos = i;
            sawGap = false;
        }
        if (++pos == loop.length) {
            pos = 0;
        }
        Ints.rotate(loop, -pos);
    }

    static void canonicalizeDirectedComponentOrder(Ints.IntList minInputIds, List<DirectedComponent> components) {
        Collections.sort(components, (componentA, componentB) -> {
            int minInputEdgeIdFirstLoopEdgeB;
            int minInputEdgeIdFirstLoopEdgeA = minInputIds.get(((int[])componentA.get(0))[0]);
            if (minInputEdgeIdFirstLoopEdgeA != (minInputEdgeIdFirstLoopEdgeB = minInputIds.get(((int[])componentB.get(0))[0]))) {
                return Integer.compare(minInputEdgeIdFirstLoopEdgeA, minInputEdgeIdFirstLoopEdgeB);
            }
            return Integer.compare(((int[])componentA.get(0))[0], ((int[])componentB.get(0))[0]);
        });
    }

    static void canonicalizeEdgeChainOrder(Ints.IntList minInputIds, ArrayList<int[]> chains) {
        Collections.sort(chains, (a, b) -> {
            int minInputEdgeIdFirstEdgeB;
            int minInputEdgeIdFirstEdgeA = minInputIds.get(a[0]);
            if (minInputEdgeIdFirstEdgeA != (minInputEdgeIdFirstEdgeB = minInputIds.get(b[0]))) {
                return Integer.compare(minInputEdgeIdFirstEdgeA, minInputEdgeIdFirstEdgeB);
            }
            return Integer.compare(a[0], b[0]);
        });
    }

    public boolean getDirectedLoops(LoopType loopType, ArrayList<int[]> loops, S2Error error) {
        Preconditions.checkState(this.options.degenerateEdges() == S2Builder.GraphOptions.DegenerateEdges.DISCARD || this.options.degenerateEdges() == S2Builder.GraphOptions.DegenerateEdges.DISCARD_EXCESS);
        Preconditions.checkState(this.options.edgeType() == S2Builder.EdgeType.DIRECTED);
        int[] leftTurnMap = new int[this.numEdges()];
        if (!this.fillLeftTurnMap(this.getInEdgeIds(), leftTurnMap, error)) {
            return false;
        }
        IntVector minInputEdgeIds = this.getMinInputEdgeIds();
        int[] pathIndex = new int[this.numVertices()];
        if (loopType == LoopType.SIMPLE) {
            Arrays.fill(pathIndex, -1);
        }
        IntVector pathEdgeIds = IntVector.empty();
        for (int startEdgeId = 0; startEdgeId < this.numEdges(); ++startEdgeId) {
            if (leftTurnMap[startEdgeId] < 0) continue;
            int edgeId = startEdgeId;
            while (leftTurnMap[edgeId] >= 0) {
                pathEdgeIds.add(edgeId);
                int nextEdgeId = leftTurnMap[edgeId];
                leftTurnMap[edgeId] = -1;
                if (loopType == LoopType.SIMPLE) {
                    pathIndex[this.edges.getSrcId((int)edgeId)] = pathEdgeIds.size() - 1;
                    int loopStart = pathIndex[this.edges.getDstId(edgeId)];
                    if (loopStart >= 0) {
                        int[] loop = pathEdgeIds.subList(loopStart, pathEdgeIds.size()).toArray();
                        pathEdgeIds.truncate(loopStart);
                        for (int loopEdgeId : loop) {
                            pathIndex[this.edges.getSrcId((int)loopEdgeId)] = -1;
                        }
                        S2BuilderGraph.canonicalizeLoopOrder(minInputEdgeIds, loop);
                        loops.add(loop);
                    }
                }
                edgeId = nextEdgeId;
            }
            if (loopType == LoopType.SIMPLE) {
                Preconditions.checkState(pathEdgeIds.isEmpty());
                continue;
            }
            int[] loop = pathEdgeIds.toArray();
            S2BuilderGraph.canonicalizeLoopOrder(minInputEdgeIds, loop);
            loops.add(loop);
            pathEdgeIds.clear();
        }
        S2BuilderGraph.canonicalizeEdgeChainOrder(minInputEdgeIds, loops);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean getDirectedComponents(DegenerateBoundaries degenerateBoundaries, List<DirectedComponent> outputComponents, S2Error error) {
        Preconditions.checkState(this.options.degenerateEdges() == S2Builder.GraphOptions.DegenerateEdges.DISCARD || this.options.degenerateEdges() == S2Builder.GraphOptions.DegenerateEdges.DISCARD_EXCESS && degenerateBoundaries == DegenerateBoundaries.KEEP);
        Preconditions.checkState(this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.REQUIRE || this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.CREATE);
        Preconditions.checkState(this.options.edgeType() == S2Builder.EdgeType.DIRECTED);
        siblingMap = this.getSiblingMap();
        leftTurnMap = new int[this.numEdges()];
        if (!this.fillLeftTurnMap(siblingMap, leftTurnMap, error)) {
            return false;
        }
        minInputEdgeIds = this.getMinInputEdgeIds();
        frontier = IntVector.empty();
        pathIndex = new int[this.numEdges()];
        if (degenerateBoundaries == DegenerateBoundaries.DISCARD) {
            Arrays.fill(pathIndex, -1);
        }
        for (startEdgeId = 0; startEdgeId < this.numEdges(); ++startEdgeId) {
            if (leftTurnMap[startEdgeId] < 0) continue;
            component = new DirectedComponent();
            frontier.push(startEdgeId);
            while (!frontier.isEmpty()) {
                edgeId = frontier.pop();
                if (leftTurnMap[edgeId] < 0) continue;
                path = IntVector.empty();
                nextEdgeId = 0;
                while (leftTurnMap[edgeId] >= 0) {
                    block13: {
                        path.push(edgeId);
                        nextEdgeId = leftTurnMap[edgeId];
                        leftTurnMap[edgeId] = -1;
                        siblingEdgeId = siblingMap.get(edgeId);
                        if (leftTurnMap[siblingEdgeId] >= 0) {
                            frontier.push(siblingEdgeId);
                        }
                        if (degenerateBoundaries != DegenerateBoundaries.DISCARD) ** GOTO lbl44
                        pathIndex[edgeId] = path.size() - 1;
                        siblingIndex = pathIndex[siblingEdgeId];
                        if (siblingIndex < 0) break block13;
                        if (siblingIndex == path.size() - 2) {
                            path.truncate(siblingIndex);
                        } else {
                            loop = path.subList(siblingIndex + 1, path.size() - 2).toArray();
                            path.truncate(siblingIndex);
                            for (int loopEdgeId : loop) {
                                pathIndex[loopEdgeId] = -1;
                            }
                            S2BuilderGraph.canonicalizeLoopOrder(minInputEdgeIds, loop);
                            component.add(loop);
lbl44:
                            // 2 sources

                            edgeId = nextEdgeId;
                        }
                    }
                    edgeId = nextEdgeId;
                }
                if (degenerateBoundaries == DegenerateBoundaries.DISCARD) {
                    path.forEach((Ints.IntConsumer)LambdaMetafactory.metafactory(null, null, null, (I)V, lambda$getDirectedComponents$2(int[] int ), (I)V)((int[])pathIndex));
                }
                loop = path.toArray();
                S2BuilderGraph.canonicalizeLoopOrder(minInputEdgeIds, loop);
                component.add(loop);
            }
            S2BuilderGraph.canonicalizeEdgeChainOrder(minInputEdgeIds, component);
            outputComponents.add(component);
        }
        S2BuilderGraph.canonicalizeDirectedComponentOrder(minInputEdgeIds, outputComponents);
        return true;
    }

    private static int markEdgeUsed(int slot) {
        return -1 - slot;
    }

    public boolean getUndirectedComponents(LoopType loopType, List<UndirectedComponent> outputComponents, S2Error error) {
        Preconditions.checkState(this.options.degenerateEdges() == S2Builder.GraphOptions.DegenerateEdges.DISCARD || this.options.degenerateEdges() == S2Builder.GraphOptions.DegenerateEdges.DISCARD_EXCESS);
        Preconditions.checkState(this.options.edgeType() == S2Builder.EdgeType.UNDIRECTED);
        IntVector siblingMap = this.getInEdgeIds();
        int[] leftTurnMap = new int[this.numEdges()];
        if (!this.fillLeftTurnMap(siblingMap, leftTurnMap, error)) {
            return false;
        }
        this.makeSiblingMap(siblingMap);
        IntVector minInputEdgeIds = this.getMinInputEdgeIds();
        IntPairVector frontier = new IntPairVector();
        int[] pathIndex = new int[this.numVertices()];
        if (loopType == LoopType.SIMPLE) {
            Arrays.fill(pathIndex, -1);
        }
        for (int minStartEdgeId = 0; minStartEdgeId < this.numEdges(); ++minStartEdgeId) {
            if (leftTurnMap[minStartEdgeId] < 0) continue;
            UndirectedComponent component = new UndirectedComponent();
            frontier.pushPair(minStartEdgeId, 0);
            while (!frontier.isEmpty()) {
                int startEdgeId = frontier.peekFirst();
                int slot = frontier.peekSecond();
                frontier.pop();
                if (leftTurnMap[startEdgeId] < 0) continue;
                IntVector path = IntVector.empty();
                int edgeId = startEdgeId;
                while (leftTurnMap[edgeId] >= 0) {
                    path.push(edgeId);
                    int nextEdgeId = leftTurnMap[edgeId];
                    leftTurnMap[edgeId] = S2BuilderGraph.markEdgeUsed(slot);
                    int siblingEdgeId = siblingMap.get(edgeId);
                    if (leftTurnMap[siblingEdgeId] >= 0) {
                        frontier.pushPair(siblingEdgeId, 1 - slot);
                    } else if (leftTurnMap[siblingEdgeId] != S2BuilderGraph.markEdgeUsed(1 - slot)) {
                        error.init(S2Error.Code.BUILDER_EDGES_DO_NOT_FORM_LOOPS, "Given undirected edges do not form loops", new Object[0]);
                        return false;
                    }
                    if (loopType == LoopType.SIMPLE) {
                        pathIndex[this.edgeSrcId((int)edgeId)] = path.size() - 1;
                        int loopStart = pathIndex[this.edgeDstId(edgeId)];
                        if (loopStart >= 0) {
                            int[] loop = path.subList(loopStart, path.size()).toArray();
                            path.truncate(loopStart);
                            for (int loopEdgeId : loop) {
                                pathIndex[this.edgeSrcId((int)loopEdgeId)] = -1;
                            }
                            S2BuilderGraph.canonicalizeLoopOrder(minInputEdgeIds, loop);
                            component.addEdgeLoop(slot, loop);
                        }
                    }
                    edgeId = nextEdgeId;
                }
                if (loopType == LoopType.SIMPLE) {
                    Preconditions.checkState(path.isEmpty());
                    continue;
                }
                int[] loop = path.toArray();
                S2BuilderGraph.canonicalizeLoopOrder(minInputEdgeIds, loop);
                component.addEdgeLoop(slot, loop);
            }
            S2BuilderGraph.canonicalizeEdgeChainOrder(minInputEdgeIds, component.getComplement(0));
            S2BuilderGraph.canonicalizeEdgeChainOrder(minInputEdgeIds, component.getComplement(1));
            if (minInputEdgeIds.get(component.getComplement(0).get(0)[0]) > minInputEdgeIds.get(component.getComplement(1).get(0)[0])) {
                component.swapComplements();
            }
            outputComponents.add(component);
        }
        Collections.sort(outputComponents, new UndirectedComponentComparator(minInputEdgeIds));
        return true;
    }

    public S2BuilderGraph makeSubgraph(S2Builder.GraphOptions newOptions, EdgeList newEdges, IntVector newInputEdgeIdSetIds, IdSetLexicon newInputEdgeIdSetLexicon, S2Builder.IsFullPolygonPredicate isFullPolygonPredicate, S2Error error) {
        if (this.options().edgeType() == S2Builder.EdgeType.DIRECTED && newOptions.edgeType() == S2Builder.EdgeType.UNDIRECTED) {
            int n = newEdges.size();
            newEdges.ensureCapacity(2 * n);
            newInputEdgeIdSetIds.ensureCapacity(2 * n);
            for (int i = 0; i < n; ++i) {
                newEdges.add(newEdges.getDstId(i), newEdges.getSrcId(i));
                newInputEdgeIdSetIds.push(Integer.MIN_VALUE);
            }
        }
        S2BuilderGraph.processEdges(newOptions, newEdges, newInputEdgeIdSetIds, newInputEdgeIdSetLexicon, error);
        return new S2BuilderGraph(newOptions, this.vertices, newEdges, newInputEdgeIdSetIds, newInputEdgeIdSetLexicon, this.labelSetIds, this.labelSetLexicon, isFullPolygonPredicate);
    }

    public static void processEdges(S2Builder.GraphOptions options, EdgeList edges, IntVector inputIds, IdSetLexicon idSetLexicon, S2Error error) {
        EdgeProcessor processor = new EdgeProcessor(options, edges, inputIds, idSetLexicon);
        processor.run(error);
        if (options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.REQUIRE || options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.CREATE) {
            options.setEdgeType(S2Builder.EdgeType.DIRECTED);
        }
    }

    public static ArrayList<S2Point> filterVertices(List<S2Point> vertices, EdgeList edges, IntVector vmap, IntVector usedVertexIds) {
        usedVertexIds.clear();
        usedVertexIds.ensureCapacity(2 * edges.size());
        int lastDstId = -1;
        for (int e = 0; e < edges.size(); ++e) {
            int edgeSrcId = edges.getSrcId(e);
            if (edgeSrcId != lastDstId) {
                usedVertexIds.add(edgeSrcId);
            }
            lastDstId = edges.getDstId(e);
            usedVertexIds.add(lastDstId);
        }
        usedVertexIds.sort();
        usedVertexIds.unique();
        vmap.resize(vertices.size());
        ArrayList<S2Point> newVertices = new ArrayList<S2Point>(usedVertexIds.size());
        for (int i = 0; i < usedVertexIds.size(); ++i) {
            newVertices.add(vertices.get(usedVertexIds.get(i)));
            vmap.set(usedVertexIds.get(i), i);
        }
        for (int e = 0; e < edges.size(); ++e) {
            edges.set(e, vmap.get(edges.getSrcId(e)), vmap.get(edges.getDstId(e)));
        }
        return newVertices;
    }

    private static Ints.IntComparator srcVertexEdgeComparator(EdgeList edges) {
        return (edgeIdA, edgeIdB) -> {
            int dstVertexIdB;
            int srcVertexIdB;
            int srcVertexIdA = edges.getSrcId(edgeIdA);
            if (srcVertexIdA != (srcVertexIdB = edges.getSrcId(edgeIdB))) {
                return Integer.compare(srcVertexIdA, srcVertexIdB);
            }
            int dstVertexIdA = edges.getDstId(edgeIdA);
            if (dstVertexIdA != (dstVertexIdB = edges.getDstId(edgeIdB))) {
                return Integer.compare(dstVertexIdA, dstVertexIdB);
            }
            return Integer.compare(edgeIdA, edgeIdB);
        };
    }

    private static Ints.IntComparator dstVertexEdgeComparator(EdgeList edges) {
        return (edgeIdA, edgeIdB) -> {
            int srcVertexIdB;
            int dstVertexIdB;
            int dstVertexIdA = edges.getDstId(edgeIdA);
            if (dstVertexIdA != (dstVertexIdB = edges.getDstId(edgeIdB))) {
                return Integer.compare(dstVertexIdA, dstVertexIdB);
            }
            int srcVertexIdA = edges.getSrcId(edgeIdA);
            if (srcVertexIdA != (srcVertexIdB = edges.getSrcId(edgeIdB))) {
                return Integer.compare(srcVertexIdA, srcVertexIdB);
            }
            return Integer.compare(edgeIdA, edgeIdB);
        };
    }

    private static void addVertexEdges(int outBeginEdgeId, int outEndEdgeId, int inBeginEdgeId, int inEndEdgeId, int v1, VertexEdgeList v0Edges) {
        int rank = 0;
        while (inEndEdgeId - inBeginEdgeId > outEndEdgeId - outBeginEdgeId) {
            v0Edges.add(true, --inEndEdgeId, v1, rank++);
        }
        while (inEndEdgeId > inBeginEdgeId) {
            v0Edges.add(false, outBeginEdgeId++, v1, rank++);
            v0Edges.add(true, --inEndEdgeId, v1, rank++);
        }
        while (outEndEdgeId > outBeginEdgeId) {
            v0Edges.add(false, outBeginEdgeId++, v1, rank++);
        }
    }

    private static Ints.IntComparator edgeIdComparatorByMinInputEdgeId(Ints.IntList minInputEdgeIdsPerEdgeId) {
        return (leftEdgeId, rightEdgeId) -> {
            if (minInputEdgeIdsPerEdgeId.get(leftEdgeId) < minInputEdgeIdsPerEdgeId.get(rightEdgeId)) {
                return -1;
            }
            if (minInputEdgeIdsPerEdgeId.get(leftEdgeId) > minInputEdgeIdsPerEdgeId.get(rightEdgeId)) {
                return 1;
            }
            return Integer.compare(leftEdgeId, rightEdgeId);
        };
    }

    private static /* synthetic */ void lambda$getDirectedComponents$2(int[] pathIndex, int pathEdgeId) {
        pathIndex[pathEdgeId] = -1;
    }

    private static class EdgeProcessor {
        private final S2Builder.GraphOptions options;
        private EdgeList edges;
        private final IntVector inputIds;
        private final IdSetLexicon idSetLexicon;
        private final IntVector outEdges;
        private final IntVector inEdges;
        private final EdgeList newEdges;
        private final IntVector newInputIds;

        public EdgeProcessor(S2Builder.GraphOptions options, EdgeList edges, IntVector inputIds, IdSetLexicon idSetLexicon) {
            this.options = new S2Builder.GraphOptions(options);
            this.edges = edges;
            this.inputIds = inputIds;
            this.idSetLexicon = idSetLexicon;
            this.outEdges = IntVector.ofSize(edges.size());
            this.outEdges.fillConsecutive();
            IntSorter.sort(S2BuilderGraph.srcVertexEdgeComparator(edges), this.outEdges);
            this.inEdges = IntVector.ofSize(edges.size());
            this.inEdges.fillConsecutive();
            IntSorter.sort(S2BuilderGraph.dstVertexEdgeComparator(edges), this.inEdges);
            this.newEdges = new EdgeList();
            this.newEdges.ensureCapacity(edges.size());
            this.newInputIds = new IntVector();
            this.newInputIds.ensureCapacity(edges.size());
        }

        public void run(S2Error error) {
            int numEdges = this.edges.size();
            if (numEdges == 0) {
                return;
            }
            int out = 0;
            int in = 0;
            Edge outEdge = new Edge();
            this.edges.get(this.outEdges.get(out), outEdge);
            Edge reverseInEdge = new Edge();
            this.edges.getReverse(this.inEdges.get(in), reverseInEdge);
            Edge minEdge = new Edge();
            while (true) {
                if (EdgeList.compareEdges(outEdge, reverseInEdge) < 0) {
                    minEdge.set(outEdge);
                } else {
                    minEdge.set(reverseInEdge);
                }
                if (minEdge.isSentinel()) break;
                int outBegin = out;
                int inBegin = in;
                while (outEdge.isEqualTo(minEdge)) {
                    if (++out == numEdges) {
                        outEdge.setSentinel();
                        continue;
                    }
                    this.edges.get(this.outEdges.get(out), outEdge);
                }
                while (reverseInEdge.isEqualTo(minEdge)) {
                    if (++in == numEdges) {
                        reverseInEdge.setSentinel();
                        continue;
                    }
                    this.edges.getReverse(this.inEdges.get(in), reverseInEdge);
                }
                int nOut = out - outBegin;
                int nIn = in - inBegin;
                if (minEdge.srcId == minEdge.dstId) {
                    boolean merge;
                    Preconditions.checkState(nOut == nIn);
                    if (this.options.degenerateEdges() == S2Builder.GraphOptions.DegenerateEdges.DISCARD || this.options.degenerateEdges() == S2Builder.GraphOptions.DegenerateEdges.DISCARD_EXCESS && (outBegin > 0 && this.edges.getSrcId(this.outEdges.get(outBegin - 1)) == minEdge.srcId || out < numEdges && this.edges.getSrcId(this.outEdges.get(out)) == minEdge.srcId || inBegin > 0 && this.edges.getDstId(this.inEdges.get(inBegin - 1)) == minEdge.srcId || in < numEdges && this.edges.getDstId(this.inEdges.get(in)) == minEdge.srcId)) continue;
                    boolean bl = merge = this.options.duplicateEdges() == S2Builder.GraphOptions.DuplicateEdges.MERGE || this.options.degenerateEdges() == S2Builder.GraphOptions.DegenerateEdges.DISCARD_EXCESS;
                    if (this.options.edgeType() == S2Builder.EdgeType.UNDIRECTED && (this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.REQUIRE || this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.CREATE)) {
                        Preconditions.checkState((nOut & 1) == 0);
                        this.addEdgeCopies(merge ? 1 : nOut / 2, minEdge, this.mergeInputIds(outBegin, out));
                        continue;
                    }
                    if (merge) {
                        this.addEdgeCopies(this.options.edgeType() == S2Builder.EdgeType.UNDIRECTED ? 2 : 1, minEdge, this.mergeInputIds(outBegin, out));
                        continue;
                    }
                    if (this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.DISCARD || this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.DISCARD_EXCESS) {
                        this.addEdgeCopies(nOut, minEdge, this.mergeInputIds(outBegin, out));
                        continue;
                    }
                    this.copyEdges(outBegin, out);
                    continue;
                }
                if (this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.KEEP) {
                    if (nOut > 1 && this.options.duplicateEdges() == S2Builder.GraphOptions.DuplicateEdges.MERGE) {
                        this.addEdge(minEdge, this.mergeInputIds(outBegin, out));
                        continue;
                    }
                    this.copyEdges(outBegin, out);
                    continue;
                }
                if (this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.DISCARD) {
                    if (this.options.edgeType() == S2Builder.EdgeType.DIRECTED) {
                        if (nOut <= nIn) continue;
                        this.addEdgeCopies(this.options.duplicateEdges() == S2Builder.GraphOptions.DuplicateEdges.MERGE ? 1 : nOut - nIn, minEdge, this.mergeInputIds(outBegin, out));
                        continue;
                    }
                    if ((nOut & 1) == 0) continue;
                    this.addEdge(minEdge, this.mergeInputIds(outBegin, out));
                    continue;
                }
                if (this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.DISCARD_EXCESS) {
                    if (this.options.edgeType() == S2Builder.EdgeType.DIRECTED) {
                        if (nOut < nIn) continue;
                        this.addEdgeCopies(this.options.duplicateEdges() == S2Builder.GraphOptions.DuplicateEdges.MERGE ? 1 : Math.max(1, nOut - nIn), minEdge, this.mergeInputIds(outBegin, out));
                        continue;
                    }
                    this.addEdgeCopies((nOut & 1) == 1 ? 1 : 2, minEdge, this.mergeInputIds(outBegin, out));
                    continue;
                }
                Preconditions.checkState(this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.REQUIRE || this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.CREATE);
                if (error.ok() && this.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.REQUIRE && (this.options.edgeType() == S2Builder.EdgeType.DIRECTED ? nOut != nIn : (nOut & 1) != 0)) {
                    error.init(S2Error.Code.BUILDER_MISSING_EXPECTED_SIBLING_EDGES, "Expected all input edges to have siblings, but some were missing", new Object[0]);
                }
                if (this.options.duplicateEdges() == S2Builder.GraphOptions.DuplicateEdges.MERGE) {
                    this.addEdge(minEdge, this.mergeInputIds(outBegin, out));
                    continue;
                }
                if (this.options.edgeType() == S2Builder.EdgeType.UNDIRECTED) {
                    this.addEdgeCopies((nOut + 1) / 2, minEdge, this.mergeInputIds(outBegin, out));
                    continue;
                }
                this.copyEdges(outBegin, out);
                if (nIn <= nOut) continue;
                this.addEdgeCopies(nIn - nOut, minEdge, Integer.MIN_VALUE);
            }
            this.edges.swap(this.newEdges);
            this.inputIds.swap(this.newInputIds);
        }

        private void addEdge(Edge newEdge, int inputEdgeIdSetId) {
            this.newEdges.add(newEdge.srcId, newEdge.dstId);
            this.newInputIds.add(inputEdgeIdSetId);
        }

        private void addEdgeCopies(int numEdges, Edge newEdge, int inputEdgeIdSetId) {
            for (int i = 0; i < numEdges; ++i) {
                this.newEdges.add(newEdge.srcId, newEdge.dstId);
                this.newInputIds.add(inputEdgeIdSetId);
            }
        }

        private void copyEdges(int outBegin, int outEnd) {
            for (int i = outBegin; i < outEnd; ++i) {
                int outEdge = this.outEdges.get(i);
                this.newEdges.add(this.edges.getSrcId(outEdge), this.edges.getDstId(outEdge));
                this.newInputIds.add(this.inputIds.get(outEdge));
            }
        }

        private int mergeInputIds(int outBegin, int outEnd) {
            if (outEnd - outBegin == 1) {
                return this.inputIds.get(this.outEdges.get(outBegin));
            }
            IntVector tmpIds = new IntVector();
            for (int i = outBegin; i < outEnd; ++i) {
                this.idSetLexicon.idSet(this.inputIds.get(this.outEdges.get(i))).forEach(id -> tmpIds.add(id));
            }
            return this.idSetLexicon.add(tmpIds);
        }
    }

    public static class LabelFetcher {
        private S2BuilderGraph graph;
        private S2Builder.EdgeType edgeType;
        private Ints.IntList siblingMap;

        public LabelFetcher() {
        }

        public LabelFetcher(S2BuilderGraph graph, S2Builder.EdgeType edgeType) {
            this.init(graph, edgeType);
        }

        public void init(S2BuilderGraph graph, S2Builder.EdgeType edgeType) {
            this.graph = graph;
            this.edgeType = edgeType;
            if (edgeType == S2Builder.EdgeType.UNDIRECTED) {
                this.siblingMap = graph.getSiblingMap();
            }
        }

        private void addInputEdgeLabels(int edgeId, IntVector outLabels) {
            this.graph.inputEdgeIds(edgeId).forEach(inputEdgeId -> outLabels.addAll(this.graph.labels(inputEdgeId)));
        }

        public void fetch(int edgeId, IntVector outLabels) {
            outLabels.clear();
            this.addInputEdgeLabels(edgeId, outLabels);
            if (this.edgeType == S2Builder.EdgeType.UNDIRECTED) {
                this.addInputEdgeLabels(this.siblingMap.get(edgeId), outLabels);
            }
            if (outLabels.size() > 1) {
                outLabels.sort();
                outLabels.unique();
            }
        }
    }

    public static enum PolylineType {
        PATH,
        WALK;

    }

    public static class UndirectedComponent {
        private ArrayList<int[]> comp0 = new ArrayList();
        private ArrayList<int[]> comp1 = new ArrayList();

        public void addEdgeLoop(int slot, int[] edgeLoop) {
            if (slot == 0) {
                this.comp0.add(edgeLoop);
            } else {
                this.comp1.add(edgeLoop);
            }
        }

        public ArrayList<int[]> getComplement(int slot) {
            return slot == 0 ? this.comp0 : this.comp1;
        }

        public void swapComplements() {
            ArrayList<int[]> tmp = this.comp0;
            this.comp0 = this.comp1;
            this.comp1 = tmp;
        }
    }

    public static class DirectedComponent
    extends ArrayList<int[]> {
    }

    public static enum DegenerateBoundaries {
        DISCARD,
        KEEP;

    }

    public static enum LoopType {
        SIMPLE,
        CIRCUIT;

    }

    public static class VertexInMap {
        private final Ints.IntList inEdgeIds;
        private final IntVector inEdgeBegins = new IntVector();

        public VertexInMap(S2BuilderGraph graph) {
            this.inEdgeIds = graph.getInEdgeIds();
            this.inEdgeBegins.resize(graph.numVertices() + 1);
            int edgeId = 0;
            for (int vertexId = 0; vertexId <= graph.numVertices(); ++vertexId) {
                while (edgeId < graph.numEdges() && graph.edgeDstId(this.inEdgeIds.get(edgeId)) < vertexId) {
                    ++edgeId;
                }
                this.inEdgeBegins.set(vertexId, edgeId);
            }
        }

        public int inDegree(int vertexId) {
            return this.edgeIds(vertexId).size();
        }

        public VertexInEdgeIds edgeIds(int vertexId) {
            return new VertexInEdgeIds(this.inEdgeIds, this.inEdgeBegins.get(vertexId), this.inEdgeBegins.get(vertexId + 1));
        }

        public Ints.IntList inEdgeIds() {
            return this.inEdgeIds;
        }
    }

    public static class VertexInEdgeIds
    implements Ints.IntSequence {
        private final Ints.IntList inEdgeIds;
        private final int beginIndex;
        private final int endIndex;

        private VertexInEdgeIds(Ints.IntList inEdgeIds, int begin, int end) {
            this.inEdgeIds = inEdgeIds;
            this.beginIndex = begin;
            this.endIndex = end;
        }

        @Override
        public int size() {
            return this.endIndex - this.beginIndex;
        }

        @Override
        public Ints.OfInt intIterator() {
            return new Ints.OfInt(){
                int position;
                {
                    this.position = beginIndex;
                }

                @Override
                public boolean hasNext() {
                    return this.position < endIndex;
                }

                @Override
                public int nextInt() {
                    return inEdgeIds.get(this.position++);
                }

                public void reset() {
                    this.position = beginIndex;
                }
            };
        }

        @Override
        public void forEach(Ints.IntConsumer action) {
            for (int i = this.beginIndex; i < this.endIndex; ++i) {
                action.accept(this.inEdgeIds.get(i));
            }
        }

        @Override
        public void forEach(Ints.IntBiConsumer action) {
            for (int i = this.beginIndex; i < this.endIndex; ++i) {
                action.accept(i - this.beginIndex, this.inEdgeIds.get(i));
            }
        }
    }

    public static class VertexOutMap {
        private EdgeList edges;
        private final IntVector edgeBegins = new IntVector();

        public VertexOutMap(S2BuilderGraph graph) {
            this.init(graph);
        }

        public void init(S2BuilderGraph graph) {
            this.edges = graph.edges();
            this.edgeBegins.resize(graph.numVertices() + 1);
            this.edgeBegins.fill(-1);
            int edgeId = 0;
            for (int vertexId = 0; vertexId <= graph.numVertices(); ++vertexId) {
                while (edgeId < graph.numEdges() && graph.edges().getSrcId(edgeId) < vertexId) {
                    ++edgeId;
                }
                this.edgeBegins.set(vertexId, edgeId);
            }
        }

        public int outDegree(int vertexId) {
            int beginEdgeId = this.edgeBegins.get(vertexId);
            int endEdgeId = this.edgeBegins.get(vertexId + 1);
            return endEdgeId - beginEdgeId;
        }

        public VertexOutEdges edges(int vertexId) {
            return new VertexOutEdges(this.edges, this.edgeBegins.get(vertexId), this.edgeBegins.get(vertexId + 1));
        }

        public VertexOutEdgeIds edgeIds(int vertexId) {
            return new VertexOutEdgeIds(this.edgeBegins.get(vertexId), this.edgeBegins.get(vertexId + 1));
        }

        public VertexOutEdgeIds edgeIds(int srcVertexId, int dstVertexId) {
            int last;
            int begin;
            int end = this.edgeBegins.get(srcVertexId + 1);
            for (begin = this.edgeBegins.get(srcVertexId); begin < end && this.edges.getDstId(begin) < dstVertexId; ++begin) {
            }
            if (begin == end || this.edges.getDstId(begin) > dstVertexId) {
                return new VertexOutEdgeIds(begin, begin);
            }
            for (last = begin; last < end && this.edges.getDstId(last) == dstVertexId; ++last) {
            }
            return new VertexOutEdgeIds(begin, last);
        }
    }

    public static class VertexOutEdgeIds
    implements Ints.IntSequence {
        private final int beginEdgeId;
        private final int endEdgeId;

        VertexOutEdgeIds(int beginEdgeId, int endEdgeId) {
            this.beginEdgeId = beginEdgeId;
            this.endEdgeId = endEdgeId;
        }

        @Override
        public int size() {
            return this.endEdgeId - this.beginEdgeId;
        }

        public int begin() {
            return this.beginEdgeId;
        }

        public int end() {
            return this.endEdgeId;
        }

        @Override
        public Ints.OfInt intIterator() {
            return new Ints.OfInt(){
                int next;
                {
                    this.next = beginEdgeId;
                }

                @Override
                public boolean hasNext() {
                    return this.next < endEdgeId;
                }

                @Override
                public int nextInt() {
                    int n = this.next++;
                    return n;
                }

                public void reset() {
                    this.next = beginEdgeId;
                }
            };
        }

        @Override
        public void forEach(Ints.IntConsumer action) {
            for (int i = this.beginEdgeId; i < this.endEdgeId; ++i) {
                action.accept(i);
            }
        }

        @Override
        public void forEach(Ints.IntBiConsumer action) {
            for (int i = this.beginEdgeId; i < this.endEdgeId; ++i) {
                action.accept(i - this.beginEdgeId, i);
            }
        }
    }

    public static class VertexOutEdges {
        private final EdgeList edges;
        private int begin;
        private int end;

        VertexOutEdges(EdgeList edges, int begin, int end) {
            Preconditions.checkArgument(begin >= 0, "begin: %s", begin);
            Preconditions.checkArgument(end >= begin, "end: %s, begin: %s", end, begin);
            Preconditions.checkArgument(end <= edges.size(), "end: %s, edges.size(): %s", end, edges.size());
            this.edges = edges;
            this.begin = begin;
            this.end = end;
        }

        public int size() {
            return this.end - this.begin;
        }

        public int getSrcId(int index) {
            Preconditions.checkArgument(index >= 0 && index < this.size());
            return this.edges.getSrcId(this.begin + index);
        }

        public int getDstId(int index) {
            Preconditions.checkArgument(index >= 0 && index < this.size());
            return this.edges.getDstId(this.begin + index);
        }

        public void get(int index, Edge edge) {
            Preconditions.checkArgument(index >= 0 && index < this.size());
            edge.set(this.edges.getSrcId(this.begin + index), this.edges.getDstId(this.begin + index));
        }

        public void getReverse(int index, Edge edge) {
            Preconditions.checkArgument(index >= 0 && index < this.size());
            edge.set(this.edges.getDstId(this.begin + index), this.edges.getSrcId(this.begin + index));
        }
    }

    public static class VertexEdgeList
    implements Sorter.SortableCollection {
        private final IntVector incomings = new IntVector();
        private final IntVector indexEdgeIds = new IntVector();
        private final IntVector endpointVertexIds = new IntVector();
        private final IntVector ranks = new IntVector();
        private int v0;
        private int minEndpointVertexId;
        private final List<S2Point> vertices;

        public VertexEdgeList(List<S2Point> vertices) {
            this.vertices = vertices;
        }

        @Override
        public int size() {
            return this.incomings.size();
        }

        @Override
        public void truncate(int start) {
            this.incomings.truncate(start);
            this.indexEdgeIds.truncate(start);
            this.endpointVertexIds.truncate(start);
            this.ranks.truncate(start);
        }

        public boolean isEmpty() {
            return this.incomings.isEmpty();
        }

        public void clear() {
            this.incomings.clear();
            this.indexEdgeIds.clear();
            this.endpointVertexIds.clear();
            this.ranks.clear();
        }

        public boolean incoming(int index) {
            return this.incomings.get(index) == 1;
        }

        public int indexEdgeId(int index) {
            return this.indexEdgeIds.get(index);
        }

        public int endpointVertexId(int index) {
            return this.endpointVertexIds.get(index);
        }

        public int rank(int index) {
            return this.ranks.get(index);
        }

        public void add(boolean incoming, int indexEdgeId, int endpointVertexId, int rank) {
            this.incomings.add(incoming ? 1 : 0);
            this.indexEdgeIds.add(indexEdgeId);
            this.endpointVertexIds.add(endpointVertexId);
            this.ranks.add(rank);
        }

        public void sortClockwiseAround(int v0) {
            this.v0 = v0;
            this.minEndpointVertexId = this.endpointVertexIds.get(0);
            Sorter.sort(this, 1, this.incomings.size() - 1);
        }

        @Override
        public void swap(int a, int b) {
            this.incomings.swap(a, b);
            this.indexEdgeIds.swap(a, b);
            this.endpointVertexIds.swap(a, b);
            this.ranks.swap(a, b);
        }

        @Override
        public boolean less(int a, int b) {
            if (this.endpointVertexIds.get(a) == this.endpointVertexIds.get(b)) {
                return this.ranks.get(a) < this.ranks.get(b);
            }
            if (this.endpointVertexIds.get(a) == this.minEndpointVertexId) {
                return true;
            }
            if (this.endpointVertexIds.get(b) == this.minEndpointVertexId) {
                return false;
            }
            return !S2Predicates.orderedCCW(this.vertices.get(this.endpointVertexIds.get(a)), this.vertices.get(this.endpointVertexIds.get(b)), this.vertices.get(this.minEndpointVertexId), this.vertices.get(this.v0));
        }
    }

    public static class EdgeList
    extends IntPairVector {
        public EdgeList() {
        }

        public EdgeList(EdgeList other) {
            super(other);
        }

        public static EdgeList of(Edge ... edges) {
            EdgeList list = new EdgeList();
            for (Edge e : edges) {
                list.add(e);
            }
            return list;
        }

        public static int compareEdges(Edge left, Edge right) {
            if (left.srcId == right.srcId) {
                return Integer.compare(left.dstId, right.dstId);
            }
            return Integer.compare(left.srcId, right.srcId);
        }

        public static int compareEdges(int leftSrcId, int leftDstId, int rightSrcId, int rightDstId) {
            if (leftSrcId == rightSrcId) {
                return Integer.compare(leftDstId, rightDstId);
            }
            return Integer.compare(leftSrcId, rightSrcId);
        }

        public void add(Edge e) {
            this.add(e.srcId, e.dstId);
        }

        public void copyEdge(EdgeList other, int index) {
            this.add(other.getSrcId(index), other.getDstId(index));
        }

        public int getSrcId(int index) {
            return this.getFirst(index);
        }

        public int getDstId(int index) {
            return this.getSecond(index);
        }

        public void get(int index, Edge edge) {
            edge.set(this.getFirst(index), this.getSecond(index));
        }

        public void getReverse(int index, Edge edge) {
            edge.set(this.getSecond(index), this.getFirst(index));
        }

        public void set(int index, int srcId, int dstId) {
            this.setPair(index, srcId, dstId);
        }

        public boolean containsSibling(int index) {
            return this.contains(this.getDstId(index), this.getSrcId(index));
        }
    }

    public static class Edge {
        int srcId;
        int dstId;

        public static Edge of(int srcId, int dstId) {
            Edge e = new Edge();
            e.srcId = srcId;
            e.dstId = dstId;
            return e;
        }

        public void set(int src, int dst) {
            this.srcId = src;
            this.dstId = dst;
        }

        public void set(Edge other) {
            this.srcId = other.srcId;
            this.dstId = other.dstId;
        }

        public void setSentinel() {
            this.srcId = Integer.MAX_VALUE;
            this.dstId = Integer.MAX_VALUE;
        }

        public boolean isSentinel() {
            return this.srcId == Integer.MAX_VALUE && this.dstId == Integer.MAX_VALUE;
        }

        public boolean isLessThan(Edge other) {
            if (this.srcId == other.srcId) {
                return this.dstId < other.dstId;
            }
            return this.srcId < other.srcId;
        }

        public boolean isEqualTo(Edge other) {
            return this.srcId == other.srcId && this.dstId == other.dstId;
        }

        public boolean equals(Object o) {
            return o instanceof Edge && this.isEqualTo((Edge)o);
        }

        public int hashCode() {
            return this.srcId * 39119 + this.dstId;
        }
    }

    public static final class PolylineBuilder {
        private S2BuilderGraph graph;
        private VertexInMap inMap;
        private VertexOutMap outMap;
        private IntVector siblingMap = null;
        private final IntVector minInputEdgeIds = new IntVector();
        private boolean directed;
        private int edgesLeft;
        private boolean[] used;
        private int[] excessUsed;

        public void init(S2BuilderGraph graph) {
            Preconditions.checkNotNull(graph);
            Preconditions.checkState(graph.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.DISCARD || graph.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.DISCARD_EXCESS || graph.options.siblingPairs() == S2Builder.GraphOptions.SiblingPairs.KEEP);
            this.graph = graph;
            this.inMap = new VertexInMap(graph);
            this.outMap = new VertexOutMap(graph);
            graph.fillMinInputEdgeIds(this.minInputEdgeIds);
            this.directed = graph.options().edgeType() == S2Builder.EdgeType.DIRECTED;
            this.edgesLeft = graph.numEdges() / (this.directed ? 1 : 2);
            this.used = new boolean[graph.numEdges()];
            Arrays.fill(this.used, false);
            this.excessUsed = new int[graph.numVertices()];
            if (!this.directed) {
                if (this.siblingMap == null) {
                    this.siblingMap = IntVector.copyOf(this.inMap.inEdgeIds);
                } else {
                    this.siblingMap.copy(this.inMap.inEdgeIds);
                }
                graph.makeSiblingMap(this.siblingMap);
            } else if (this.siblingMap != null) {
                this.siblingMap.clear();
            }
        }

        public List<int[]> buildPaths() {
            ArrayList<int[]> polylines = new ArrayList<int[]>();
            IntVector edges = this.graph.getInputEdgeOrder(this.minInputEdgeIds);
            IntVector polyline = new IntVector();
            edges.forEach(edgeId -> {
                if (!this.used[edgeId] && !this.isInterior(this.graph.edgeSrcId(edgeId))) {
                    this.fillPath(edgeId, polyline);
                    polylines.add(polyline.toArray());
                }
            });
            Ints.OfInt edgeIter = edges.intIterator();
            while (this.edgesLeft > 0 && edgeIter.hasNext()) {
                int edgeId2 = edgeIter.nextInt();
                if (this.used[edgeId2]) continue;
                this.fillPath(edgeId2, polyline);
                int[] path = polyline.toArray();
                S2BuilderGraph.canonicalizeLoopOrder(this.minInputEdgeIds, path);
                polylines.add(path);
            }
            Preconditions.checkState(this.edgesLeft == 0);
            S2BuilderGraph.canonicalizeEdgeChainOrder(this.minInputEdgeIds, polylines);
            return polylines;
        }

        public List<int[]> buildWalks() {
            ArrayList<IntVector> polylines = new ArrayList<IntVector>();
            IntVector edges = this.graph.getInputEdgeOrder(this.minInputEdgeIds);
            Ints.OfInt edgeIter = edges.intIterator();
            while (edgeIter.hasNext()) {
                int vertexId;
                int excess;
                int edgeId = edgeIter.nextInt();
                if (this.used[edgeId] || (excess = this.excessDegree(vertexId = this.graph.edgeSrcId(edgeId))) <= 0) continue;
                if (this.directed ? excess <= 0 : (excess -= this.excessUsed[vertexId]) % 2 == 0) continue;
                IntVector polyline = new IntVector();
                int n = vertexId;
                this.excessUsed[n] = this.excessUsed[n] + 1;
                this.fillWalk(vertexId, polyline);
                polylines.add(polyline);
                int n2 = this.graph.edgeDstId(polyline.peek());
                this.excessUsed[n2] = this.excessUsed[n2] - 1;
            }
            if (this.edgesLeft > 0) {
                for (IntVector polyline : polylines) {
                    this.maximizeWalk(polyline);
                }
            }
            ArrayList<int[]> walks = new ArrayList<int[]>();
            for (IntVector polyline : polylines) {
                walks.add(polyline.toArray());
            }
            polylines.clear();
            IntVector polyline = new IntVector();
            for (int i = 0; i < edges.size() && this.edgesLeft > 0; ++i) {
                int edgeId = edges.get(i);
                if (this.used[edgeId]) continue;
                int vertexId = this.graph.edgeSrcId(edgeId);
                int inputEdgeId = this.minInputEdgeIds.get(edgeId);
                int excess = 0;
                for (int j = i; j < edges.size() && this.minInputEdgeIds.get(edges.get(j)) == inputEdgeId; ++j) {
                    int edgeId2 = edges.get(j);
                    if (this.used[edgeId2]) continue;
                    if (this.graph.edgeSrcId(edgeId2) == vertexId) {
                        ++excess;
                    }
                    if (this.graph.edgeDstId(edgeId2) != vertexId) continue;
                    --excess;
                }
                if (excess != 1 && this.graph.edgeDstId(edgeId) != vertexId) continue;
                this.fillWalk(vertexId, polyline);
                this.maximizeWalk(polyline);
                walks.add(polyline.toArray());
            }
            Preconditions.checkState(this.edgesLeft == 0);
            S2BuilderGraph.canonicalizeEdgeChainOrder(this.minInputEdgeIds, walks);
            return walks;
        }

        private boolean isInterior(int vertexId) {
            return this.directed ? this.inMap.inDegree(vertexId) == 1 && this.outMap.outDegree(vertexId) == 1 : this.outMap.outDegree(vertexId) == 2;
        }

        private int excessDegree(int vertexId) {
            return this.directed ? this.outMap.outDegree(vertexId) - this.inMap.inDegree(vertexId) : this.outMap.outDegree(vertexId) % 2;
        }

        /*
         * Unable to fully structure code
         */
        private void fillPath(int edgeId, IntVector polyline) {
            polyline.clear();
            startVertexId = this.graph.edgeSrcId(edgeId);
            block0: while (true) {
                polyline.add(edgeId);
                Preconditions.checkState(this.used[edgeId] == false);
                this.used[edgeId] = true;
                if (!this.directed) {
                    this.used[this.siblingMap.get((int)edgeId)] = true;
                }
                --this.edgesLeft;
                vertexId = this.graph.edgeDstId(edgeId);
                if (!this.isInterior(vertexId) || vertexId == startVertexId) break;
                if (this.directed) {
                    Preconditions.checkState(this.outMap.outDegree(vertexId) == 1);
                    edgeId = this.outMap.edgeIds(vertexId).begin();
                    continue;
                }
                Preconditions.checkState(this.outMap.outDegree(vertexId) == 2);
                iter = this.outMap.edgeIds(vertexId).intIterator();
                while (true) {
                    if (iter.hasNext()) ** break;
                    continue block0;
                    edgeId2 = iter.nextInt();
                    if (this.used[edgeId2]) continue;
                    edgeId = edgeId2;
                }
                break;
            }
        }

        private void fillWalk(int vertexId, IntVector polyline) {
            polyline.clear();
            while (true) {
                int bestEdgeId = -1;
                int bestOutId = Integer.MAX_VALUE;
                Ints.OfInt outEdgeIter = this.outMap.edgeIds(vertexId).intIterator();
                while (outEdgeIter.hasNext()) {
                    int minInputEdgeId;
                    int edgeId = outEdgeIter.nextInt();
                    if (this.used[edgeId] || (minInputEdgeId = this.minInputEdgeIds.get(edgeId)) >= bestOutId) continue;
                    bestOutId = minInputEdgeId;
                    bestEdgeId = edgeId;
                }
                if (bestEdgeId < 0) {
                    return;
                }
                int excessUnused = this.excessDegree(vertexId) - this.excessUsed[vertexId];
                if (this.directed ? excessUnused < 0 : excessUnused % 2 == 1) {
                    Ints.OfInt inEdgeIter = this.inMap.edgeIds(vertexId).intIterator();
                    while (inEdgeIter.hasNext()) {
                        int inEdgeId = inEdgeIter.nextInt();
                        if (this.used[inEdgeId] || this.minInputEdgeIds.get(inEdgeId) > bestOutId) continue;
                        return;
                    }
                }
                polyline.add(bestEdgeId);
                this.used[bestEdgeId] = true;
                if (!this.directed) {
                    this.used[this.siblingMap.get((int)bestEdgeId)] = true;
                }
                --this.edgesLeft;
                vertexId = this.graph.edgeDstId(bestEdgeId);
            }
        }

        private void maximizeWalk(IntVector polyline) {
            IntVector loop = new IntVector();
            block0: for (int i = 0; i <= polyline.size(); ++i) {
                int vertexId = i == 0 ? this.graph.edgeSrcId(polyline.get(i)) : this.graph.edgeDstId(polyline.get(i - 1));
                Ints.OfInt outEdgeIter = this.outMap.edgeIds(vertexId).intIterator();
                while (outEdgeIter.hasNext()) {
                    int edgeId = outEdgeIter.nextInt();
                    if (this.used[edgeId]) continue;
                    this.fillWalk(vertexId, loop);
                    Preconditions.checkState(vertexId == this.graph.edgeDstId(loop.peek()));
                    polyline.insert(i, loop);
                    Preconditions.checkState(this.used[edgeId]);
                    continue block0;
                }
            }
        }
    }

    private static final class UndirectedComponentComparator
    implements Comparator<UndirectedComponent> {
        private final Ints.IntList minInputEdgeIds;

        public UndirectedComponentComparator(Ints.IntList minInputEdgeIds) {
            this.minInputEdgeIds = minInputEdgeIds;
        }

        @Override
        public int compare(UndirectedComponent a, UndirectedComponent b) {
            return Integer.compare(this.minInputEdgeIds.get(a.getComplement(0).get(0)[0]), this.minInputEdgeIds.get(b.getComplement(0).get(0)[0]));
        }
    }
}

