/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import java.io.IOException;
import java.util.List;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.common.utils.BBox;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2Loop;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Polygon;
import org.locationtech.jts.geom.Geometry;

public class GeoHashDecoder {
    private static final int[] bits = new int[]{16, 8, 4, 2, 1};
    private static final String base32 = "0123456789bcdefghjkmnpqrstuvwxyz";

    public static Geometry decode(String geohash, Integer precision) throws InvalidGeoHashException {
        return GeoHashDecoder.decodeGeoHashBBox(geohash, precision).getBbox().toPolygon();
    }

    public static Geography decodeGeog(String geohash, Integer precision) throws InvalidGeoHashException, IOException {
        BBox box = GeoHashDecoder.decodeGeoHashBBox(geohash, precision).getBbox();
        double south = box.startLat;
        double north = box.endLat;
        double west = box.startLon;
        double east = box.endLon;
        S2Point SW = S2LatLng.fromDegrees(south, west).toPoint();
        S2Point SE = S2LatLng.fromDegrees(south, east).toPoint();
        S2Point NE = S2LatLng.fromDegrees(north, east).toPoint();
        S2Point NW = S2LatLng.fromDegrees(north, west).toPoint();
        S2Loop shell = new S2Loop(List.of(SW, SE, NE, NW));
        shell.normalize();
        S2Polygon s2poly = new S2Polygon(shell);
        PolygonGeography geog = new PolygonGeography(s2poly);
        geog.setSRID(4326);
        return geog;
    }

    private static LatLon decodeGeoHashBBox(String geohash, Integer precision) throws InvalidGeoHashException {
        int geoHashLength;
        LatLon latLon = new LatLon(new Double[]{-180.0, 180.0}, new Double[]{-90.0, 90.0});
        String geoHashLowered = geohash.toLowerCase();
        int targetPrecision = geoHashLength = geohash.length();
        if (precision != null) {
            if (precision < 0) {
                throw new InvalidGeoHashException("Precision can not be negative");
            }
            targetPrecision = Math.min(geoHashLength, precision);
        }
        boolean isEven = true;
        for (int i = 0; i < targetPrecision; ++i) {
            char c = geoHashLowered.charAt(i);
            byte cd2 = (byte)base32.indexOf(c);
            if (cd2 == -1) {
                throw new InvalidGeoHashException(String.format("Invalid character '%s' found at index %d", Character.valueOf(c), i));
            }
            for (int j = 0; j < 5; ++j) {
                int index;
                byte mask = (byte)bits[j];
                int n = index = (mask & cd2) == 0 ? 1 : 0;
                if (isEven) {
                    latLon.lons[index] = (latLon.lons[0] + latLon.lons[1]) / 2.0;
                } else {
                    latLon.lats[index] = (latLon.lats[0] + latLon.lats[1]) / 2.0;
                }
                isEven = !isEven;
            }
        }
        return latLon;
    }

    private static class LatLon {
        public Double[] lons;
        public Double[] lats;

        public LatLon(Double[] lons, Double[] lats) {
            this.lons = lons;
            this.lats = lats;
        }

        BBox getBbox() {
            return new BBox(this.lons[0], this.lons[1], this.lats[0], this.lats[1]);
        }
    }

    public static class InvalidGeoHashException
    extends Exception {
        public InvalidGeoHashException(String message) {
            super(message);
        }
    }
}

