/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.approximate;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.Machine;
import org.twak.camp.Output;
import org.twak.camp.Skeleton;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;

public class StraightSkeleton {
    private static final Logger log = LoggerFactory.getLogger(StraightSkeleton.class);
    private static final double NORMALIZED_SIZE = 1000.0;
    private static final double DEFAULT_MACHINE_ANGLE = 0.7853981633974483;
    private static final double BOUNDARY_EDGE_EPSILON = 1.0E-10;

    public Geometry computeSkeleton(Polygon polygon, int maxVertices) {
        if (polygon == null || polygon.isEmpty()) {
            return null;
        }
        GeometryFactory factory = polygon.getFactory();
        try {
            Point centroid = polygon.getCentroid();
            double offsetX = centroid.getX();
            double offsetY = centroid.getY();
            Envelope envelope = polygon.getEnvelopeInternal();
            double maxDim = Math.max(envelope.getWidth(), envelope.getHeight());
            double scaleFactor = maxDim > 0.0 ? 1000.0 / maxDim : 1.0;
            Polygon normalizedPolygon = this.normalizePolygon(polygon, offsetX, offsetY, scaleFactor, maxVertices);
            LoopL<Edge> input = this.convertPolygonToEdges(normalizedPolygon);
            Skeleton skeleton = new Skeleton(input, true);
            skeleton.skeleton();
            if (skeleton.output == null || skeleton.output.edges == null) {
                log.warn("Campskeleton failed to produce output for polygon: {}", (Object)polygon.toText());
                return factory.createMultiLineString(new LineString[0]);
            }
            List<LineString> normalizedEdges = this.extractSkeletonEdges(skeleton, factory);
            if (normalizedEdges.isEmpty()) {
                log.warn("No skeleton edges extracted for polygon: {}", (Object)polygon.toText());
                return factory.createMultiLineString(new LineString[0]);
            }
            ArrayList<LineString> transformedEdges = new ArrayList<LineString>();
            for (LineString edge : normalizedEdges) {
                LineString transformed = this.transformLineStringBack(edge, offsetX, offsetY, scaleFactor);
                transformedEdges.add(transformed);
            }
            return factory.createMultiLineString(transformedEdges.toArray(new LineString[0]));
        }
        catch (Exception e) {
            log.error("Failed to compute straight skeleton for polygon: {}", (Object)polygon.toText(), (Object)e);
            throw new RuntimeException("Failed to compute straight skeleton: " + e.getMessage(), e);
        }
    }

    private Polygon normalizePolygon(Polygon polygon, double offsetX, double offsetY, double scaleFactor, int maxVertices) {
        GeometryFactory factory = polygon.getFactory();
        LinearRing normalizedShell = this.normalizeRing(polygon.getExteriorRing(), offsetX, offsetY, scaleFactor, maxVertices, factory);
        LinearRing[] normalizedHoles = new LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            normalizedHoles[i] = this.normalizeRing(polygon.getInteriorRingN(i), offsetX, offsetY, scaleFactor, maxVertices, factory);
        }
        return factory.createPolygon(normalizedShell, normalizedHoles);
    }

    private LinearRing normalizeRing(LineString ring, double offsetX, double offsetY, double scaleFactor, int maxVertices, GeometryFactory factory) {
        Coordinate[] coords = ring.getCoordinates();
        List<Coordinate> normalizedCoords = new ArrayList<Coordinate>();
        for (int i = 0; i < coords.length - 1; ++i) {
            double x = (coords[i].x - offsetX) * scaleFactor;
            double y = (coords[i].y - offsetY) * scaleFactor;
            normalizedCoords.add(new Coordinate(x, y));
        }
        if (maxVertices > 0 && normalizedCoords.size() > maxVertices) {
            normalizedCoords = this.simplifyByMergingShortestEdges(normalizedCoords, maxVertices);
        }
        normalizedCoords.add(new Coordinate((Coordinate)normalizedCoords.get(0)));
        Coordinate[] coordArray = normalizedCoords.toArray(new Coordinate[0]);
        return factory.createLinearRing(coordArray);
    }

    private List<Coordinate> simplifyByMergingShortestEdges(List<Coordinate> coords, int targetVertexCount) {
        targetVertexCount = Math.max(3, targetVertexCount);
        ArrayList<Coordinate> result = new ArrayList<Coordinate>(coords);
        while (result.size() > targetVertexCount) {
            double minLength = Double.MAX_VALUE;
            int shortestEdgeIdx = -1;
            for (int i = 0; i < result.size(); ++i) {
                Coordinate next;
                Coordinate curr = (Coordinate)result.get(i);
                double length = curr.distance(next = (Coordinate)result.get((i + 1) % result.size()));
                if (!(length < minLength)) continue;
                minLength = length;
                shortestEdgeIdx = i;
            }
            int vertexToRemove = (shortestEdgeIdx + 1) % result.size();
            result.remove(vertexToRemove);
        }
        return result;
    }

    private LineString transformLineStringBack(LineString lineString, double offsetX, double offsetY, double scaleFactor) {
        Coordinate[] coords = lineString.getCoordinates();
        Coordinate[] transformedCoords = new Coordinate[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            double x = coords[i].x / scaleFactor + offsetX;
            double y = coords[i].y / scaleFactor + offsetY;
            transformedCoords[i] = new Coordinate(x, y);
        }
        return lineString.getFactory().createLineString(transformedCoords);
    }

    private LoopL<Edge> convertPolygonToEdges(Polygon polygon) {
        LoopL<Edge> input = new LoopL<Edge>();
        Machine defaultMachine = new Machine(0.7853981633974483);
        Loop<Edge> exteriorLoop = this.convertRingToLoop(polygon.getExteriorRing(), true, defaultMachine);
        input.add((Edge)((Object)exteriorLoop));
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            Loop<Edge> holeLoop = this.convertRingToLoop(polygon.getInteriorRingN(i), false, defaultMachine);
            input.add((Edge)((Object)holeLoop));
        }
        return input;
    }

    private Loop<Edge> convertRingToLoop(LineString ring, boolean isExterior, Machine machine) {
        int i;
        boolean needsReverse;
        Loop<Edge> loop = new Loop<Edge>();
        Coordinate[] coords = ring.getCoordinates();
        boolean isCCW = Orientation.isCCW(coords);
        boolean bl = needsReverse = isExterior && !isCCW || !isExterior && isCCW;
        if (needsReverse) {
            Coordinate[] reversed = new Coordinate[coords.length];
            for (i = 0; i < coords.length - 1; ++i) {
                reversed[i] = coords[coords.length - 2 - i];
            }
            reversed[coords.length - 1] = reversed[0];
            coords = reversed;
        }
        ArrayList<Corner> corners = new ArrayList<Corner>();
        for (i = 0; i < coords.length - 1; ++i) {
            Coordinate c = coords[i];
            corners.add(new Corner(c.x, c.y));
        }
        for (i = 0; i < corners.size(); ++i) {
            Corner c1 = (Corner)corners.get(i);
            Corner c2 = (Corner)corners.get((i + 1) % corners.size());
            Edge edge = new Edge(c1, c2);
            edge.machine = machine;
            loop.append((Edge[])new Edge[]{edge});
        }
        return loop;
    }

    private List<LineString> extractSkeletonEdges(Skeleton skeleton, GeometryFactory factory) {
        ArrayList<LineString> edges = new ArrayList<LineString>();
        for (Output.SharedEdge edge : skeleton.output.edges.map.values()) {
            Coordinate c2;
            Coordinate c1;
            Point3d start = edge.start;
            Point3d end = edge.end;
            boolean isBoundaryEdge = Math.abs(start.z) < 1.0E-10 && Math.abs(end.z) < 1.0E-10;
            if (isBoundaryEdge || (c1 = new Coordinate(start.x, start.y)).equals2D(c2 = new Coordinate(end.x, end.y))) continue;
            LineString lineString = factory.createLineString(new Coordinate[]{c1, c2});
            edges.add(lineString);
        }
        return edges;
    }
}

