/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.Structure;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamDataCol;
import ucar.nc2.stream.NcStreamProto;

public class NcStreamReader {
    private static final Logger logger = LoggerFactory.getLogger(NcStreamReader.class);
    private static final boolean debug = false;
    private static final boolean showDeflate = false;
    private static double total_uncompressedSize;
    private static double total_compressedSize;

    public static double getCompression(boolean reset) {
        double result = total_uncompressedSize / total_compressedSize;
        if (reset) {
            total_compressedSize = 0.0;
            total_uncompressedSize = 0.0;
        }
        return result;
    }

    public NetcdfFile readStream(InputStream is, NetcdfFile ncfile) throws IOException {
        byte[] b = new byte[4];
        NcStream.readFully(is, b);
        if (NcStream.test(b, NcStream.MAGIC_START) ? !NcStream.readAndTest(is, NcStream.MAGIC_HEADER) : !NcStream.test(b, NcStream.MAGIC_HEADER)) {
            throw new IOException("Data corrupted on " + ncfile.getLocation());
        }
        int msize = NcStream.readVInt(is);
        byte[] m3 = new byte[msize];
        NcStream.readFully(is, m3);
        NcStreamProto.Header proto = NcStreamProto.Header.parseFrom(m3);
        ncfile = this.proto2nc(proto, ncfile);
        return ncfile;
    }

    public DataResult readData(InputStream is, NetcdfFile ncfile, String location) throws IOException {
        byte[] b = new byte[4];
        int bytesRead = NcStream.readFully(is, b);
        if (bytesRead < b.length) {
            throw new EOFException(location);
        }
        if (NcStream.test(b, NcStream.MAGIC_DATA)) {
            return this.readData1(is, ncfile);
        }
        if (NcStream.test(b, NcStream.MAGIC_DATA2)) {
            return this.readData2(is);
        }
        throw new IOException("Data transfer corrupted on " + location);
    }

    private DataResult readData1(InputStream is, NetcdfFile ncfile) throws IOException {
        Array data;
        Section section;
        int psize = NcStream.readVInt(is);
        byte[] dp = new byte[psize];
        NcStream.readFully(is, dp);
        NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
        ByteOrder bo = NcStream.decodeDataByteOrder(dproto);
        DataType dataType = NcStream.convertDataType(dproto.getDataType());
        Section section2 = section = dataType == DataType.SEQUENCE ? new Section() : NcStream.decodeSection(dproto.getSection());
        if (dataType == DataType.STRING) {
            int nobjs = NcStream.readVInt(is);
            Array data2 = Array.factory(dataType, section.getShape());
            assert ((long)nobjs == section.computeSize());
            IndexIterator ii = data2.getIndexIterator();
            while (ii.hasNext()) {
                int slen = NcStream.readVInt(is);
                byte[] sb = new byte[slen];
                NcStream.readFully(is, sb);
                ii.setObjectNext(new String(sb, StandardCharsets.UTF_8));
            }
            return new DataResult(dproto.getVarName(), data2);
        }
        if (dataType == DataType.OPAQUE) {
            int nobjs = NcStream.readVInt(is);
            Array data3 = Array.factory(dataType, section.getShape());
            assert ((long)nobjs == section.computeSize());
            IndexIterator ii = data3.getIndexIterator();
            while (ii.hasNext()) {
                int slen = NcStream.readVInt(is);
                byte[] sb = new byte[slen];
                NcStream.readFully(is, sb);
                ii.setObjectNext(ByteBuffer.wrap(sb));
            }
            return new DataResult(dproto.getVarName(), data3);
        }
        int dsize = NcStream.readVInt(is);
        byte[] datab = new byte[dsize];
        NcStream.readFully(is, datab);
        if (dataType == DataType.STRUCTURE) {
            Structure s2 = (Structure)ncfile.findVariable(dproto.getVarName());
            StructureMembers members = s2.makeStructureMembers();
            if (dproto.getVersion() == 0) {
                ArrayStructureBB.setOffsets(members);
                ArrayStructureBB data4 = new ArrayStructureBB(members, section.getShape(), ByteBuffer.wrap(datab), 0);
                return new DataResult(dproto.getVarName(), data4);
            }
            ArrayStructureBB data5 = NcStream.decodeArrayStructure(members, section.getShape(), datab);
            return new DataResult(dproto.getVarName(), data5);
        }
        NcStreamProto.Compress compress = dproto.getCompress();
        int uncompressedSize = dproto.getUncompressedSize();
        if (compress == NcStreamProto.Compress.DEFLATE) {
            ByteArrayInputStream bin = new ByteArrayInputStream(datab);
            InflaterInputStream in = new InflaterInputStream(bin);
            byte[] resultb = new byte[uncompressedSize];
            NcStream.readFully(in, resultb);
            data = Array.factory(dataType, section.getShape(), ByteBuffer.wrap(resultb));
            total_uncompressedSize += (double)uncompressedSize;
            total_compressedSize += (double)dsize;
        } else {
            data = Array.factory(dataType, section.getShape(), ByteBuffer.wrap(datab));
        }
        return new DataResult(dproto.getVarName(), data);
    }

    private DataResult readData2(InputStream is) throws IOException {
        int psize = NcStream.readVInt(is);
        byte[] dp = new byte[psize];
        NcStream.readFully(is, dp);
        NcStreamProto.DataCol dproto = NcStreamProto.DataCol.parseFrom(dp);
        NcStreamDataCol decoder = new NcStreamDataCol();
        Array data = decoder.decode(dproto, null);
        return new DataResult(dproto.getName(), data);
    }

    public StructureDataIterator getStructureIterator(InputStream is, NetcdfFile ncfile) throws IOException {
        if (!NcStream.readAndTest(is, NcStream.MAGIC_DATA)) {
            throw new IOException("Data transfer corrupted on " + ncfile.getLocation());
        }
        int psize = NcStream.readVInt(is);
        byte[] dp = new byte[psize];
        NcStream.readFully(is, dp);
        NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
        Structure s2 = (Structure)ncfile.findVariable(dproto.getVarName());
        StructureMembers members = s2.makeStructureMembers();
        ArrayStructureBB.setOffsets(members);
        ByteOrder bo = NcStream.decodeDataByteOrder(dproto);
        return new StreamDataIterator(is, members, bo);
    }

    private NetcdfFile proto2nc(NcStreamProto.Header proto, NetcdfFile ncfile) {
        if (ncfile == null) {
            ncfile = new NetcdfFileSubclass();
        }
        ncfile.setLocation(proto.getLocation());
        if (!proto.getId().isEmpty()) {
            ncfile.setId(proto.getId());
        }
        if (!proto.getTitle().isEmpty()) {
            ncfile.setTitle(proto.getTitle());
        }
        NcStreamProto.Group root = proto.getRoot();
        Group.Builder rootBuilder = Group.builder().setNcfile(ncfile).setName("");
        NcStream.readGroup(root, rootBuilder);
        ncfile.setRootGroup(rootBuilder.build());
        ncfile.finish();
        return ncfile;
    }

    private static class StreamDataIterator
    implements StructureDataIterator {
        private InputStream is;
        private StructureMembers members;
        private StructureData curr;
        private ByteOrder bo;
        private int count;
        private boolean done;

        StreamDataIterator(InputStream is, StructureMembers members, ByteOrder bo) {
            this.is = is;
            this.members = members;
            this.bo = bo;
        }

        @Override
        public boolean hasNext() throws IOException {
            if (!this.done) {
                this.readNext();
            }
            return this.curr != null;
        }

        @Override
        public StructureData next() {
            ++this.count;
            return this.curr;
        }

        private void readNext() throws IOException {
            byte[] b = new byte[4];
            NcStream.readFully(this.is, b);
            if (NcStream.test(b, NcStream.MAGIC_VDATA)) {
                int dsize = NcStream.readVInt(this.is);
                byte[] datab = new byte[dsize];
                NcStream.readFully(this.is, datab);
            } else if (NcStream.test(b, NcStream.MAGIC_VEND)) {
                this.curr = null;
                this.close();
            } else {
                throw new IllegalStateException("bad stream");
            }
        }

        @Override
        public StructureDataIterator reset() {
            return this.count == 0 && this.is != null ? this : null;
        }

        @Override
        public int getCurrentRecno() {
            return this.count;
        }

        @Override
        public void close() {
            this.done = true;
            if (this.is != null) {
                try {
                    this.is.close();
                    this.is = null;
                }
                catch (IOException ioe) {
                    logger.error("NcStreamReader: Error closing input stream.");
                }
            }
        }
    }

    public static class DataResult {
        public String varNameFullEsc;
        public Array data;

        DataResult(String varName, Array data) {
            this.varNameFullEsc = varName;
            this.data = data;
        }
    }
}

