/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.VertTransformBuilderIF;
import ucar.unidata.geoloc.vertical.OceanSigma;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class CFOceanSigma
extends AbstractTransformBuilder
implements VertTransformBuilderIF {
    private String sigma;
    private String eta;
    private String depth;

    @Override
    public String getTransformName() {
        return VerticalCT.Type.OceanSigma.name();
    }

    @Override
    public VerticalCT makeCoordinateTransform(NetcdfDataset ds, AttributeContainer ctv) {
        String formula_terms = this.getFormula(ctv);
        if (null == formula_terms) {
            return null;
        }
        String[] values = this.parseFormula(formula_terms, "sigma eta depth");
        if (values == null) {
            return null;
        }
        this.sigma = values[0];
        this.eta = values[1];
        this.depth = values[2];
        VerticalCT rs = new VerticalCT("OceanSigma_Transform_" + ctv.getName(), this.getTransformName(), VerticalCT.Type.OceanSigma, this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("height_formula", "height(x,y,z) = eta(n,j,i) + sigma(k)*(depth(j,i)+eta(n,j,i))"));
        if (!this.addParameter(rs, "Sigma_variableName", ds, this.sigma)) {
            return null;
        }
        if (!this.addParameter(rs, "Eta_variableName", ds, this.eta)) {
            return null;
        }
        if (!this.addParameter(rs, "Depth_variableName", ds, this.depth)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "OceanS: sigma:" + this.sigma + " eta:" + this.eta + " depth:" + this.depth;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new OceanSigma(ds, timeDim, vCT.getParameters());
    }
}

