/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StringTree<E> {
    public Map<String, StringTree<E>> children = new HashMap<String, StringTree<E>>();
    public Map<String, E> contents = new HashMap<String, E>();

    public void add(String s2, E e) {
        String[] tokens = s2.split("/");
        StringTree tree = this;
        for (int i = 0; i < tokens.length - 1; ++i) {
            tree = tree.getOrCreateChild(tokens[i]);
        }
        tree.contents.put(tokens[tokens.length - 1], e);
    }

    public StringTree getOrCreateChild(String s2) {
        if (this.contents.containsKey(s2)) {
            throw new ThatsADirectoryError();
        }
        StringTree<E> child = this.children.get(s2);
        if (child == null) {
            child = new StringTree<E>();
            this.children.put(s2, child);
        }
        return child;
    }

    public boolean isChild(String s2) {
        return this.children.containsKey(s2);
    }

    public E get(String s2) {
        if (s2 == null) {
            return null;
        }
        String[] tokens = s2.split("/");
        StringTree<E> tree = this;
        for (int i = 0; i < tokens.length - 1; ++i) {
            tree = tree.children.get(tokens[i]);
            if (tree != null) continue;
            return null;
        }
        return tree.contents.get(tokens[tokens.length - 1]);
    }

    public Iterable<E> recursiveAll() {
        ArrayList out = new ArrayList();
        this.recursiveAll_(out);
        return out;
    }

    private void recursiveAll_(List<E> out) {
        out.addAll(this.contents.values());
        for (StringTree<E> st : this.children.values()) {
            st.recursiveAll_(out);
        }
    }

    private static class ThatsADirectoryError
    extends Error {
        private ThatsADirectoryError() {
        }
    }
}

