/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortedList<E>
extends AbstractList<E>
implements Iterable<E> {
    private ArrayList<E> internalList = new ArrayList();
    public Comparator<E> sorter = null;

    public SortedList(Comparator<E> sorter) {
        this.sorter = sorter;
    }

    public SortedList(Comparator<E> sorter, List<E> values) {
        this(sorter);
        this.internalList = new ArrayList<E>(values);
    }

    @Override
    public void add(int position, E e) {
        this.internalList.add(e);
        if (this.sorter != null) {
            Collections.sort(this.internalList, this.sorter);
        }
    }

    protected void addNoSort(E e) {
        this.internalList.add(e);
    }

    @Override
    public E get(int i) {
        return this.internalList.get(i);
    }

    @Override
    public int size() {
        return this.internalList.size();
    }
}

