/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.debug;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.Output;
import org.twak.camp.Skeleton;
import org.twak.camp.debug.JDebugDevice;
import org.twak.utils.Cache;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;

public class DebugDevice {
    public static boolean debug;
    public static DebugDevice instance;
    List<Status> toDisplay = new ArrayList<Status>();
    JFrame window = null;
    private JDebugDevice jDD;

    public static void reset() {
        DebugDevice.instance.toDisplay.clear();
        instance.push();
    }

    public static void dump(String name, Skeleton skel) {
        if (!debug) {
            return;
        }
        DebugDevice.instance.toDisplay.add(new Status(skel.name + ":" + name, Corner.dupeNewAll(skel.findLoopLive()), skel.output.dupeEdgesOnly()));
        DebugDevice.push();
    }

    public static void dump(String name, LoopL<Corner> corners) {
        if (!debug) {
            return;
        }
        DebugDevice.instance.toDisplay.add(new Status(name, Corner.dupeNewAll(corners), null));
        DebugDevice.push();
    }

    public static void dumpPoints(String name, LoopL<Point3d> points) {
        if (!debug) {
            return;
        }
        LoopL<Corner> loopl = new LoopL<Corner>();
        Cache<Point3d, Corner> cCache = new Cache<Point3d, Corner>(){

            @Override
            public Corner create(Point3d i) {
                return new Corner(i.x, i.y, i.y);
            }
        };
        for (Loop loop : points) {
            Loop<Corner> loop2 = new Loop<Corner>();
            loopl.add((Corner)((Object)loop2));
            for (Loopable loopable : loop.loopableIterator()) {
                Corner me = (Corner)cCache.get((Point3d)loopable.get());
                Corner yu = (Corner)cCache.get((Point3d)loopable.get());
                loop2.append(me);
                me.nextC = yu;
                yu.prevC = me;
                yu.prevL = me.nextL = new Edge(me, yu);
            }
        }
        DebugDevice.instance.toDisplay.add(new Status(name, loopl, null));
        DebugDevice.push();
    }

    public static void push() {
        if (!debug) {
            return;
        }
        instance.push_();
    }

    private void push_() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DebugDevice.this.window == null) {
                    DebugDevice.this.window = new JFrame(this.getClass().getSimpleName());
                    DebugDevice.this.window.setSize(800, 800);
                    DebugDevice.this.window.setVisible(true);
                    DebugDevice.this.jDD = new JDebugDevice(DebugDevice.this);
                    DebugDevice.this.window.setContentPane(DebugDevice.this.jDD);
                    DebugDevice.this.window.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            DebugDevice.instance.window = null;
                        }
                    });
                }
                DebugDevice.this.jDD.pingChanged();
            }
        });
    }

    static {
        instance = new DebugDevice();
    }

    static class Status {
        LoopL<Corner> corners;
        Output output;
        String name;

        public Status(String name, LoopL<Corner> corners, Output output) {
            this.name = name;
            this.corners = corners;
            this.output = output;
        }

        public String toString() {
            return this.name;
        }
    }
}

