/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.util;

import java.util.function.Predicate;
import org.tinspin.index.BoxDistance;
import org.tinspin.index.BoxMultimap;
import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;
import org.tinspin.index.PointMultimap;
import org.tinspin.index.Stats;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeEntry;

public class PointMultimapWrapper<T>
implements PointMultimap<T> {
    private final BoxMultimap<T> ind;

    private PointMultimapWrapper(BoxMultimap<T> ind) {
        this.ind = ind;
    }

    public static <T> PointMultimap<T> create(BoxMultimap<T> ind) {
        return new PointMultimapWrapper<T>(ind);
    }

    @Override
    public Index.PointIterator<T> iterator() {
        return new PointIter<T>(this.ind.iterator());
    }

    @Override
    public Index.PointIterator<T> query(double[] min2, double[] max) {
        return new PointIter<T>(this.ind.queryIntersect(min2, max));
    }

    @Override
    public Index.PointEntryKnn<T> query1nn(double[] center) {
        Index.BoxEntryKnn<T> r = this.ind.query1nn(center);
        return new Index.PointEntryKnn(r.min(), r.value(), r.dist());
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k) {
        return new PointDIter<T>(this.ind.queryKnn(center, k));
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k, PointDistance distFn) {
        BoxDistance.EdgeDistance fn = new BoxDistance.EdgeDistance(distFn);
        return new PointDIter<T>(this.ind.queryKnn(center, k, fn::edgeDistance));
    }

    @Override
    public void insert(double[] key, T value) {
        this.ind.insert(key, key, value);
    }

    @Override
    public boolean remove(double[] point, T value) {
        return this.ind.remove(point, point, value);
    }

    @Override
    public boolean removeIf(double[] point, Predicate<Index.PointEntry<T>> condition) {
        return this.ind.removeIf(point, point, e -> condition.test(new Index.PointEntry(e.min(), e.value())));
    }

    @Override
    public Index.PointIterator<T> queryExactPoint(double[] point) {
        return new PointIter<T>(this.ind.queryExactBox(point, point));
    }

    @Override
    public boolean update(double[] oldPoint, double[] newPoint, T value) {
        return this.ind.update(oldPoint, oldPoint, newPoint, newPoint, value);
    }

    @Override
    public boolean contains(double[] point, T value) {
        return this.ind.contains(point, point, value);
    }

    @Override
    public int getDims() {
        return this.ind.getDims();
    }

    @Override
    public int size() {
        return this.ind.size();
    }

    @Override
    public void clear() {
        this.ind.clear();
    }

    @Override
    public Stats getStats() {
        return this.ind.getStats();
    }

    @Override
    public int getNodeCount() {
        return this.ind.getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.ind.getDepth();
    }

    public void load(RTreeEntry<T>[] entries) {
        if (!(this.ind instanceof RTree)) {
            throw new UnsupportedOperationException("Bulkloading is only supported for RTrees");
        }
        ((RTree)this.ind).load(entries);
    }

    @Override
    public String toStringTree() {
        return this.ind.toStringTree();
    }

    private static class PointDIter<T>
    implements Index.PointIteratorKnn<T> {
        private final Index.BoxIteratorKnn<T> it;

        PointDIter(Index.BoxIteratorKnn<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Index.PointEntryKnn<T> next() {
            Index.BoxEntryKnn e = (Index.BoxEntryKnn)this.it.next();
            return new Index.PointEntryKnn(e.min(), e.value(), e.dist());
        }

        @Override
        public PointDIter<T> reset(double[] center, int k) {
            this.it.reset(center, k);
            return this;
        }
    }

    private static class PointIter<T>
    implements Index.PointIterator<T> {
        private final Index.BoxIterator<T> it;

        PointIter(Index.BoxIterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Index.PointEntry<T> next() {
            Index.BoxEntry e = (Index.BoxEntry)this.it.next();
            return new Index.PointEntry(e.min(), e.value());
        }

        @Override
        public Index.PointIterator<T> reset(double[] min2, double[] max) {
            this.it.reset(min2, max);
            return this;
        }
    }
}

