/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index;

import org.tinspin.index.Index;

@FunctionalInterface
public interface PointDistance {
    public static final PointDistance L1 = PointDistance::l1;
    public static final PointDistance L2 = PointDistance::l2;

    public double dist(double[] var1, double[] var2);

    default public double dist(double[] p1, Index.PointEntry<?> entry) {
        return this.dist(p1, entry.point());
    }

    public static double l1(double[] p1, double[] p2) {
        double dist = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double d = Math.abs(p1[i] - p2[i]);
            dist += d;
        }
        return dist;
    }

    public static double l2(double[] p1, double[] p2) {
        double dist = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double d = p1[i] - p2[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public static String getName(PointDistance fn) {
        if (fn == L1) {
            return "L1";
        }
        if (fn == L2) {
            return "L2";
        }
        return "unknown";
    }
}

