/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.lib;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.storage.StorageLevel;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.Logging;
import org.graphframes.lib.AggregateMessages;
import org.graphframes.lib.AggregateMessages$;
import org.slf4j.Logger;
import scala.Function0;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class TriangleCount$
implements Logging,
Serializable {
    public static final TriangleCount$ MODULE$ = new TriangleCount$();
    private static final String COUNT_ID;
    private static transient Logger org$graphframes$Logging$$logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$(MODULE$);
        COUNT_ID = "count";
    }

    @Override
    public void logDebug(Function0<String> s2) {
        Logging.logDebug$(this, s2);
    }

    @Override
    public void logWarn(Function0<String> s2) {
        Logging.logWarn$(this, s2);
    }

    @Override
    public void logInfo(Function0<String> s2) {
        Logging.logInfo$(this, s2);
    }

    @Override
    public void logTrace(Function0<String> s2) {
        Logging.logTrace$(this, s2);
    }

    @Override
    public void resultIsPersistent() {
        Logging.resultIsPersistent$(this);
    }

    private Logger org$graphframes$Logging$$logger$lzycompute() {
        TriangleCount$ triangleCount$ = this;
        synchronized (triangleCount$) {
            if (!bitmap$trans$0) {
                org$graphframes$Logging$$logger = Logging.org$graphframes$Logging$$logger$(this);
                bitmap$trans$0 = true;
            }
        }
        return org$graphframes$Logging$$logger;
    }

    @Override
    public Logger org$graphframes$Logging$$logger() {
        if (!bitmap$trans$0) {
            return this.org$graphframes$Logging$$logger$lzycompute();
        }
        return org$graphframes$Logging$$logger;
    }

    private GraphFrame prepareGraph(GraphFrame graph) {
        Dataset dedupedE = graph.edges().filter(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$eq$bang$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST()))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.when(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$less((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST())), (Object)functions$.MODULE$.col(GraphFrame$.MODULE$.SRC())).otherwise((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.when(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$less((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST())), (Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).otherwise((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.SRC())).as(GraphFrame$.MODULE$.DST())})).distinct();
        return GraphFrame$.MODULE$.apply((Dataset<Row>)graph.vertices().select(GraphFrame$.MODULE$.ID(), (Seq)Nil$.MODULE$), (Dataset<Row>)dedupedE).dropIsolatedVertices();
    }

    public Dataset<Row> org$graphframes$lib$TriangleCount$$run(GraphFrame graph, StorageLevel intermediateStorageLevel) {
        GraphFrame g2 = this.prepareGraph(graph);
        Dataset<Row> verticesWithNeighbors = ((AggregateMessages)g2.aggregateMessages().setIntermediateStorageLevel(intermediateStorageLevel)).sendToSrc(AggregateMessages$.MODULE$.dst().apply((Object)GraphFrame$.MODULE$.ID())).sendToDst(AggregateMessages$.MODULE$.src().apply((Object)GraphFrame$.MODULE$.ID())).agg(functions$.MODULE$.collect_set(AggregateMessages$.MODULE$.msg()).alias("neighbors"));
        Dataset triangles = verticesWithNeighbors.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.ID()), functions$.MODULE$.col("neighbors").alias("src_set")})).join(g2.edges(), functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()))).drop(GraphFrame$.MODULE$.ID()).join(verticesWithNeighbors.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.ID()), functions$.MODULE$.col("neighbors").alias("dst_set")})), functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST()))).drop(GraphFrame$.MODULE$.ID()).withColumn("triplets", functions$.MODULE$.array_size(functions$.MODULE$.array_intersect(functions$.MODULE$.col("src_set"), functions$.MODULE$.col("dst_set")))).filter(functions$.MODULE$.col("triplets").$greater((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0)))).persist(intermediateStorageLevel);
        Dataset srcTriangles = triangles.groupBy(GraphFrame$.MODULE$.SRC(), (Seq)Nil$.MODULE$).agg(functions$.MODULE$.sum(functions$.MODULE$.col("triplets")).alias("src_triplets"), (Seq)Nil$.MODULE$);
        Dataset dstTriangles = triangles.groupBy(GraphFrame$.MODULE$.DST(), (Seq)Nil$.MODULE$).agg(functions$.MODULE$.sum(functions$.MODULE$.col("triplets")).alias("dst_triplets"), (Seq)Nil$.MODULE$);
        Dataset result = graph.vertices().join(srcTriangles, functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.SRC())), "left_outer").join(dstTriangles, functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST())), "left_outer").withColumn(this.COUNT_ID(), functions$.MODULE$.floor(functions$.MODULE$.when(functions$.MODULE$.col("src_triplets").isNull().$amp$amp((Object)functions$.MODULE$.col("dst_triplets").isNull()), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0))).when(functions$.MODULE$.col("src_triplets").isNull(), (Object)functions$.MODULE$.col("dst_triplets")).when(functions$.MODULE$.col("dst_triplets").isNull(), (Object)functions$.MODULE$.col("src_triplets")).otherwise((Object)functions$.MODULE$.col("src_triplets").$plus((Object)functions$.MODULE$.col("dst_triplets"))).$div((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)))));
        result.persist(intermediateStorageLevel);
        result.count();
        verticesWithNeighbors.unpersist();
        triangles.unpersist();
        this.resultIsPersistent();
        return result;
    }

    private String COUNT_ID() {
        return COUNT_ID;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TriangleCount$.class);
    }

    private TriangleCount$() {
    }
}

